/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rating.script;

import java.util.Date;
import java.util.Set;
import org.alfresco.repo.jscript.BaseScopableProcessorExtension;
import org.alfresco.repo.jscript.ScriptNode;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.rating.Rating;
import org.alfresco.service.cmr.rating.RatingService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ScriptRatingService
extends BaseScopableProcessorExtension {
    private static Log logger = LogFactory.getLog(ScriptRatingService.class);
    private ServiceRegistry serviceRegistry;
    private RatingService ratingService;

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
        this.ratingService = serviceRegistry.getRatingService();
    }

    public String[] getRatingSchemeNames() {
        Set<String> schemeNames = this.ratingService.getRatingSchemes().keySet();
        String[] result = new String[]{};
        result = schemeNames.toArray(result);
        return result;
    }

    public float getMin(String ratingSchemeName) {
        return this.ratingService.getRatingScheme(ratingSchemeName).getMinRating();
    }

    public float getMax(String ratingSchemeName) {
        return this.ratingService.getRatingScheme(ratingSchemeName).getMaxRating();
    }

    public void applyRating(ScriptNode node, float rating, String ratingSchemeName) {
        this.ratingService.applyRating(node.getNodeRef(), rating, ratingSchemeName);
    }

    public void removeRating(ScriptNode node, String ratingSchemeName) {
        this.ratingService.removeRatingByCurrentUser(node.getNodeRef(), ratingSchemeName);
    }

    public float getRating(ScriptNode node, String ratingSchemeName) {
        Rating ratingByCurrentUser = this.ratingService.getRatingByCurrentUser(node.getNodeRef(), ratingSchemeName);
        return ratingByCurrentUser == null ? -1.0f : ratingByCurrentUser.getScore();
    }

    public Date getRatingAppliedAt(ScriptNode node, String ratingSchemeName) {
        Rating ratingByCurrentUser = this.ratingService.getRatingByCurrentUser(node.getNodeRef(), ratingSchemeName);
        return ratingByCurrentUser == null ? null : ratingByCurrentUser.getAppliedAt();
    }

    public int getRatingsCount(ScriptNode node, String ratingSchemeName) {
        return this.ratingService.getRatingsCount(node.getNodeRef(), ratingSchemeName);
    }

    public float getTotalRating(ScriptNode node, String ratingSchemeName) {
        return this.ratingService.getTotalRating(node.getNodeRef(), ratingSchemeName);
    }

    public float getAverageRating(ScriptNode node, String ratingSchemeName) {
        return this.ratingService.getAverageRating(node.getNodeRef(), ratingSchemeName);
    }
}

