/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.remote;

import java.util.List;
import org.alfresco.service.cmr.model.FileExistsException;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.remote.FileFolderRemote;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.springframework.remoting.rmi.RmiProxyFactoryBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileFolderRemoteClient
implements FileFolderRemote {
    private String rmiUrl;
    private FileFolderRemote remotePeer;

    public FileFolderRemoteClient(String rmiUrl) {
        if (!rmiUrl.endsWith("/")) {
            rmiUrl = rmiUrl + "/";
        }
        this.rmiUrl = rmiUrl;
        this.connect();
    }

    private void connect() {
        FileFolderRemote fileFolderRemote;
        RmiProxyFactoryBean fileFolderFactory = new RmiProxyFactoryBean();
        fileFolderFactory.setRefreshStubOnConnectFailure(true);
        fileFolderFactory.setServiceInterface(FileFolderRemote.class);
        fileFolderFactory.setServiceUrl(this.rmiUrl + "org.alfresco.FileFolderRemote");
        fileFolderFactory.afterPropertiesSet();
        this.remotePeer = fileFolderRemote = (FileFolderRemote)fileFolderFactory.getObject();
    }

    @Override
    public List<FileInfo> list(String ticket, NodeRef contextNodeRef) {
        return this.remotePeer.list(ticket, contextNodeRef);
    }

    @Override
    public List<FileInfo> listFiles(String ticket, NodeRef folderNodeRef) {
        return this.remotePeer.listFiles(ticket, folderNodeRef);
    }

    @Override
    public List<FileInfo> listFolders(String ticket, NodeRef contextNodeRef) {
        return this.remotePeer.listFolders(ticket, contextNodeRef);
    }

    @Override
    public NodeRef searchSimple(String ticket, NodeRef contextNodeRef, String name) {
        return this.remotePeer.searchSimple(ticket, contextNodeRef, name);
    }

    @Override
    public List<FileInfo> search(String ticket, NodeRef contextNodeRef, String namePattern, boolean includeSubFolders) {
        return this.remotePeer.search(ticket, contextNodeRef, namePattern, includeSubFolders);
    }

    @Override
    public List<FileInfo> search(String ticket, NodeRef contextNodeRef, String namePattern, boolean fileSearch, boolean folderSearch, boolean includeSubFolders) {
        return this.remotePeer.search(ticket, contextNodeRef, namePattern, fileSearch, folderSearch, includeSubFolders);
    }

    @Override
    public FileInfo rename(String ticket, NodeRef fileFolderRef, String newName) throws FileExistsException, FileNotFoundException {
        return this.remotePeer.rename(ticket, fileFolderRef, newName);
    }

    @Override
    public FileInfo move(String ticket, NodeRef sourceNodeRef, NodeRef targetParentRef, String newName) throws FileExistsException, FileNotFoundException {
        return this.remotePeer.move(ticket, sourceNodeRef, targetParentRef, newName);
    }

    @Override
    public FileInfo copy(String ticket, NodeRef sourceNodeRef, NodeRef targetParentRef, String newName) throws FileExistsException, FileNotFoundException {
        return this.remotePeer.copy(ticket, sourceNodeRef, targetParentRef, newName);
    }

    @Override
    public FileInfo create(String ticket, NodeRef parentNodeRef, String name, QName typeQName) throws FileExistsException {
        return this.remotePeer.create(ticket, parentNodeRef, name, typeQName);
    }

    @Override
    public FileInfo[] create(String ticket, NodeRef[] parentNodeRefs, String[] names, QName[] typesQName) throws FileExistsException {
        return this.remotePeer.create(ticket, parentNodeRefs, names, typesQName);
    }

    @Override
    public void delete(String ticket, NodeRef nodeRef) {
        this.remotePeer.delete(ticket, nodeRef);
    }

    @Override
    public void delete(String ticket, NodeRef[] nodeRefs) {
        this.remotePeer.delete(ticket, nodeRefs);
    }

    @Override
    public FileInfo makeFolders(String ticket, NodeRef parentNodeRef, List<String> pathElements, QName folderTypeQName) {
        return this.remotePeer.makeFolders(ticket, parentNodeRef, pathElements, folderTypeQName);
    }

    @Override
    public List<FileInfo> getNamePath(String ticket, NodeRef rootNodeRef, NodeRef nodeRef) throws FileNotFoundException {
        return this.remotePeer.getNamePath(ticket, rootNodeRef, nodeRef);
    }

    @Override
    public FileInfo resolveNamePath(String ticket, NodeRef rootNodeRef, List<String> pathElements) throws FileNotFoundException {
        return this.remotePeer.resolveNamePath(ticket, rootNodeRef, pathElements);
    }

    @Override
    public FileInfo getFileInfo(String ticket, NodeRef nodeRef) {
        return this.remotePeer.getFileInfo(ticket, nodeRef);
    }

    @Override
    public ContentData putContent(String ticket, NodeRef nodeRef, byte[] bytes, String filename) {
        return this.remotePeer.putContent(ticket, nodeRef, bytes, filename);
    }

    @Override
    public ContentData[] putContent(String ticket, NodeRef[] nodeRefs, byte[][] bytes, String[] filenames) {
        return this.remotePeer.putContent(ticket, nodeRefs, bytes, filenames);
    }

    @Override
    public byte[] getContent(String ticket, NodeRef nodeRef) {
        return this.remotePeer.getContent(ticket, nodeRef);
    }

    @Override
    public ContentReader getReader(String ticket, NodeRef nodeRef) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ContentWriter getWriter(String ticket, NodeRef nodeRef) {
        throw new UnsupportedOperationException();
    }
}

