/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.remote;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.List;
import org.alfresco.repo.content.encoding.ContentCharsetFinder;
import org.alfresco.repo.model.filefolder.FileFolderServiceImpl;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.model.FileExistsException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.remote.FileFolderRemote;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileFolderRemoteServer
implements FileFolderRemote {
    private RetryingTransactionHelper retryingTransactionHelper;
    private AuthenticationService authenticationService;
    private FileFolderService fileFolderService;
    private MimetypeService mimetypeService;

    public void setTransactionService(TransactionService transactionService) {
        this.retryingTransactionHelper = transactionService.getRetryingTransactionHelper();
    }

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public void setFileFolderService(FileFolderService filefolderService) {
        this.fileFolderService = filefolderService;
    }

    public void setMimetypeService(MimetypeService mimetypeService) {
        this.mimetypeService = mimetypeService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FileInfo> list(String ticket, final NodeRef contextNodeRef) {
        List<FileInfo> list;
        AuthenticationUtil.pushAuthentication();
        try {
            this.authenticationService.validate(ticket);
            RetryingTransactionHelper.RetryingTransactionCallback<List<FileInfo>> callback = new RetryingTransactionHelper.RetryingTransactionCallback<List<FileInfo>>(){

                @Override
                public List<FileInfo> execute() throws Throwable {
                    return FileFolderRemoteServer.this.fileFolderService.list(contextNodeRef);
                }
            };
            list = this.retryingTransactionHelper.doInTransaction(callback, true, true);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            AuthenticationUtil.popAuthentication();
            throw throwable;
        }
        AuthenticationUtil.popAuthentication();
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FileInfo> listFiles(String ticket, final NodeRef folderNodeRef) {
        List<FileInfo> list;
        AuthenticationUtil.pushAuthentication();
        try {
            this.authenticationService.validate(ticket);
            RetryingTransactionHelper.RetryingTransactionCallback<List<FileInfo>> callback = new RetryingTransactionHelper.RetryingTransactionCallback<List<FileInfo>>(){

                @Override
                public List<FileInfo> execute() throws Throwable {
                    return FileFolderRemoteServer.this.fileFolderService.listFiles(folderNodeRef);
                }
            };
            list = this.retryingTransactionHelper.doInTransaction(callback, true, true);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            AuthenticationUtil.popAuthentication();
            throw throwable;
        }
        AuthenticationUtil.popAuthentication();
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FileInfo> listFolders(String ticket, final NodeRef contextNodeRef) {
        List<FileInfo> list;
        AuthenticationUtil.pushAuthentication();
        try {
            this.authenticationService.validate(ticket);
            RetryingTransactionHelper.RetryingTransactionCallback<List<FileInfo>> callback = new RetryingTransactionHelper.RetryingTransactionCallback<List<FileInfo>>(){

                @Override
                public List<FileInfo> execute() throws Throwable {
                    return FileFolderRemoteServer.this.fileFolderService.listFolders(contextNodeRef);
                }
            };
            list = this.retryingTransactionHelper.doInTransaction(callback, true, true);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            AuthenticationUtil.popAuthentication();
            throw throwable;
        }
        AuthenticationUtil.popAuthentication();
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeRef searchSimple(String ticket, final NodeRef contextNodeRef, final String name) {
        NodeRef nodeRef;
        AuthenticationUtil.pushAuthentication();
        try {
            this.authenticationService.validate(ticket);
            RetryingTransactionHelper.RetryingTransactionCallback<NodeRef> callback = new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

                @Override
                public NodeRef execute() throws Throwable {
                    return FileFolderRemoteServer.this.fileFolderService.searchSimple(contextNodeRef, name);
                }
            };
            nodeRef = this.retryingTransactionHelper.doInTransaction(callback, true, true);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            AuthenticationUtil.popAuthentication();
            throw throwable;
        }
        AuthenticationUtil.popAuthentication();
        return nodeRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FileInfo> search(String ticket, final NodeRef contextNodeRef, final String namePattern, final boolean includeSubFolders) {
        List<FileInfo> list;
        AuthenticationUtil.pushAuthentication();
        try {
            this.authenticationService.validate(ticket);
            RetryingTransactionHelper.RetryingTransactionCallback<List<FileInfo>> callback = new RetryingTransactionHelper.RetryingTransactionCallback<List<FileInfo>>(){

                @Override
                public List<FileInfo> execute() throws Throwable {
                    return FileFolderRemoteServer.this.fileFolderService.search(contextNodeRef, namePattern, includeSubFolders);
                }
            };
            list = this.retryingTransactionHelper.doInTransaction(callback, true, true);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            AuthenticationUtil.popAuthentication();
            throw throwable;
        }
        AuthenticationUtil.popAuthentication();
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FileInfo> search(String ticket, final NodeRef contextNodeRef, final String namePattern, final boolean fileSearch, final boolean folderSearch, final boolean includeSubFolders) {
        List<FileInfo> list;
        AuthenticationUtil.pushAuthentication();
        try {
            this.authenticationService.validate(ticket);
            RetryingTransactionHelper.RetryingTransactionCallback<List<FileInfo>> callback = new RetryingTransactionHelper.RetryingTransactionCallback<List<FileInfo>>(){

                @Override
                public List<FileInfo> execute() throws Throwable {
                    return FileFolderRemoteServer.this.fileFolderService.search(contextNodeRef, namePattern, fileSearch, folderSearch, includeSubFolders);
                }
            };
            list = this.retryingTransactionHelper.doInTransaction(callback, true, true);
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            AuthenticationUtil.popAuthentication();
            throw throwable;
        }
        AuthenticationUtil.popAuthentication();
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileInfo rename(String ticket, final NodeRef fileFolderRef, final String newName) throws FileExistsException, FileNotFoundException {
        FileInfo fileInfo;
        AuthenticationUtil.pushAuthentication();
        try {
            this.authenticationService.validate(ticket);
            RetryingTransactionHelper.RetryingTransactionCallback<FileInfo> callback = new RetryingTransactionHelper.RetryingTransactionCallback<FileInfo>(){

                @Override
                public FileInfo execute() throws Throwable {
                    return FileFolderRemoteServer.this.fileFolderService.rename(fileFolderRef, newName);
                }
            };
            fileInfo = this.retryingTransactionHelper.doInTransaction(callback, false, true);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            AuthenticationUtil.popAuthentication();
            throw throwable;
        }
        AuthenticationUtil.popAuthentication();
        return fileInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileInfo move(String ticket, final NodeRef sourceNodeRef, final NodeRef targetParentRef, final String newName) throws FileExistsException, FileNotFoundException {
        FileInfo fileInfo;
        AuthenticationUtil.pushAuthentication();
        try {
            this.authenticationService.validate(ticket);
            RetryingTransactionHelper.RetryingTransactionCallback<FileInfo> callback = new RetryingTransactionHelper.RetryingTransactionCallback<FileInfo>(){

                @Override
                public FileInfo execute() throws Throwable {
                    return FileFolderRemoteServer.this.fileFolderService.move(sourceNodeRef, targetParentRef, newName);
                }
            };
            fileInfo = this.retryingTransactionHelper.doInTransaction(callback, false, true);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            AuthenticationUtil.popAuthentication();
            throw throwable;
        }
        AuthenticationUtil.popAuthentication();
        return fileInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileInfo copy(String ticket, final NodeRef sourceNodeRef, final NodeRef targetParentRef, final String newName) throws FileExistsException, FileNotFoundException {
        FileInfo fileInfo;
        AuthenticationUtil.pushAuthentication();
        try {
            this.authenticationService.validate(ticket);
            RetryingTransactionHelper.RetryingTransactionCallback<FileInfo> callback = new RetryingTransactionHelper.RetryingTransactionCallback<FileInfo>(){

                @Override
                public FileInfo execute() throws Throwable {
                    return FileFolderRemoteServer.this.fileFolderService.copy(sourceNodeRef, targetParentRef, newName);
                }
            };
            fileInfo = this.retryingTransactionHelper.doInTransaction(callback, false, true);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            AuthenticationUtil.popAuthentication();
            throw throwable;
        }
        AuthenticationUtil.popAuthentication();
        return fileInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileInfo create(String ticket, final NodeRef parentNodeRef, final String name, final QName typeQName) throws FileExistsException {
        FileInfo fileInfo;
        AuthenticationUtil.pushAuthentication();
        try {
            this.authenticationService.validate(ticket);
            RetryingTransactionHelper.RetryingTransactionCallback<FileInfo> callback = new RetryingTransactionHelper.RetryingTransactionCallback<FileInfo>(){

                @Override
                public FileInfo execute() throws Throwable {
                    return FileFolderRemoteServer.this.fileFolderService.create(parentNodeRef, name, typeQName);
                }
            };
            fileInfo = this.retryingTransactionHelper.doInTransaction(callback, false, true);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            AuthenticationUtil.popAuthentication();
            throw throwable;
        }
        AuthenticationUtil.popAuthentication();
        return fileInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileInfo[] create(String ticket, final NodeRef[] parentNodeRefs, final String[] names, final QName[] typesQName) throws FileExistsException {
        FileInfo[] fileInfoArray;
        AuthenticationUtil.pushAuthentication();
        try {
            this.authenticationService.validate(ticket);
            RetryingTransactionHelper.RetryingTransactionCallback<FileInfo[]> callback = new RetryingTransactionHelper.RetryingTransactionCallback<FileInfo[]>(){

                @Override
                public FileInfo[] execute() throws Throwable {
                    FileInfo[] result = new FileInfo[parentNodeRefs.length];
                    for (int i = 0; i < result.length; ++i) {
                        result[i] = FileFolderRemoteServer.this.fileFolderService.create(parentNodeRefs[i], names[i], typesQName[i]);
                    }
                    return result;
                }
            };
            fileInfoArray = this.retryingTransactionHelper.doInTransaction(callback, false, true);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            AuthenticationUtil.popAuthentication();
            throw throwable;
        }
        AuthenticationUtil.popAuthentication();
        return fileInfoArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String ticket, final NodeRef nodeRef) {
        AuthenticationUtil.pushAuthentication();
        try {
            this.authenticationService.validate(ticket);
            RetryingTransactionHelper.RetryingTransactionCallback<Object> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                @Override
                public Object execute() throws Throwable {
                    FileFolderRemoteServer.this.fileFolderService.delete(nodeRef);
                    return null;
                }
            };
            this.retryingTransactionHelper.doInTransaction(callback, false, true);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            AuthenticationUtil.popAuthentication();
            throw throwable;
        }
        AuthenticationUtil.popAuthentication();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String ticket, final NodeRef[] nodeRefs) {
        AuthenticationUtil.pushAuthentication();
        try {
            this.authenticationService.validate(ticket);
            RetryingTransactionHelper.RetryingTransactionCallback<Object> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                @Override
                public Object execute() throws Throwable {
                    for (NodeRef nodeRef : nodeRefs) {
                        FileFolderRemoteServer.this.fileFolderService.delete(nodeRef);
                    }
                    return null;
                }
            };
            this.retryingTransactionHelper.doInTransaction(callback, false, true);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            AuthenticationUtil.popAuthentication();
            throw throwable;
        }
        AuthenticationUtil.popAuthentication();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileInfo makeFolders(String ticket, final NodeRef parentNodeRef, final List<String> pathElements, final QName folderTypeQName) {
        FileInfo fileInfo;
        AuthenticationUtil.pushAuthentication();
        try {
            this.authenticationService.validate(ticket);
            RetryingTransactionHelper.RetryingTransactionCallback<FileInfo> callback = new RetryingTransactionHelper.RetryingTransactionCallback<FileInfo>(){

                @Override
                public FileInfo execute() throws Throwable {
                    return FileFolderServiceImpl.makeFolders(FileFolderRemoteServer.this.fileFolderService, parentNodeRef, pathElements, folderTypeQName);
                }
            };
            fileInfo = this.retryingTransactionHelper.doInTransaction(callback, false, true);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            AuthenticationUtil.popAuthentication();
            throw throwable;
        }
        AuthenticationUtil.popAuthentication();
        return fileInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FileInfo> getNamePath(String ticket, final NodeRef rootNodeRef, final NodeRef nodeRef) throws FileNotFoundException {
        List<FileInfo> list;
        AuthenticationUtil.pushAuthentication();
        try {
            this.authenticationService.validate(ticket);
            RetryingTransactionHelper.RetryingTransactionCallback<List<FileInfo>> callback = new RetryingTransactionHelper.RetryingTransactionCallback<List<FileInfo>>(){

                @Override
                public List<FileInfo> execute() throws Throwable {
                    return FileFolderRemoteServer.this.fileFolderService.getNamePath(rootNodeRef, nodeRef);
                }
            };
            list = this.retryingTransactionHelper.doInTransaction(callback, true, true);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            AuthenticationUtil.popAuthentication();
            throw throwable;
        }
        AuthenticationUtil.popAuthentication();
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileInfo resolveNamePath(String ticket, final NodeRef rootNodeRef, final List<String> pathElements) throws FileNotFoundException {
        FileInfo fileInfo;
        AuthenticationUtil.pushAuthentication();
        try {
            this.authenticationService.validate(ticket);
            RetryingTransactionHelper.RetryingTransactionCallback<FileInfo> callback = new RetryingTransactionHelper.RetryingTransactionCallback<FileInfo>(){

                @Override
                public FileInfo execute() throws Throwable {
                    return FileFolderRemoteServer.this.fileFolderService.resolveNamePath(rootNodeRef, pathElements);
                }
            };
            fileInfo = this.retryingTransactionHelper.doInTransaction(callback, true, true);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            AuthenticationUtil.popAuthentication();
            throw throwable;
        }
        AuthenticationUtil.popAuthentication();
        return fileInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileInfo getFileInfo(String ticket, final NodeRef nodeRef) {
        FileInfo fileInfo;
        AuthenticationUtil.pushAuthentication();
        try {
            this.authenticationService.validate(ticket);
            RetryingTransactionHelper.RetryingTransactionCallback<FileInfo> callback = new RetryingTransactionHelper.RetryingTransactionCallback<FileInfo>(){

                @Override
                public FileInfo execute() throws Throwable {
                    return FileFolderRemoteServer.this.fileFolderService.getFileInfo(nodeRef);
                }
            };
            fileInfo = this.retryingTransactionHelper.doInTransaction(callback, true, true);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            AuthenticationUtil.popAuthentication();
            throw throwable;
        }
        AuthenticationUtil.popAuthentication();
        return fileInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContentData putContent(String ticket, final NodeRef nodeRef, final byte[] bytes, final String filename) {
        ContentData contentData;
        AuthenticationUtil.pushAuthentication();
        try {
            ContentData contentData2;
            this.authenticationService.validate(ticket);
            RetryingTransactionHelper.RetryingTransactionCallback<ContentData> callback = new RetryingTransactionHelper.RetryingTransactionCallback<ContentData>(){

                @Override
                public ContentData execute() throws Throwable {
                    String mimetype = FileFolderRemoteServer.this.mimetypeService.guessMimetype(filename);
                    ContentWriter writer = FileFolderRemoteServer.this.fileFolderService.getWriter(nodeRef);
                    ByteArrayInputStream is = new ByteArrayInputStream(bytes);
                    ContentCharsetFinder charsetFinder = FileFolderRemoteServer.this.mimetypeService.getContentCharsetFinder();
                    Charset charset = charsetFinder.getCharset((InputStream)is, mimetype);
                    writer.setEncoding(charset.name());
                    writer.setMimetype(mimetype);
                    writer.putContent((InputStream)is);
                    return writer.getContentData();
                }
            };
            contentData = contentData2 = this.retryingTransactionHelper.doInTransaction(callback, false, true);
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            AuthenticationUtil.popAuthentication();
            throw throwable;
        }
        AuthenticationUtil.popAuthentication();
        return contentData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContentData[] putContent(String ticket, final NodeRef[] nodeRefs, final byte[][] bytes, final String[] filenames) {
        ContentData[] contentDataArray;
        AuthenticationUtil.pushAuthentication();
        try {
            ContentData[] contentData;
            this.authenticationService.validate(ticket);
            RetryingTransactionHelper.RetryingTransactionCallback<ContentData[]> callback = new RetryingTransactionHelper.RetryingTransactionCallback<ContentData[]>(){

                @Override
                public ContentData[] execute() throws Throwable {
                    ContentData[] results = new ContentData[filenames.length];
                    for (int i = 0; i < filenames.length; ++i) {
                        String mimetype = FileFolderRemoteServer.this.mimetypeService.guessMimetype(filenames[i]);
                        ContentWriter writer = FileFolderRemoteServer.this.fileFolderService.getWriter(nodeRefs[i]);
                        ByteArrayInputStream is = new ByteArrayInputStream(bytes[i]);
                        ContentCharsetFinder charsetFinder = FileFolderRemoteServer.this.mimetypeService.getContentCharsetFinder();
                        Charset charset = charsetFinder.getCharset((InputStream)is, mimetype);
                        writer.setEncoding(charset.name());
                        writer.setMimetype(mimetype);
                        writer.putContent((InputStream)is);
                        results[i] = writer.getContentData();
                    }
                    return results;
                }
            };
            contentDataArray = contentData = this.retryingTransactionHelper.doInTransaction(callback, false, true);
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            AuthenticationUtil.popAuthentication();
            throw throwable;
        }
        AuthenticationUtil.popAuthentication();
        return contentDataArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getContent(String ticket, final NodeRef nodeRef) {
        byte[] byArray;
        AuthenticationUtil.pushAuthentication();
        try {
            byte[] bytes;
            this.authenticationService.validate(ticket);
            RetryingTransactionHelper.RetryingTransactionCallback<byte[]> callback = new RetryingTransactionHelper.RetryingTransactionCallback<byte[]>(){

                @Override
                public byte[] execute() throws Throwable {
                    ContentReader reader = FileFolderRemoteServer.this.fileFolderService.getReader(nodeRef);
                    if (!reader.exists()) {
                        return null;
                    }
                    ByteArrayOutputStream bos = new ByteArrayOutputStream((int)reader.getSize());
                    reader.getContent((OutputStream)bos);
                    return bos.toByteArray();
                }
            };
            byArray = bytes = this.retryingTransactionHelper.doInTransaction(callback, true, true);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            AuthenticationUtil.popAuthentication();
            throw throwable;
        }
        AuthenticationUtil.popAuthentication();
        return byArray;
    }

    @Override
    public ContentReader getReader(String ticket, NodeRef nodeRef) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ContentWriter getWriter(String ticket, NodeRef nodeRef) {
        throw new UnsupportedOperationException();
    }
}

