/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rendition;

import java.util.LinkedList;
import java.util.List;
import junit.framework.TestCase;
import org.alfresco.repo.action.ActionDefinitionImpl;
import org.alfresco.repo.rendition.MockedTestServiceRegistry;
import org.alfresco.repo.rendition.RenderingEngineDefinitionImpl;
import org.alfresco.repo.rendition.RenditionDefinitionPersisterImpl;
import org.alfresco.repo.rendition.RenditionServiceImpl;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.rendition.RenderingEngineDefinition;
import org.alfresco.service.cmr.rendition.RenditionDefinition;
import org.alfresco.service.namespace.QName;
import org.mockito.Mockito;

public class RenditionServiceImplTest
extends TestCase {
    private static final String ENGINE_NAME = "Engine Name";
    private ServiceRegistry serviceRegistry = new MockedTestServiceRegistry();
    private ActionService actionService = (ActionService)Mockito.mock(ActionService.class);
    private final RenditionDefinitionPersisterImpl renditionDefinitionPersister = (RenditionDefinitionPersisterImpl)Mockito.mock(RenditionDefinitionPersisterImpl.class);
    private RenditionServiceImpl renditionService;
    private final QName ACTION_NAME = QName.createQName((String)"http://www.alfresco.org", (String)"testName");

    protected void setUp() throws Exception {
        this.renditionService = new RenditionServiceImpl();
        this.renditionService.setServiceRegistry(this.serviceRegistry);
        this.renditionService.setActionService(this.actionService);
        this.renditionService.setRenditionDefinitionPersister(this.renditionDefinitionPersister);
    }

    public void testGetRenderingEngineDefinition() throws Exception {
        RenditionServiceImplTest.assertNull((Object)this.renditionService.getRenderingEngineDefinition(""));
        ActionDefinitionImpl actionDefinition = new ActionDefinitionImpl(ENGINE_NAME);
        Mockito.when((Object)this.actionService.getActionDefinition(ENGINE_NAME)).thenReturn((Object)actionDefinition);
        RenditionServiceImplTest.assertNull((Object)this.renditionService.getRenderingEngineDefinition(ENGINE_NAME));
        RenderingEngineDefinitionImpl renderingDefinition = new RenderingEngineDefinitionImpl(ENGINE_NAME);
        Mockito.when((Object)this.actionService.getActionDefinition(ENGINE_NAME)).thenReturn((Object)renderingDefinition);
        RenditionServiceImplTest.assertSame((Object)renderingDefinition, (Object)this.renditionService.getRenderingEngineDefinition(ENGINE_NAME));
    }

    public void testGetRenderingEngineDefinitions() throws Exception {
        LinkedList<ActionDefinitionImpl> actionDefs = new LinkedList<ActionDefinitionImpl>();
        Mockito.when(this.actionService.getActionDefinitions()).thenReturn(actionDefs);
        List<RenderingEngineDefinition> engineDefs = this.renditionService.getRenderingEngineDefinitions();
        RenditionServiceImplTest.assertTrue((String)"The list of rendering action definitions should be empty!", (boolean)engineDefs.isEmpty());
        RenderingEngineDefinitionImpl renderingDefinition = new RenderingEngineDefinitionImpl(ENGINE_NAME);
        actionDefs.add(renderingDefinition);
        engineDefs = this.renditionService.getRenderingEngineDefinitions();
        RenditionServiceImplTest.assertEquals((int)1, (int)engineDefs.size());
        RenditionServiceImplTest.assertSame((Object)renderingDefinition, (Object)engineDefs.get(0));
        ActionDefinitionImpl actionDefinition = new ActionDefinitionImpl(ENGINE_NAME);
        actionDefs.add(actionDefinition);
        engineDefs = this.renditionService.getRenderingEngineDefinitions();
        RenditionServiceImplTest.assertEquals((int)1, (int)engineDefs.size());
        RenditionServiceImplTest.assertSame((Object)renderingDefinition, (Object)engineDefs.get(0));
    }

    public void testCreateRenditionDefinition() throws Exception {
        RenditionDefinition renderingAction = this.renditionService.createRenditionDefinition(this.ACTION_NAME, ENGINE_NAME);
        RenditionServiceImplTest.assertNotNull((Object)renderingAction);
        RenditionServiceImplTest.assertEquals((String)ENGINE_NAME, (String)renderingAction.getActionDefinitionName());
        RenditionServiceImplTest.assertEquals((Object)this.ACTION_NAME, (Object)renderingAction.getRenditionName());
        String id = renderingAction.getId();
        RenditionServiceImplTest.assertNotNull((Object)id);
        RenditionServiceImplTest.assertTrue((id.length() > 0 ? 1 : 0) != 0);
    }
}

