/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rendition;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.model.RenditionModel;
import org.alfresco.repo.copy.CopyBehaviourCallback;
import org.alfresco.repo.copy.CopyDetails;
import org.alfresco.repo.copy.CopyServicePolicies;
import org.alfresco.repo.copy.DefaultCopyBehaviourCallback;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.rendition.RenderCallback;
import org.alfresco.service.cmr.rendition.RenditionDefinition;
import org.alfresco.service.cmr.rendition.RenditionService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.EqualsHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenditionedAspect
implements NodeServicePolicies.OnUpdatePropertiesPolicy,
CopyServicePolicies.OnCopyNodePolicy {
    private static final Log logger = LogFactory.getLog(RenditionedAspect.class);
    private PolicyComponent policyComponent;
    private NodeService nodeService;
    private DictionaryService dictionaryService;
    private RenditionService renditionService;

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setRenditionService(RenditionService renditionService) {
        this.renditionService = renditionService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void init() {
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onUpdateProperties"), RenditionModel.ASPECT_RENDITIONED, (Behaviour)new JavaBehaviour(this, "onUpdateProperties", Behaviour.NotificationFrequency.TRANSACTION_COMMIT));
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"getCopyCallback"), RenditionModel.ASPECT_RENDITIONED, (Behaviour)new JavaBehaviour(this, "getCopyCallback"));
    }

    @Override
    public void onUpdateProperties(NodeRef nodeRef, Map<QName, Serializable> before, Map<QName, Serializable> after) {
        if (this.nodeService.exists(nodeRef) && !this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_WORKING_COPY)) {
            List<QName> changedProperties = this.getChangedProperties(before, after);
            List<ChildAssociationRef> renditions = this.renditionService.getRenditions(nodeRef);
            for (ChildAssociationRef chAssRef : renditions) {
                QName renditionAssocName = chAssRef.getQName();
                RenditionDefinition rendDefn = this.renditionService.loadRenditionDefinition(renditionAssocName);
                if (rendDefn == null) {
                    if (!logger.isDebugEnabled()) continue;
                    StringBuilder msg = new StringBuilder();
                    msg.append("Cannot update rendition ").append(renditionAssocName).append(" on node ").append(nodeRef).append(" as the renditionDefinition could not be loaded.");
                    logger.debug((Object)msg.toString());
                    continue;
                }
                Serializable updateRenditionsPolicy = rendDefn.getParameterValue("update-renditions-on-any-property-change");
                boolean updateRenditionsAlways = updateRenditionsPolicy == null ? false : (Boolean)updateRenditionsPolicy;
                boolean renditionUpdateRequired = false;
                for (QName qname : changedProperties) {
                    try {
                        PropertyDefinition propertyDef = this.dictionaryService.getProperty(qname);
                        if (propertyDef == null) continue;
                        if (!propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.CONTENT)) {
                            if (!updateRenditionsAlways) continue;
                            renditionUpdateRequired = true;
                            continue;
                        }
                        renditionUpdateRequired = true;
                    }
                    catch (ClassCastException ccx) {}
                }
                if (!renditionUpdateRequired) continue;
                this.queueUpdate(nodeRef, rendDefn, chAssRef);
            }
        }
    }

    private List<QName> getChangedProperties(Map<QName, Serializable> before, Map<QName, Serializable> after) {
        ArrayList<QName> results = new ArrayList<QName>();
        for (QName propQName : before.keySet()) {
            Serializable afterValue;
            if (!after.keySet().contains(propQName)) {
                results.add(propQName);
                continue;
            }
            Serializable beforeValue = before.get(propQName);
            if (EqualsHelper.nullSafeEquals((Object)beforeValue, (Object)(afterValue = after.get(propQName)))) continue;
            results.add(propQName);
        }
        for (QName propQName : after.keySet()) {
            if (before.containsKey(propQName)) continue;
            results.add(propQName);
        }
        return results;
    }

    private void queueUpdate(final NodeRef sourceNodeRef, final RenditionDefinition rendDefn, final ChildAssociationRef renditionAssoc) {
        if (logger.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("Queueing rendition update for node ").append(sourceNodeRef).append(": ").append(rendDefn.getRenditionName());
            logger.debug((Object)msg.toString());
        }
        if (rendDefn != null) {
            this.renditionService.render(sourceNodeRef, rendDefn, new RenderCallback(){

                public void handleFailedRendition(Throwable t) {
                    if (logger.isDebugEnabled()) {
                        StringBuilder msg = new StringBuilder();
                        msg.append("Re-rendering of node ").append(sourceNodeRef).append(" with renditionDefinition ").append(rendDefn.getRenditionName()).append(" failed. Deleting defunct rendition. ").append("The following exception is shown for informational purposes only ").append("and does not affect operation of the system.");
                        logger.debug((Object)msg.toString(), t);
                    }
                    if (RenditionedAspect.this.nodeService.exists(renditionAssoc.getChildRef())) {
                        RenditionedAspect.this.nodeService.deleteNode(renditionAssoc.getChildRef());
                    }
                }

                public void handleSuccessfulRendition(ChildAssociationRef primaryParentOfNewRendition) {
                }
            });
        }
    }

    @Override
    public CopyBehaviourCallback getCopyCallback(QName classRef, CopyDetails copyDetails) {
        return RenditionedAspectCopyBehaviourCallback.INSTANCE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RenditionedAspectCopyBehaviourCallback
    extends DefaultCopyBehaviourCallback {
        private static final CopyBehaviourCallback INSTANCE = new RenditionedAspectCopyBehaviourCallback();

        private RenditionedAspectCopyBehaviourCallback() {
        }

        @Override
        public boolean getMustCopy(QName classQName, CopyDetails copyDetails) {
            return true;
        }

        @Override
        public CopyBehaviourCallback.ChildAssocCopyAction getChildAssociationCopyAction(QName classQName, CopyDetails copyDetails, CopyBehaviourCallback.CopyChildAssociationDetails childAssocCopyDetails) {
            ChildAssociationRef childAssocRef = childAssocCopyDetails.getChildAssocRef();
            if (childAssocRef.getTypeQName().equals((Object)RenditionModel.ASSOC_RENDITION)) {
                return CopyBehaviourCallback.ChildAssocCopyAction.COPY_CHILD;
            }
            throw new IllegalStateException("Behaviour should have been invoked: \n   Aspect: " + this.getClass().getName() + "\n" + "   " + childAssocCopyDetails + "\n" + "   " + copyDetails);
        }

        @Override
        public Map<QName, Serializable> getCopyProperties(QName classQName, CopyDetails copyDetails, Map<QName, Serializable> properties) {
            HashMap<QName, Serializable> newProperties = new HashMap<QName, Serializable>(5);
            return newProperties;
        }
    }
}

