/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.replication;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.alfresco.repo.action.ActionImpl;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.scheduled.SchedulableAction;
import org.alfresco.service.cmr.action.scheduled.ScheduledPersistedAction;
import org.alfresco.service.cmr.replication.ReplicationDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicationDefinitionImpl
extends ActionImpl
implements ReplicationDefinition {
    private static final long serialVersionUID = 3183721054220388564L;
    public static final String EXECUTOR_NAME = "replicationActionExecutor";
    public static final String REPLICATION_DEFINITION_NAME = "replicationActionName";
    public static final String REPLICATION_DEFINITION_TARGET = "replicationTarget";
    public static final String REPLICATION_DEFINITION_PAYLOAD = "replicationPayload";
    public static final String REPLICATION_DEFINITION_ENABLED = "replicationDefinitionEnabled";
    public static final String REPLICATION_DEFINITION_LOCAL_TRANSFER_REPORT = "replicationTransferLocalReport";
    public static final String REPLICATION_DEFINITION_REMOTE_TRANSFER_REPORT = "replicationTransferRemoteReport";
    private ScheduledPersistedAction schedule;

    public ReplicationDefinitionImpl(String id, String replicationName) {
        this(id, replicationName, null);
    }

    public ReplicationDefinitionImpl(String id, String replicationName, String description) {
        super(null, id, EXECUTOR_NAME);
        this.setReplicationQName(QName.createQName(null, (String)replicationName));
        this.setDescription(description);
    }

    public ReplicationDefinitionImpl(Action action) {
        super(action);
    }

    @Override
    public String getReplicationName() {
        return this.getReplicationQName().getLocalName();
    }

    @Override
    public QName getReplicationQName() {
        Serializable parameterValue = this.getParameterValue(REPLICATION_DEFINITION_NAME);
        return (QName)parameterValue;
    }

    protected void setReplicationQName(QName replicationName) {
        this.setParameterValue(REPLICATION_DEFINITION_NAME, (Serializable)replicationName);
    }

    @Override
    public boolean isEnabled() {
        Serializable parameterValue = this.getParameterValue(REPLICATION_DEFINITION_ENABLED);
        if (parameterValue == null) {
            return true;
        }
        return (Boolean)parameterValue;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.setParameterValue(REPLICATION_DEFINITION_ENABLED, new Boolean(enabled));
    }

    @Override
    public List<NodeRef> getPayload() {
        ArrayList<NodeRef> payload;
        Serializable payloadO = this.getParameterValue(REPLICATION_DEFINITION_PAYLOAD);
        if (payloadO == null) {
            payload = new ArrayList();
            this.setParameterValue(REPLICATION_DEFINITION_PAYLOAD, payload);
        } else if (payloadO instanceof List) {
            payload = (List)((Object)payloadO);
        } else {
            payload = new ArrayList();
            payload.add((NodeRef)payloadO);
            this.setParameterValue(REPLICATION_DEFINITION_PAYLOAD, payload);
        }
        return payload;
    }

    @Override
    public String getTargetName() {
        return (String)((Object)this.getParameterValue(REPLICATION_DEFINITION_TARGET));
    }

    @Override
    public void setTargetName(String targetName) {
        this.setParameterValue(REPLICATION_DEFINITION_TARGET, (Serializable)((Object)targetName));
    }

    @Override
    public NodeRef getLocalTransferReport() {
        return (NodeRef)this.getParameterValue(REPLICATION_DEFINITION_LOCAL_TRANSFER_REPORT);
    }

    @Override
    public void setLocalTransferReport(NodeRef report) {
        this.setParameterValue(REPLICATION_DEFINITION_LOCAL_TRANSFER_REPORT, (Serializable)report);
    }

    @Override
    public NodeRef getRemoteTransferReport() {
        return (NodeRef)this.getParameterValue(REPLICATION_DEFINITION_REMOTE_TRANSFER_REPORT);
    }

    @Override
    public void setRemoteTransferReport(NodeRef report) {
        this.setParameterValue(REPLICATION_DEFINITION_REMOTE_TRANSFER_REPORT, (Serializable)report);
    }

    public ScheduledPersistedAction getSchedule() {
        return this.schedule;
    }

    public void setSchedule(ScheduledPersistedAction schedule) {
        this.schedule = schedule;
    }

    @Override
    public Integer getScheduleIntervalCount() {
        if (this.schedule == null) {
            return null;
        }
        return this.schedule.getScheduleIntervalCount();
    }

    @Override
    public SchedulableAction.IntervalPeriod getScheduleIntervalPeriod() {
        if (this.schedule == null) {
            return null;
        }
        return this.schedule.getScheduleIntervalPeriod();
    }

    @Override
    public Date getScheduleStart() {
        if (this.schedule == null) {
            return null;
        }
        return this.schedule.getScheduleStart();
    }

    @Override
    public void setScheduleIntervalCount(Integer count) {
        if (this.schedule == null) {
            throw new IllegalStateException("Scheduling not enabled");
        }
        this.schedule.setScheduleIntervalCount(count);
    }

    @Override
    public void setScheduleIntervalPeriod(SchedulableAction.IntervalPeriod period) {
        if (this.schedule == null) {
            throw new IllegalStateException("Scheduling not enabled");
        }
        this.schedule.setScheduleIntervalPeriod(period);
    }

    @Override
    public void setScheduleStart(Date startDate) {
        if (this.schedule == null) {
            throw new IllegalStateException("Scheduling not enabled");
        }
        this.schedule.setScheduleStart(startDate);
    }

    @Override
    public boolean isSchedulingEnabled() {
        return this.schedule != null;
    }
}

