/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene;

import java.util.List;
import org.alfresco.cmis.CMISQueryOptions;
import org.alfresco.cmis.CMISQueryService;
import org.alfresco.cmis.CMISResultSetMetaData;
import org.alfresco.cmis.CMISResultSetRow;
import org.alfresco.repo.search.impl.lucene.ADMLuceneSearcherImpl;
import org.alfresco.repo.search.impl.lucene.AbstractLuceneIndexerAndSearcherFactory;
import org.alfresco.repo.search.impl.lucene.LuceneQueryLanguageSPI;
import org.alfresco.repo.search.impl.querymodel.QueryOptions;
import org.alfresco.repo.search.results.ResultSetSPIWrapper;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.LimitBy;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneCmisStrictSqlQueryLanguage
implements LuceneQueryLanguageSPI {
    private CMISQueryService cmisQueryService;

    public void setCmisQueryService(CMISQueryService cmisQueryService) {
        this.cmisQueryService = cmisQueryService;
    }

    @Override
    public ResultSet executQuery(SearchParameters searchParameters, ADMLuceneSearcherImpl admLuceneSearcher) {
        String sql = searchParameters.getQuery();
        CMISQueryOptions options = new CMISQueryOptions(sql, (StoreRef)searchParameters.getStores().get(0));
        options.setIncludeInTransactionData(!searchParameters.excludeDataInTheCurrentTransaction());
        options.setDefaultFTSConnective(searchParameters.getDefaultOperator() == SearchParameters.Operator.OR ? QueryOptions.Connective.OR : QueryOptions.Connective.AND);
        options.setDefaultFTSFieldConnective(searchParameters.getDefaultOperator() == SearchParameters.Operator.OR ? QueryOptions.Connective.OR : QueryOptions.Connective.AND);
        options.setSkipCount(searchParameters.getSkipCount());
        options.setMaxPermissionChecks(searchParameters.getMaxPermissionChecks());
        options.setMaxPermissionCheckTimeMillis(searchParameters.getMaxPermissionCheckTimeMillis());
        if (searchParameters.getLimitBy() == LimitBy.FINAL_SIZE) {
            options.setMaxItems(searchParameters.getLimit());
        } else {
            options.setMaxItems(searchParameters.getMaxItems());
        }
        options.setMlAnalaysisMode(searchParameters.getMlAnalaysisMode());
        options.setLocales(searchParameters.getLocales());
        options.setStores(searchParameters.getStores());
        options.setQueryMode(CMISQueryOptions.CMISQueryMode.CMS_STRICT);
        return new ResultSetSPIWrapper<CMISResultSetRow, CMISResultSetMetaData>(this.cmisQueryService.query(options));
    }

    @Override
    public String getName() {
        return "cmis-strict";
    }

    @Override
    public void setFactories(List<AbstractLuceneIndexerAndSearcherFactory> factories) {
        for (AbstractLuceneIndexerAndSearcherFactory factory : factories) {
            factory.registerQueryLanguage(this);
        }
    }
}

