/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication;

import junit.framework.TestCase;
import org.alfresco.repo.security.authentication.NameBasedUserNameGenerator;

public class NameBasedUserNameGeneratorTest
extends TestCase {
    public void testGenerate() {
        NameBasedUserNameGenerator generator = new NameBasedUserNameGenerator();
        generator.setUserNameLength(10);
        generator.setNamePattern("%firstName%_%lastName%");
        String firstName = "Buffy";
        String lastName = "Summers";
        String emailAddress = "buffy@sunnydale.com";
        String userName = generator.generateUserName(firstName, lastName, emailAddress, 0);
        NameBasedUserNameGeneratorTest.assertEquals((String)"", (String)(firstName + "_" + lastName).toLowerCase(), (String)userName);
        userName = generator.generateUserName(firstName, lastName, emailAddress, 1);
        NameBasedUserNameGeneratorTest.assertEquals((String)"", (String)(firstName + "_" + lastName).toLowerCase().substring(0, 7), (String)userName.substring(0, 7));
        NameBasedUserNameGeneratorTest.assertTrue((String)"", (!(firstName + "_" + lastName).toLowerCase().equals(userName) ? 1 : 0) != 0);
        generator.setNamePattern("%emailAddress%");
        userName = generator.generateUserName(firstName, lastName, emailAddress, 0);
        NameBasedUserNameGeneratorTest.assertEquals((String)"", (String)emailAddress.toLowerCase(), (String)userName);
        userName = generator.generateUserName(firstName, lastName, emailAddress, 1);
        NameBasedUserNameGeneratorTest.assertTrue((String)"", (!emailAddress.toLowerCase().equals(userName) ? 1 : 0) != 0);
        generator.setNamePattern("%lastName%.%firstName%");
        userName = generator.generateUserName(firstName, lastName, emailAddress, 0);
        NameBasedUserNameGeneratorTest.assertEquals((String)"", (String)(lastName + "." + firstName).toLowerCase(), (String)userName);
        generator.setNamePattern("%i%%lastName%");
        userName = generator.generateUserName(firstName, lastName, emailAddress, 0);
        NameBasedUserNameGeneratorTest.assertEquals((String)"", (String)"bsummers".toLowerCase(), (String)userName);
    }
}

