/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authority;

import javax.transaction.UserTransaction;
import junit.framework.TestCase;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authentication.MutableAuthenticationDao;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.springframework.context.ApplicationContext;

public class SimpleAuthorityServiceTest
extends TestCase {
    private static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private AuthenticationComponent authenticationComponent;
    private MutableAuthenticationService authenticationService;
    private AuthorityService authorityService;
    private AuthorityService pubAuthorityService;
    private MutableAuthenticationDao authenticationDAO;
    private PersonService personService;
    private UserTransaction tx;

    public void setUp() throws Exception {
        this.authenticationComponent = (AuthenticationComponent)ctx.getBean("authenticationComponent");
        this.authenticationService = (MutableAuthenticationService)ctx.getBean("authenticationService");
        this.authorityService = (AuthorityService)ctx.getBean("authorityService");
        this.pubAuthorityService = (AuthorityService)ctx.getBean("AuthorityService");
        this.personService = (PersonService)ctx.getBean("personService");
        this.authenticationDAO = (MutableAuthenticationDao)ctx.getBean("authenticationDao");
        this.authenticationComponent.setSystemUserAsCurrentUser();
        TransactionService transactionService = (TransactionService)ctx.getBean(ServiceRegistry.TRANSACTION_SERVICE.getLocalName());
        this.tx = transactionService.getUserTransaction();
        this.tx.begin();
        if (!this.authenticationDAO.userExists("andy")) {
            this.authenticationService.createAuthentication("andy", "andy".toCharArray());
        }
        if (!this.authenticationDAO.userExists(AuthenticationUtil.getAdminUserName())) {
            this.authenticationService.createAuthentication(AuthenticationUtil.getAdminUserName(), "admin".toCharArray());
        }
        if (!this.authenticationDAO.userExists("administrator")) {
            this.authenticationService.createAuthentication("administrator", "administrator".toCharArray());
        }
    }

    protected void tearDown() throws Exception {
        if (this.tx.getStatus() == 0 || this.tx.getStatus() == 1) {
            this.tx.rollback();
        }
        AuthenticationUtil.clearCurrentSecurityContext();
        super.tearDown();
    }

    public void testNonAdminUser() {
        this.authenticationComponent.setCurrentUser("andy");
        SimpleAuthorityServiceTest.assertFalse((boolean)this.authorityService.hasAdminAuthority());
        SimpleAuthorityServiceTest.assertFalse((boolean)this.pubAuthorityService.hasAdminAuthority());
        SimpleAuthorityServiceTest.assertEquals((int)1, (int)this.authorityService.getAuthorities().size());
    }

    public void testAdminUser() {
        SimpleAuthorityServiceTest.assertFalse((boolean)this.authorityService.authorityExists("woof"));
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        SimpleAuthorityServiceTest.assertTrue((boolean)this.authorityService.hasAdminAuthority());
        SimpleAuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.hasAdminAuthority());
        SimpleAuthorityServiceTest.assertEquals((int)4, (int)this.authorityService.getAuthorities().size());
    }

    public void testAuthorities() {
        SimpleAuthorityServiceTest.assertFalse((boolean)this.pubAuthorityService.authorityExists("woof"));
        SimpleAuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.ADMIN).size());
        SimpleAuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getAllAuthorities(AuthorityType.ADMIN).contains("ROLE_ADMINISTRATOR"));
        SimpleAuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.EVERYONE).size());
        SimpleAuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getAllAuthorities(AuthorityType.EVERYONE).contains("GROUP_EVERYONE"));
        SimpleAuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        SimpleAuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GUEST).size());
        SimpleAuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getAllAuthorities(AuthorityType.GUEST).contains("ROLE_GUEST"));
        SimpleAuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.OWNER).size());
        SimpleAuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.ROLE).size());
        SimpleAuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.USER).size());
        SimpleAuthorityServiceTest.assertEquals((int)this.personService.getAllPeople().size(), (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.USER).size());
    }
}

