/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authority.script;

import java.util.LinkedHashSet;
import java.util.Set;
import org.alfresco.repo.jscript.BaseScopableProcessorExtension;
import org.alfresco.repo.security.authority.script.ScriptGroup;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;

public class ScriptAuthorityService
extends BaseScopableProcessorExtension {
    private AuthorityService authorityService;

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public AuthorityService getAuthorityService() {
        return this.authorityService;
    }

    public ScriptGroup[] searchRootGroupsInZone(String displayNamePattern, String zone) {
        LinkedHashSet<ScriptGroup> groups = new LinkedHashSet<ScriptGroup>(0);
        Set<String> authorities = this.authorityService.findAuthorities(AuthorityType.GROUP, null, true, displayNamePattern, zone);
        for (String authority : authorities) {
            ScriptGroup group = new ScriptGroup(authority, this.authorityService);
            groups.add(group);
        }
        return groups.toArray(new ScriptGroup[groups.size()]);
    }

    public ScriptGroup[] searchRootGroups(String displayNamePattern) {
        LinkedHashSet<ScriptGroup> groups = new LinkedHashSet<ScriptGroup>();
        Set<String> authorities = this.authorityService.findAuthorities(AuthorityType.GROUP, null, true, displayNamePattern, null);
        for (String authority : authorities) {
            ScriptGroup group = new ScriptGroup(authority, this.authorityService);
            groups.add(group);
        }
        return groups.toArray(new ScriptGroup[groups.size()]);
    }

    public ScriptGroup[] getAllRootGroups() {
        LinkedHashSet<ScriptGroup> groups = new LinkedHashSet<ScriptGroup>();
        Set<String> authorities = this.authorityService.getAllRootAuthorities(AuthorityType.GROUP);
        for (String authority : authorities) {
            ScriptGroup group = new ScriptGroup(authority, this.authorityService);
            groups.add(group);
        }
        return groups.toArray(new ScriptGroup[groups.size()]);
    }

    public ScriptGroup[] getAllRootGroupsInZone(String zone) {
        LinkedHashSet<ScriptGroup> groups = new LinkedHashSet<ScriptGroup>();
        Set<String> authorities = this.authorityService.getAllRootAuthoritiesInZone(zone, AuthorityType.GROUP);
        for (String authority : authorities) {
            ScriptGroup group = new ScriptGroup(authority, this.authorityService);
            groups.add(group);
        }
        return groups.toArray(new ScriptGroup[groups.size()]);
    }

    public ScriptGroup getGroup(String shortName) {
        String fullName = this.authorityService.getName(AuthorityType.GROUP, shortName);
        if (this.authorityService.authorityExists(fullName)) {
            ScriptGroup group = new ScriptGroup(fullName, this.authorityService);
            return group;
        }
        return null;
    }

    public ScriptGroup getGroupForFullAuthorityName(String fullAuthorityName) {
        if (this.authorityService.authorityExists(fullAuthorityName)) {
            ScriptGroup group = new ScriptGroup(fullAuthorityName, this.authorityService);
            return group;
        }
        return null;
    }

    public ScriptGroup createRootGroup(String shortName, String displayName) {
        this.authorityService.createAuthority(AuthorityType.GROUP, shortName, displayName, this.authorityService.getDefaultZones());
        return this.getGroup(shortName);
    }

    public ScriptGroup[] searchGroups(String shortNameFilter) {
        String filter = shortNameFilter;
        if (shortNameFilter.length() != 0) {
            filter = filter.replace("\"", "") + "*";
        }
        LinkedHashSet<ScriptGroup> groups = new LinkedHashSet<ScriptGroup>();
        Set<String> authorities = this.authorityService.findAuthorities(AuthorityType.GROUP, null, false, filter, null);
        for (String authority : authorities) {
            ScriptGroup group = new ScriptGroup(authority, this.authorityService);
            groups.add(group);
        }
        return groups.toArray(new ScriptGroup[groups.size()]);
    }

    public ScriptGroup[] searchGroupsInZone(String shortNameFilter, String zone) {
        String filter = shortNameFilter;
        if (shortNameFilter.length() != 0) {
            filter = filter.replace("\"", "") + "*";
        }
        LinkedHashSet<ScriptGroup> groups = new LinkedHashSet<ScriptGroup>();
        Set<String> authorities = this.authorityService.findAuthorities(AuthorityType.GROUP, null, false, filter, zone);
        for (String authority : authorities) {
            ScriptGroup group = new ScriptGroup(authority, this.authorityService);
            groups.add(group);
        }
        return groups.toArray(new ScriptGroup[groups.size()]);
    }
}

