/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.permissions;

import org.alfresco.repo.security.permissions.ACEType;
import org.alfresco.repo.security.permissions.AccessControlEntry;
import org.alfresco.repo.security.permissions.AccessControlEntryContext;
import org.alfresco.repo.security.permissions.PermissionReference;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.AuthorityType;

public class SimpleAccessControlEntry
implements AccessControlEntry {
    private static final long serialVersionUID = -3099789485179796034L;
    private AccessStatus accessStatus;
    private ACEType aceType;
    private String authority;
    private AuthorityType authorityType;
    private AccessControlEntryContext context;
    private PermissionReference permission;
    private Integer position;

    public AccessStatus getAccessStatus() {
        return this.accessStatus;
    }

    public ACEType getAceType() {
        return this.aceType;
    }

    public String getAuthority() {
        return this.authority;
    }

    public AuthorityType getAuthorityType() {
        return this.authorityType;
    }

    public AccessControlEntryContext getContext() {
        return this.context;
    }

    public PermissionReference getPermission() {
        return this.permission;
    }

    public Integer getPosition() {
        return this.position;
    }

    public void setAccessStatus(AccessStatus accessStatus) {
        this.accessStatus = accessStatus;
    }

    public void setAceType(ACEType aceType) {
        this.aceType = aceType;
    }

    public void setAuthority(String authority) {
        this.authority = authority;
        this.authorityType = AuthorityType.getAuthorityType((String)authority);
    }

    public void setContext(AccessControlEntryContext context) {
        this.context = context;
    }

    public void setPermission(PermissionReference permission) {
        this.permission = permission;
    }

    public void setPosition(Integer position) {
        this.position = position;
    }

    public int compareTo(AccessControlEntry other) {
        int diff = this.getPosition() - other.getPosition();
        if (diff == 0) {
            diff = (this.getAccessStatus() == AccessStatus.DENIED ? 0 : 1) - (other.getAccessStatus() == AccessStatus.DENIED ? 0 : 1);
            if (diff == 0) {
                return this.getAuthorityType().getOrderPosition() - other.getAuthorityType().getOrderPosition();
            }
            return diff;
        }
        return diff;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append(this.getPermission()).append(", ");
        builder.append(this.getAuthority()).append(", ");
        builder.append(this.getAccessStatus()).append(", ");
        builder.append((Object)this.getAceType()).append(", ");
        builder.append(this.getPosition()).append(", ");
        builder.append(this.getContext());
        builder.append("]");
        return builder.toString();
    }
}

