/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.person;

import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.ArgumentHelper;
import org.alfresco.util.GUID;
import org.alfresco.util.PropertyMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;

public class PersonServiceLoader {
    private static Log logger = LogFactory.getLog(PersonServiceLoader.class);
    private final ApplicationContext ctx;
    private final int batchSize;
    private final int batchCount;

    private PersonServiceLoader(ApplicationContext ctx, int batchSize, int batchCount) {
        this.ctx = ctx;
        this.batchSize = batchSize;
        this.batchCount = batchCount;
    }

    public void run(String user, String pwd, int threads) throws Exception {
        Thread runner = null;
        for (int i = 0; i < threads; ++i) {
            runner = new Nester("Loader-" + i, runner, this.ctx, this.batchSize, this.batchCount);
        }
        if (runner != null) {
            runner.start();
            try {
                runner.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n").append("Usage\n").append("   PersonServiceLoader  --user=<username> --pwd=<password> --batch-count=<batch-count> --batch-size=<batch-size> --threads=<threads>\n");
        String usage = sb.toString();
        ArgumentHelper argHelper = new ArgumentHelper(usage, args);
        try {
            String user = argHelper.getStringValue("user", true, true);
            String pwd = argHelper.getStringValue("pwd", true, true);
            int batchCount = argHelper.getIntegerValue("batch-count", true, 1, Integer.MAX_VALUE);
            int batchSize = argHelper.getIntegerValue("batch-size", true, 1, Integer.MAX_VALUE);
            int threads = argHelper.getIntegerValue("threads", true, 1, Integer.MAX_VALUE);
            ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
            PersonServiceLoader loader = new PersonServiceLoader(ctx, batchSize, batchCount);
            loader.run(user, pwd, threads);
            AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getSystemUserName());
            ServiceRegistry serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
            MutableAuthenticationService authenticationService = serviceRegistry.getAuthenticationService();
            final PersonService personService = serviceRegistry.getPersonService();
            TransactionService transactionService = serviceRegistry.getTransactionService();
            final NodeService nodeService = serviceRegistry.getNodeService();
            String firstName = "" + System.currentTimeMillis();
            String lastName = String.format("%05d", -1);
            final String username = GUID.generate();
            String emailAddress = String.format("%s.%s@xyz.com", firstName, lastName);
            PropertyMap properties = new PropertyMap(7);
            properties.put(ContentModel.PROP_USERNAME, username);
            properties.put(ContentModel.PROP_FIRSTNAME, firstName);
            properties.put(ContentModel.PROP_LASTNAME, lastName);
            properties.put(ContentModel.PROP_EMAIL, emailAddress);
            NodeRef madePerson = personService.createPerson(properties);
            NodeRef homeFolder = (NodeRef)DefaultTypeConverter.INSTANCE.convert(NodeRef.class, (Object)nodeService.getProperty(madePerson, ContentModel.PROP_HOMEFOLDER));
            if (homeFolder != null) {
                throw new IllegalStateException("Home folder created eagerly");
            }
            RetryingTransactionHelper helper = transactionService.getRetryingTransactionHelper();
            helper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                @Override
                public Void execute() throws Throwable {
                    NodeRef person = personService.getPerson(username);
                    NodeRef homeFolder = (NodeRef)DefaultTypeConverter.INSTANCE.convert(NodeRef.class, (Object)nodeService.getProperty(person, ContentModel.PROP_HOMEFOLDER));
                    if (homeFolder == null) {
                        throw new IllegalStateException("Home folder not created lazily");
                    }
                    return null;
                }
            }, true, true);
            NodeRef autoPerson = personService.getPerson(GUID.generate());
            NodeRef autoHomeFolder = (NodeRef)DefaultTypeConverter.INSTANCE.convert(NodeRef.class, (Object)nodeService.getProperty(autoPerson, ContentModel.PROP_HOMEFOLDER));
            if (autoHomeFolder == null) {
                throw new IllegalStateException("Home folder not created lazily for auto created users");
            }
            ApplicationContextHelper.closeApplicationContext();
            System.exit(0);
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
            argHelper.printUsage();
            System.exit(1);
        }
        catch (Throwable e) {
            logger.error((Object)"PersonServiceLoader (userCount, batchSize) failed.", e);
            System.exit(1);
        }
    }

    static class Nester
    extends Thread {
        Thread waiter;
        int batchSize;
        int batchCount;
        ApplicationContext ctx;
        ServiceRegistry serviceRegistry;
        PersonService personService;
        TransactionService transactionService;

        Nester(String name, Thread waiter, ApplicationContext ctx, int batchSize, int batchCount) {
            super(name);
            this.setDaemon(true);
            this.waiter = waiter;
            this.ctx = ctx;
            this.serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
            this.personService = this.serviceRegistry.getPersonService();
            this.transactionService = this.serviceRegistry.getTransactionService();
            this.batchSize = batchSize;
            this.batchCount = batchCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block9: {
                AuthenticationUtil.setFullyAuthenticatedUser((String)"System");
                if (this.waiter != null) {
                    this.waiter.start();
                }
                try {
                    try {
                        RetryingTransactionHelper.RetryingTransactionCallback<Integer> makeUsersCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Integer>(){

                            @Override
                            public Integer execute() throws Throwable {
                                for (int i = 0; i < Nester.this.batchSize; ++i) {
                                    String firstName = "" + System.currentTimeMillis();
                                    String lastName = String.format("%05d", i);
                                    String username = GUID.generate();
                                    String emailAddress = String.format("%s.%s@xyz.com", firstName, lastName);
                                    PropertyMap properties = new PropertyMap(7);
                                    properties.put(ContentModel.PROP_USERNAME, username);
                                    properties.put(ContentModel.PROP_FIRSTNAME, firstName);
                                    properties.put(ContentModel.PROP_LASTNAME, lastName);
                                    properties.put(ContentModel.PROP_EMAIL, emailAddress);
                                    Nester.this.personService.createPerson(properties);
                                }
                                return Nester.this.batchSize;
                            }
                        };
                        for (int i = 0; i < this.batchCount; ++i) {
                            long start = System.nanoTime();
                            this.transactionService.getRetryingTransactionHelper().doInTransaction(makeUsersCallback, false, true);
                            long end = System.nanoTime();
                            double deltaMs = (double)(end - start) / 1000000.0;
                            double ave = deltaMs / (double)this.batchSize;
                            System.out.println("\n" + Thread.currentThread().getName() + "\n" + "Batch users created: \n" + "   Batch Number:    " + i + "\n" + "   Batch Size:      " + this.batchSize + "\n" + "   Batch Time (ms): " + Math.floor(deltaMs) + "\n" + "   Average (ms):    " + Math.floor(ave));
                        }
                        Object var12_9 = null;
                    }
                    catch (Exception e) {
                        System.out.println("End " + this.getName() + " with error " + e.getMessage());
                        e.printStackTrace();
                        Object var12_10 = null;
                        AuthenticationUtil.clearCurrentSecurityContext();
                        break block9;
                    }
                }
                catch (Throwable throwable) {
                    Object var12_11 = null;
                    AuthenticationUtil.clearCurrentSecurityContext();
                    throw throwable;
                }
                AuthenticationUtil.clearCurrentSecurityContext();
            }
            if (this.waiter == null) return;
            try {
                this.waiter.join();
                return;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

