/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.person;

import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.person.ExistingPathBasedHomeFolderProvider;
import org.alfresco.repo.security.person.HomeSpaceNodeRef;
import org.alfresco.repo.security.person.PersonException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.util.FileNameValidator;

public class UIDBasedHomeFolderProvider
extends ExistingPathBasedHomeFolderProvider {
    private String templatePath;
    private NodeRef templateNodeRef;

    public void setTemplatePath(String templatePath) {
        this.templatePath = templatePath;
    }

    protected HomeSpaceNodeRef getHomeFolder(NodeRef person) {
        FileFolderService fileFolderService = this.getServiceRegistry().getFileFolderService();
        NodeService nodeService = this.getServiceRegistry().getNodeService();
        NodeRef existingHomeFolder = (NodeRef)DefaultTypeConverter.INSTANCE.convert(NodeRef.class, (Object)nodeService.getProperty(person, ContentModel.PROP_HOMEFOLDER));
        if (existingHomeFolder == null) {
            FileInfo fileInfo;
            String uid = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)nodeService.getProperty(person, ContentModel.PROP_USERNAME));
            if (uid == null || uid.length() == 0) {
                throw new PersonException("Can not create a home space when the uid is null or empty");
            }
            String homeFolderName = FileNameValidator.getValidFileName(uid);
            NodeRef exising = fileFolderService.searchSimple(this.getPathNodeRef(), homeFolderName);
            if (exising != null) {
                fileInfo = fileFolderService.getFileInfo(exising);
            } else if (this.templatePath == null) {
                fileInfo = fileFolderService.create(this.getPathNodeRef(), homeFolderName, ContentModel.TYPE_FOLDER);
            } else {
                try {
                    fileInfo = fileFolderService.copy(this.getTemplateNodeRef(), this.getPathNodeRef(), homeFolderName);
                }
                catch (FileNotFoundException e) {
                    throw new PersonException("Invalid template to create home space");
                }
            }
            NodeRef homeFolderNodeRef = fileInfo.getNodeRef();
            return new HomeSpaceNodeRef(homeFolderNodeRef, HomeSpaceNodeRef.Status.CREATED);
        }
        return new HomeSpaceNodeRef(existingHomeFolder, HomeSpaceNodeRef.Status.VALID);
    }

    protected synchronized NodeRef getTemplateNodeRef() {
        if (this.templateNodeRef == null) {
            this.templateNodeRef = this.resolvePath(this.templatePath);
        }
        return this.templateNodeRef;
    }
}

