/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.template;

import java.util.List;
import java.util.StringTokenizer;
import org.alfresco.repo.search.QueryParameterDefImpl;
import org.alfresco.repo.template.BasePathResultsMap;
import org.alfresco.repo.template.TemplateNode;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.search.QueryParameterDefinition;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;

public class NamePathResultsMap
extends BasePathResultsMap {
    public NamePathResultsMap(TemplateNode parent, ServiceRegistry services) {
        super(parent, services);
    }

    public Object get(Object key) {
        String path = key.toString();
        StringBuilder xpath = new StringBuilder(path.length() << 1);
        StringTokenizer t = new StringTokenizer(path, "/");
        int count = 0;
        QueryParameterDefinition[] params = new QueryParameterDefinition[t.countTokens()];
        DataTypeDefinition ddText = this.services.getDictionaryService().getDataType(DataTypeDefinition.TEXT);
        NamespaceService ns = this.services.getNamespaceService();
        while (t.hasMoreTokens()) {
            if (xpath.length() != 0) {
                xpath.append('/');
            }
            String strCount = Integer.toString(count);
            xpath.append("*[@cm:name=$cm:name").append(strCount).append(']');
            params[count++] = new QueryParameterDefImpl(QName.createQName((String)"cm", (String)("name" + strCount), (NamespacePrefixResolver)ns), ddText, true, t.nextToken());
        }
        List<TemplateNode> nodes = this.getChildrenByXPath(xpath.toString(), params, true);
        return nodes.size() != 0 ? nodes.get(0) : null;
    }
}

