/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transfer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.alfresco.repo.transfer.AbstractNodeFinder;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChildAssociatedNodeFinder
extends AbstractNodeFinder {
    private Set<QName> suppliedAssociationTypes = new HashSet<QName>();
    private boolean exclude = false;
    private boolean initialised = false;
    private List<QName> childAssociationTypes = new ArrayList<QName>();

    public ChildAssociatedNodeFinder() {
    }

    public ChildAssociatedNodeFinder(Set<QName> associationTypeNames) {
        this.setAssociationTypes(associationTypeNames);
    }

    public ChildAssociatedNodeFinder(QName ... associationTypeNames) {
        this.setAssociationTypes(associationTypeNames);
    }

    public ChildAssociatedNodeFinder(Set<QName> associationTypeNames, boolean exclude) {
        this.setAssociationTypes(associationTypeNames);
        this.exclude = exclude;
    }

    public void setAssociationTypes(QName ... associationTypes) {
        this.setAssociationTypes(Arrays.asList(associationTypes));
    }

    public void setAssociationTypes(Collection<QName> associationTypes) {
        this.suppliedAssociationTypes = new HashSet<QName>(associationTypes);
        this.initialised = false;
    }

    public void setExclude(boolean exclude) {
        this.exclude = exclude;
    }

    @Override
    public Set<NodeRef> findFrom(NodeRef thisNode) {
        if (!this.initialised) {
            this.init();
        }
        if (this.exclude) {
            return this.processExcludedSet(thisNode);
        }
        return this.processIncludedSet(thisNode);
    }

    private Set<NodeRef> processExcludedSet(NodeRef thisNode) {
        HashSet<NodeRef> results = new HashSet<NodeRef>(89);
        NodeService nodeService = this.serviceRegistry.getNodeService();
        List children = nodeService.getChildAssocs(thisNode);
        boolean filterChildren = !this.childAssociationTypes.isEmpty();
        for (ChildAssociationRef child : children) {
            if (filterChildren && this.childAssociationTypes.contains(child.getTypeQName())) continue;
            results.add(child.getChildRef());
        }
        return results;
    }

    private Set<NodeRef> processIncludedSet(NodeRef startingNode) {
        NodeService nodeService = this.serviceRegistry.getNodeService();
        HashSet<NodeRef> foundNodes = new HashSet<NodeRef>(89);
        for (QName assocType : this.childAssociationTypes) {
            List children = nodeService.getChildAssocs(startingNode, (QNamePattern)assocType, RegexQNamePattern.MATCH_ALL);
            for (ChildAssociationRef child : children) {
                foundNodes.add(child.getChildRef());
            }
        }
        return foundNodes;
    }

    @Override
    public void init() {
        super.init();
        DictionaryService dictionaryService = this.serviceRegistry.getDictionaryService();
        this.childAssociationTypes.clear();
        for (QName associationType : this.suppliedAssociationTypes) {
            AssociationDefinition assocDef = dictionaryService.getAssociation(associationType);
            if (assocDef == null || !assocDef.isChild()) continue;
            this.childAssociationTypes.add(associationType);
        }
        this.initialised = true;
    }
}

