/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transfer;

import java.io.InputStream;
import java.io.Serializable;
import java.nio.channels.Channels;
import java.util.Map;
import java.util.TreeMap;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transfer.TransferDestinationReportWriter;
import org.alfresco.repo.transfer.TransferFatalException;
import org.alfresco.repo.transfer.TransferModel;
import org.alfresco.repo.transfer.TransferProgressMonitor;
import org.alfresco.repo.transfer.reportd.XMLTransferDestinationReportWriter;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.transfer.TransferException;
import org.alfresco.service.cmr.transfer.TransferProgress;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RepoTransferProgressMonitorImpl
implements TransferProgressMonitor {
    private static final Log log = LogFactory.getLog(RepoTransferProgressMonitorImpl.class);
    private static final String MSG_TRANSFER_NOT_FOUND = "transfer_service.receiver.transfer_not_found";
    private static final String MSG_TRANSFER_CANCELLED = "transfer_service.receiver.transfer_cancelled";
    private NodeService nodeService;
    private ContentService contentService;
    private TransactionService transactionService;
    private Map<String, TransferDestinationReportWriter> transferLogWriters = new TreeMap<String, TransferDestinationReportWriter>();

    public TransferProgress getProgress(final String transferId) {
        return this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<TransferProgress>(){

            @Override
            public TransferProgress execute() throws Throwable {
                NodeRef nodeRef = RepoTransferProgressMonitorImpl.this.getTransferRecord(transferId);
                TransferProgress progress = new TransferProgress();
                progress.setStatus(TransferProgress.Status.valueOf((String)((Object)RepoTransferProgressMonitorImpl.this.nodeService.getProperty(nodeRef, TransferModel.PROP_TRANSFER_STATUS))));
                progress.setCurrentPosition((Integer)RepoTransferProgressMonitorImpl.this.nodeService.getProperty(nodeRef, TransferModel.PROP_PROGRESS_POSITION));
                progress.setEndPosition((Integer)RepoTransferProgressMonitorImpl.this.nodeService.getProperty(nodeRef, TransferModel.PROP_PROGRESS_ENDPOINT));
                progress.setError((Throwable)RepoTransferProgressMonitorImpl.this.nodeService.getProperty(nodeRef, TransferModel.PROP_TRANSFER_ERROR));
                return progress;
            }
        }, false, true);
    }

    public void logComment(String transferId, Object obj) {
        TransferDestinationReportWriter writer = this.getLogWriter(transferId);
        writer.writeComment(obj.toString());
    }

    public void logException(final String transferId, final Object obj, final Throwable ex) {
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public NodeRef execute() throws Throwable {
                TransferDestinationReportWriter writer = RepoTransferProgressMonitorImpl.this.getLogWriter(transferId);
                writer.writeComment(obj.toString());
                if (ex != null) {
                    NodeRef nodeRef = RepoTransferProgressMonitorImpl.this.getTransferRecord(transferId);
                    RepoTransferProgressMonitorImpl.this.nodeService.setProperty(nodeRef, TransferModel.PROP_TRANSFER_ERROR, (Serializable)ex);
                    writer.writeException(ex);
                }
                return null;
            }
        }, false, true);
    }

    public void logCreated(String transferId, NodeRef sourceNode, NodeRef destNode, NodeRef parentNodeRef, Path parentPath, boolean orphan) {
        TransferDestinationReportWriter writer = this.getLogWriter(transferId);
        writer.writeCreated(sourceNode, destNode, parentNodeRef, parentPath);
    }

    public void logUpdated(String transferId, NodeRef sourceNodeRef, NodeRef destNodeRef, Path path) {
        TransferDestinationReportWriter writer = this.getLogWriter(transferId);
        writer.writeUpdated(sourceNodeRef, destNodeRef, path);
    }

    public void logMoved(String transferId, NodeRef sourceNodeRef, NodeRef destNodeRef, Path oldPath, NodeRef newParentNodeRef, Path newPath) {
        TransferDestinationReportWriter writer = this.getLogWriter(transferId);
        writer.writeMoved(sourceNodeRef, destNodeRef, oldPath, newParentNodeRef, newPath);
    }

    public void logDeleted(String transferId, NodeRef sourceNodeRef, NodeRef destNodeRef, Path oldPath) {
        TransferDestinationReportWriter writer = this.getLogWriter(transferId);
        writer.writeDeleted(sourceNodeRef, destNodeRef, oldPath);
    }

    public void updateProgress(final String transferId, final int currPos) {
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public NodeRef execute() throws Throwable {
                NodeRef nodeRef = RepoTransferProgressMonitorImpl.this.getTransferRecord(transferId);
                RepoTransferProgressMonitorImpl.this.testCancelled(nodeRef);
                RepoTransferProgressMonitorImpl.this.nodeService.setProperty(nodeRef, TransferModel.PROP_PROGRESS_POSITION, (Serializable)new Integer(currPos));
                return null;
            }
        }, false, true);
    }

    public void updateProgress(final String transferId, final int currPos, final int endPos) {
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public NodeRef execute() throws Throwable {
                NodeRef nodeRef = RepoTransferProgressMonitorImpl.this.getTransferRecord(transferId);
                RepoTransferProgressMonitorImpl.this.testCancelled(nodeRef);
                RepoTransferProgressMonitorImpl.this.nodeService.setProperty(nodeRef, TransferModel.PROP_PROGRESS_POSITION, (Serializable)new Integer(currPos));
                RepoTransferProgressMonitorImpl.this.nodeService.setProperty(nodeRef, TransferModel.PROP_PROGRESS_ENDPOINT, (Serializable)new Integer(endPos));
                return null;
            }
        }, false, true);
    }

    public void updateStatus(final String transferId, final TransferProgress.Status status) {
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public NodeRef execute() throws Throwable {
                NodeRef nodeRef = RepoTransferProgressMonitorImpl.this.getTransferRecord(transferId);
                RepoTransferProgressMonitorImpl.this.testCancelled(nodeRef);
                String currentStatusString = (String)((Object)RepoTransferProgressMonitorImpl.this.nodeService.getProperty(nodeRef, TransferModel.PROP_TRANSFER_STATUS));
                TransferProgress.Status currentStatus = TransferProgress.Status.valueOf(currentStatusString);
                TransferDestinationReportWriter writer = RepoTransferProgressMonitorImpl.this.getLogWriter(transferId);
                writer.writeChangeState(status.toString());
                if (!TransferProgress.getTerminalStatuses().contains((Object)currentStatus)) {
                    RepoTransferProgressMonitorImpl.this.nodeService.setProperty(nodeRef, TransferModel.PROP_TRANSFER_STATUS, (Serializable)((Object)status.toString()));
                    if (TransferProgress.getTerminalStatuses().contains((Object)status)) {
                        log.debug((Object)"closing destination transfer report");
                        writer.endTransferReport();
                        RepoTransferProgressMonitorImpl.this.transferLogWriters.remove(transferId);
                    }
                }
                return null;
            }
        }, false, true);
    }

    private void testCancelled(NodeRef transferRecord) throws TransferFatalException {
        TransferProgress.Status currentStatus = TransferProgress.Status.valueOf((String)((Object)this.nodeService.getProperty(transferRecord, TransferModel.PROP_TRANSFER_STATUS)));
        if (TransferProgress.Status.CANCELLED.equals((Object)currentStatus)) {
            throw new TransferFatalException(MSG_TRANSFER_CANCELLED, new Object[]{transferRecord.toString()});
        }
    }

    private NodeRef getTransferRecord(String transferId) throws TransferException {
        NodeRef nodeRef = new NodeRef(transferId);
        if (!this.nodeService.exists(nodeRef) || !this.nodeService.getType(nodeRef).equals((Object)TransferModel.TYPE_TRANSFER_RECORD)) {
            throw new TransferException(MSG_TRANSFER_NOT_FOUND, new Object[]{transferId});
        }
        return nodeRef;
    }

    private TransferDestinationReportWriter getLogWriter(String transferId) {
        TransferDestinationReportWriter writer = this.transferLogWriters.get(transferId);
        if (writer == null) {
            NodeRef node = new NodeRef(transferId);
            ContentWriter contentWriter = this.contentService.getWriter(node, ContentModel.PROP_CONTENT, true);
            contentWriter.setMimetype("text/xml");
            contentWriter.setEncoding("UTF-8");
            writer = new XMLTransferDestinationReportWriter();
            try {
                writer.startTransferReport("UTF-8", Channels.newWriter(contentWriter.getWritableChannel(), "UTF-8"));
            }
            catch (ContentIOException e) {
                e.printStackTrace();
            }
            this.transferLogWriters.put(transferId, writer);
        }
        return writer;
    }

    public InputStream getLogInputStream(String transferId) throws TransferException {
        NodeRef transferRecord = this.getTransferRecord(transferId);
        ContentReader reader = this.contentService.getReader(transferRecord, ContentModel.PROP_CONTENT);
        if (reader != null) {
            return reader.getContentInputStream();
        }
        return null;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }
}

