/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow;

import java.io.Serializable;
import java.util.Map;
import org.alfresco.repo.content.ContentServicePolicies;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.workflow.WorkflowDeployer;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowDefinitionType
implements ContentServicePolicies.OnContentUpdatePolicy,
NodeServicePolicies.OnUpdatePropertiesPolicy,
NodeServicePolicies.BeforeDeleteNodePolicy {
    private PolicyComponent policyComponent;
    private WorkflowDeployer workflowDeployer;

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setWorkflowDeployer(WorkflowDeployer workflowDeployer) {
        this.workflowDeployer = workflowDeployer;
    }

    public void init() {
        this.policyComponent.bindClassBehaviour(ContentServicePolicies.OnContentUpdatePolicy.QNAME, WorkflowModel.TYPE_WORKFLOW_DEF, (Behaviour)new JavaBehaviour(this, "onContentUpdate"));
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onUpdateProperties"), WorkflowModel.TYPE_WORKFLOW_DEF, (Behaviour)new JavaBehaviour(this, "onUpdateProperties"));
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"beforeDeleteNode"), WorkflowModel.TYPE_WORKFLOW_DEF, (Behaviour)new JavaBehaviour(this, "beforeDeleteNode"));
    }

    @Override
    public void onContentUpdate(NodeRef nodeRef, boolean newContent) {
        this.workflowDeployer.deploy(nodeRef, true);
    }

    @Override
    public void onUpdateProperties(NodeRef nodeRef, Map<QName, Serializable> before, Map<QName, Serializable> after) {
        Boolean beforeValue = (Boolean)before.get(WorkflowModel.PROP_WORKFLOW_DEF_DEPLOYED);
        Boolean afterValue = (Boolean)after.get(WorkflowModel.PROP_WORKFLOW_DEF_DEPLOYED);
        if (afterValue != null && (beforeValue == null || beforeValue != null && afterValue != null && !beforeValue.equals(afterValue))) {
            if (afterValue.booleanValue()) {
                this.workflowDeployer.deploy(nodeRef, true);
            } else {
                this.workflowDeployer.undeploy(nodeRef);
            }
        } else if (afterValue == null && beforeValue != null) {
            this.workflowDeployer.undeploy(nodeRef);
        }
    }

    @Override
    public void beforeDeleteNode(NodeRef nodeRef) {
        this.workflowDeployer.undeploy(nodeRef);
    }
}

