/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow.jbpm;

import java.util.ArrayList;
import java.util.Collection;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.jscript.ScriptNode;
import org.alfresco.repo.security.authority.AuthorityDAO;
import org.alfresco.repo.workflow.jbpm.AlfrescoJavaScript;
import org.alfresco.repo.workflow.jbpm.JBPMNode;
import org.alfresco.repo.workflow.jbpm.JBPMSpringAssignmentHandler;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.workflow.WorkflowException;
import org.alfresco.service.namespace.QName;
import org.dom4j.Element;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.taskmgmt.exe.Assignable;
import org.springframework.beans.factory.BeanFactory;

public class AlfrescoAssignment
extends JBPMSpringAssignmentHandler {
    private static final long serialVersionUID = 1025667849552265719L;
    private ServiceRegistry services;
    private DictionaryService dictionaryService;
    private AuthorityDAO authorityDAO;
    private Element actor;
    private Element pooledactors;

    protected void initialiseHandler(BeanFactory factory) {
        this.services = (ServiceRegistry)factory.getBean("ServiceRegistry");
        this.dictionaryService = this.services.getDictionaryService();
        this.authorityDAO = (AuthorityDAO)factory.getBean("authorityDAO");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void assign(Assignable assignable, ExecutionContext executionContext) throws Exception {
        String pooledactorValStr;
        String actorValStr;
        if (this.actor == null && this.pooledactors == null) {
            throw new WorkflowException("no actor or pooled actors has been specified");
        }
        String assignedActor = null;
        if (this.actor != null && (actorValStr = this.actor.getTextTrim()) != null && actorValStr.length() > 0) {
            if (actorValStr.startsWith("#{")) {
                String expression = actorValStr.substring(2, actorValStr.length() - 1);
                Object eval = AlfrescoJavaScript.executeScript(executionContext, this.services, expression, null);
                if (eval == null) {
                    throw new WorkflowException("actor expression '" + actorValStr + "' evaluates to null");
                }
                String actor = null;
                if (eval instanceof String) {
                    actor = (String)eval;
                } else if (eval instanceof JBPMNode) {
                    actor = this.mapAuthorityToName((JBPMNode)eval, false);
                }
                if (actor == null) {
                    throw new WorkflowException("actor expression must evaluate to a person");
                }
                assignedActor = actor;
            } else {
                assignedActor = actorValStr;
            }
        }
        String[] assignedPooledActors = null;
        if (this.pooledactors != null && (pooledactorValStr = this.pooledactors.getTextTrim()) != null && pooledactorValStr.length() > 0) {
            if (pooledactorValStr.startsWith("#{")) {
                String expression = pooledactorValStr.substring(2, pooledactorValStr.length() - 1);
                Object eval = AlfrescoJavaScript.executeScript(executionContext, this.services, expression, null);
                if (eval == null) {
                    throw new WorkflowException("pooledactors expression '" + pooledactorValStr + "' evaluates to null");
                }
                if (eval instanceof ScriptNode[]) {
                    ScriptNode[] nodes = (ScriptNode[])eval;
                    assignedPooledActors = new String[nodes.length];
                    int i = 0;
                    for (ScriptNode node : nodes) {
                        String actor = this.mapAuthorityToName(node, true);
                        if (actor == null) {
                            throw new WorkflowException("pooledactors expression does not evaluate to a collection of authorities");
                        }
                        assignedPooledActors[i++] = actor;
                    }
                }
                if (eval instanceof Collection) {
                    ArrayList<String> actors = new ArrayList<String>();
                    Collection nodes = (Collection)eval;
                    for (Object node : nodes) {
                        if (!(node instanceof ScriptNode)) continue;
                        String actor = this.mapAuthorityToName((ScriptNode)node, true);
                        if (actor == null) {
                            throw new WorkflowException("pooledactors expression does not evaluate to a collection of authorities");
                        }
                        actors.add(actor);
                    }
                    assignedPooledActors = new String[actors.size()];
                    actors.toArray(assignedPooledActors);
                } else if (eval instanceof ScriptNode) {
                    ScriptNode node = (ScriptNode)eval;
                    String actor = this.mapAuthorityToName(node, true);
                    if (actor == null) {
                        throw new WorkflowException("pooledactors expression does not evaluate to a collection of authorities");
                    }
                    assignedPooledActors = new String[]{actor};
                } else {
                    if (!(eval instanceof String)) throw new WorkflowException("pooledactors expression does not evaluate to a collection of authorities");
                    assignedPooledActors = new String[]{(String)eval};
                }
            } else {
                assignedPooledActors = new String[]{pooledactorValStr};
            }
        }
        if (assignedActor != null) {
            assignable.setActorId(assignedActor);
        }
        if (assignedPooledActors == null) return;
        assignable.setPooledActors(assignedPooledActors);
    }

    private String mapAuthorityToName(ScriptNode authority, boolean allowGroup) {
        String name = null;
        QName type = authority.getQNameType();
        if (this.dictionaryService.isSubClass(type, ContentModel.TYPE_PERSON)) {
            name = (String)authority.getProperties().get(ContentModel.PROP_USERNAME);
        } else if (allowGroup && this.dictionaryService.isSubClass(type, ContentModel.TYPE_AUTHORITY_CONTAINER)) {
            name = this.authorityDAO.getAuthorityName(authority.getNodeRef());
        } else if (type.equals((Object)ContentModel.TYPE_AUTHORITY)) {
            name = this.authorityDAO.getAuthorityName(authority.getNodeRef());
        }
        return name;
    }
}

