/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow.jbpm;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.i18n.MessageService;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.workflow.BPMEngineRegistry;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.repo.workflow.jbpm.JBPMEngine;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.service.cmr.workflow.WorkflowDeployment;
import org.alfresco.service.cmr.workflow.WorkflowException;
import org.alfresco.service.cmr.workflow.WorkflowInstance;
import org.alfresco.service.cmr.workflow.WorkflowPath;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.NamespaceServiceMemoryImpl;
import org.alfresco.service.namespace.QName;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.test.AbstractTransactionalSpringContextTests;
import org.springmodules.workflow.jbpm31.JbpmTemplate;

public class JBPMEngineUnitTest
extends AbstractTransactionalSpringContextTests {
    private static final String USER_NAME = "admin";
    private static final String TEST_JBPM_ENGINE = "test_jbpm_engine";
    private static final NodeRef companyHome = new NodeRef("for://test/home");
    private JBPMEngine engine = new JBPMEngine();
    private WorkflowDefinition workflowDef;

    public void testDeployWorkflow() throws Exception {
        ClassPathResource processDef = new ClassPathResource("jbpmresources/test_processdefinition.xml");
        List<WorkflowDefinition> workflowDefs = this.engine.getDefinitions();
        JBPMEngineUnitTest.assertFalse((boolean)this.engine.isDefinitionDeployed(processDef.getInputStream(), "text/xml"));
        JBPMEngineUnitTest.assertNotNull(workflowDefs);
        int workflowDefCnt = workflowDefs.size();
        this.deployTestDefinition();
        JBPMEngineUnitTest.assertTrue((boolean)this.engine.isDefinitionDeployed(processDef.getInputStream(), "text/xml"));
        workflowDefs = this.engine.getDefinitions();
        JBPMEngineUnitTest.assertNotNull(workflowDefs);
        JBPMEngineUnitTest.assertEquals((int)(workflowDefCnt + 1), (int)workflowDefs.size());
        JBPMEngineUnitTest.assertNotNull((Object)this.workflowDef);
        JBPMEngineUnitTest.assertEquals((String)"test_jbpm_engine$test", (String)this.workflowDef.name);
        JBPMEngineUnitTest.assertEquals((String)"1", (String)this.workflowDef.version);
        this.deployTestDefinition();
        JBPMEngineUnitTest.assertTrue((boolean)this.engine.isDefinitionDeployed(processDef.getInputStream(), "text/xml"));
        JBPMEngineUnitTest.assertEquals((String)"2", (String)this.workflowDef.version);
    }

    public void testGetWorkflowInstance() throws Exception {
        this.deployTestDefinition();
        WorkflowPath path = this.engine.startWorkflow(this.workflowDef.getId(), null);
        this.checkPath(path);
        WorkflowInstance instance = this.engine.getWorkflowById(path.instance.id);
        JBPMEngineUnitTest.assertNotNull((Object)instance);
        JBPMEngineUnitTest.assertEquals((String)path.instance.id, (String)instance.id);
    }

    public void testStartWorkflowWithoutPackage() throws Exception {
        try {
            this.engine.startWorkflow("norfolknchance", null);
            JBPMEngineUnitTest.fail((String)"Failed to catch invalid definition id");
        }
        catch (WorkflowException e) {
            // empty catch block
        }
        this.deployTestDefinition();
        WorkflowPath path = this.engine.startWorkflow(this.workflowDef.getId(), null);
        JBPMEngineUnitTest.assertNotNull((Object)path);
        JBPMEngineUnitTest.assertTrue((boolean)path.id.endsWith("-@"));
        JBPMEngineUnitTest.assertNotNull((Object)path.node);
        JBPMEngineUnitTest.assertNotNull((Object)path.instance);
        JBPMEngineUnitTest.assertEquals((String)this.workflowDef.getId(), (String)path.instance.definition.id);
    }

    public void testStartWorkflowParameters() throws Exception {
        HashMap<QName, Serializable> params = new HashMap<QName, Serializable>();
        params.put(WorkflowModel.PROP_TASK_ID, Integer.valueOf(3));
        params.put(WorkflowModel.PROP_DUE_DATE, new Date());
        params.put(WorkflowModel.PROP_PRIORITY, Integer.valueOf(1));
        params.put(WorkflowModel.PROP_PERCENT_COMPLETE, Integer.valueOf(10));
        params.put(QName.createQName((String)"", (String)"Message"), (Serializable)((Object)"Hello World"));
        params.put(QName.createQName((String)"", (String)"Array"), (Serializable)new String[]{"one", "two"});
        params.put(QName.createQName((String)"", (String)"NodeRef"), (Serializable)new NodeRef("workspace://1/1001"));
        params.put(ContentModel.PROP_OWNER, (Serializable)((Object)"Owner"));
        this.deployTestDefinition();
        WorkflowPath path = this.engine.startWorkflow(this.workflowDef.id, params);
        this.checkPath(path);
        List<WorkflowTask> tasks1 = this.engine.getTasksForWorkflowPath(path.id);
        JBPMEngineUnitTest.assertNotNull(tasks1);
        JBPMEngineUnitTest.assertEquals((int)1, (int)tasks1.size());
        WorkflowTask task = tasks1.get(0);
        JBPMEngineUnitTest.assertTrue((boolean)task.properties.containsKey(WorkflowModel.PROP_TASK_ID));
        JBPMEngineUnitTest.assertTrue((boolean)task.properties.containsKey(WorkflowModel.PROP_DUE_DATE));
        JBPMEngineUnitTest.assertTrue((boolean)task.properties.containsKey(WorkflowModel.PROP_PRIORITY));
        JBPMEngineUnitTest.assertTrue((boolean)task.properties.containsKey(WorkflowModel.PROP_PERCENT_COMPLETE));
        JBPMEngineUnitTest.assertTrue((boolean)task.properties.containsKey(ContentModel.PROP_OWNER));
    }

    public void testUpdateTask() throws Exception {
        HashMap<QName, Serializable> params = new HashMap<QName, Serializable>();
        params.put(WorkflowModel.PROP_TASK_ID, Integer.valueOf(3));
        params.put(WorkflowModel.PROP_DUE_DATE, new Date());
        params.put(WorkflowModel.PROP_PRIORITY, Integer.valueOf(1));
        params.put(WorkflowModel.PROP_PERCENT_COMPLETE, Integer.valueOf(10));
        params.put(QName.createQName((String)"", (String)"Message"), (Serializable)((Object)"Hello World"));
        params.put(QName.createQName((String)"", (String)"Array"), (Serializable)new String[]{"one", "two"});
        params.put(QName.createQName((String)"", (String)"NodeRef"), (Serializable)new NodeRef("workspace://1/1001"));
        params.put(ContentModel.PROP_OWNER, (Serializable)((Object)USER_NAME));
        this.deployTestDefinition();
        WorkflowPath path = this.engine.startWorkflow(this.workflowDef.id, params);
        this.checkPath(path);
        List<WorkflowTask> tasks1 = this.engine.getTasksForWorkflowPath(path.id);
        JBPMEngineUnitTest.assertNotNull(tasks1);
        JBPMEngineUnitTest.assertEquals((int)1, (int)tasks1.size());
        WorkflowTask task = tasks1.get(0);
        JBPMEngineUnitTest.assertTrue((boolean)task.properties.containsKey(WorkflowModel.PROP_TASK_ID));
        JBPMEngineUnitTest.assertTrue((boolean)task.properties.containsKey(WorkflowModel.PROP_DUE_DATE));
        JBPMEngineUnitTest.assertTrue((boolean)task.properties.containsKey(WorkflowModel.PROP_PRIORITY));
        JBPMEngineUnitTest.assertTrue((boolean)task.properties.containsKey(WorkflowModel.PROP_PERCENT_COMPLETE));
        JBPMEngineUnitTest.assertTrue((boolean)task.properties.containsKey(ContentModel.PROP_OWNER));
        try {
            WorkflowTask taskU1 = this.engine.updateTask(task.id, null, null, null);
            JBPMEngineUnitTest.assertNotNull((Object)taskU1);
        }
        catch (Throwable e) {
            JBPMEngineUnitTest.fail((String)"Task update failed with null parameters");
        }
        HashMap<QName, Serializable> updateProperties2 = new HashMap<QName, Serializable>();
        updateProperties2.put(WorkflowModel.PROP_PERCENT_COMPLETE, Integer.valueOf(100));
        WorkflowTask taskU2 = this.engine.updateTask(task.id, updateProperties2, null, null);
        JBPMEngineUnitTest.assertEquals((Object)100, (Object)taskU2.properties.get(WorkflowModel.PROP_PERCENT_COMPLETE));
        QName assocName = QName.createQName((String)"", (String)"TestAssoc");
        ArrayList<NodeRef> toAdd = new ArrayList<NodeRef>();
        toAdd.add(new NodeRef("workspace://1/1001"));
        toAdd.add(new NodeRef("workspace://1/1002"));
        toAdd.add(new NodeRef("workspace://1/1003"));
        HashMap<QName, List<NodeRef>> addAssocs = new HashMap<QName, List<NodeRef>>();
        addAssocs.put(assocName, toAdd);
        WorkflowTask taskU3 = this.engine.updateTask(task.id, null, addAssocs, null);
        JBPMEngineUnitTest.assertNotNull((Object)taskU3.properties.get(assocName));
        Serializable assoc = taskU3.properties.get(assocName);
        JBPMEngineUnitTest.assertNotNull((Object)assoc);
        JBPMEngineUnitTest.assertEquals((int)3, (int)((List)((Object)assoc)).size());
        ArrayList<NodeRef> toAddAgain = new ArrayList<NodeRef>();
        toAddAgain.add(new NodeRef("workspace://1/1004"));
        toAddAgain.add(new NodeRef("workspace://1/1005"));
        HashMap<QName, List<NodeRef>> addAssocsAgain = new HashMap<QName, List<NodeRef>>();
        addAssocsAgain.put(assocName, toAddAgain);
        WorkflowTask taskU4 = this.engine.updateTask(task.id, null, addAssocsAgain, null);
        JBPMEngineUnitTest.assertNotNull((Object)taskU4.properties.get(assocName));
        assoc = taskU4.properties.get(assocName);
        JBPMEngineUnitTest.assertEquals((int)5, (int)((List)((Object)assoc)).size());
        ArrayList<NodeRef> toRemove = new ArrayList<NodeRef>();
        toRemove.add(new NodeRef("workspace://1/1002"));
        toRemove.add(new NodeRef("workspace://1/1003"));
        HashMap<QName, List<NodeRef>> removeAssocs = new HashMap<QName, List<NodeRef>>();
        removeAssocs.put(assocName, toRemove);
        WorkflowTask taskU5 = this.engine.updateTask(task.id, null, null, removeAssocs);
        JBPMEngineUnitTest.assertNotNull((Object)taskU5.properties.get(assocName));
        assoc = taskU5.properties.get(assocName);
        JBPMEngineUnitTest.assertEquals((int)3, (int)((List)((Object)assoc)).size());
    }

    public void testGetWorkflowInstances() throws Exception {
        this.deployTestDefinition();
        WorkflowPath path1 = this.engine.startWorkflow(this.workflowDef.id, null);
        WorkflowPath path2 = this.engine.startWorkflow(this.workflowDef.id, null);
        List<WorkflowInstance> instances = this.engine.getActiveWorkflows(this.workflowDef.id);
        JBPMEngineUnitTest.assertNotNull(instances);
        JBPMEngineUnitTest.assertEquals((int)2, (int)instances.size());
        HashSet<String> ids = new HashSet<String>(2);
        ids.add(path1.instance.id);
        ids.add(path2.instance.id);
        for (WorkflowInstance instance : instances) {
            JBPMEngineUnitTest.assertEquals((String)this.workflowDef.id, (String)instance.definition.id);
            JBPMEngineUnitTest.assertTrue((boolean)ids.contains(instance.id));
        }
    }

    public void testGetPositions() throws Exception {
        this.deployTestDefinition();
        this.engine.startWorkflow(this.workflowDef.id, null);
        List<WorkflowInstance> instances = this.engine.getActiveWorkflows(this.workflowDef.id);
        JBPMEngineUnitTest.assertNotNull(instances);
        JBPMEngineUnitTest.assertEquals((int)1, (int)instances.size());
        List<WorkflowPath> paths = this.engine.getWorkflowPaths(instances.get((int)0).id);
        JBPMEngineUnitTest.assertNotNull(paths);
        JBPMEngineUnitTest.assertEquals((int)1, (int)paths.size());
        JBPMEngineUnitTest.assertEquals((String)instances.get((int)0).id, (String)paths.get((int)0).instance.id);
        JBPMEngineUnitTest.assertTrue((boolean)paths.get((int)0).id.endsWith("-@"));
    }

    private void checkPath(WorkflowPath path) {
        JBPMEngineUnitTest.assertNotNull((Object)path);
        JBPMEngineUnitTest.assertTrue((boolean)path.id.endsWith("-@"));
        JBPMEngineUnitTest.assertNotNull((Object)path.node);
        JBPMEngineUnitTest.assertNotNull((Object)path.instance);
        JBPMEngineUnitTest.assertEquals((String)this.workflowDef.id, (String)path.instance.definition.id);
    }

    protected void onSetUpBeforeTransaction() throws Exception {
        super.onSetUpBeforeTransaction();
        NodeService nodeService = (NodeService)Mockito.mock(NodeService.class);
        TenantService tenantService = this.makeTenantService();
        NamespaceService namespaceService = this.makeNamespaceService();
        DictionaryService dictionaryService = this.makeDictionaryService();
        ServiceRegistry serviceRegistry = (ServiceRegistry)Mockito.mock(ServiceRegistry.class);
        Mockito.when((Object)serviceRegistry.getNodeService()).thenReturn((Object)nodeService);
        Mockito.when((Object)serviceRegistry.getNamespaceService()).thenReturn((Object)namespaceService);
        Mockito.when((Object)serviceRegistry.getDictionaryService()).thenReturn((Object)dictionaryService);
        BPMEngineRegistry engineRegistry = (BPMEngineRegistry)this.getApplicationContext().getBean("test_bpm_engineRegistry");
        ConfigurableApplicationContext ctx = this.getApplicationContext();
        JbpmTemplate jbpmTemplate = (JbpmTemplate)ctx.getBean("test_jbpm_template");
        this.engine.setJBPMTemplate(jbpmTemplate);
        this.engine.setTenantService(tenantService);
        this.engine.setNodeService(nodeService);
        this.engine.setServiceRegistry(serviceRegistry);
        this.engine.setNamespaceService(namespaceService);
        this.engine.setMessageService((MessageService)Mockito.mock(MessageService.class));
        this.engine.setDictionaryService(dictionaryService);
        this.engine.setEngineId(TEST_JBPM_ENGINE);
        this.engine.setBPMEngineRegistry(engineRegistry);
        ConfigurableApplicationContext appContext = this.getApplicationContext();
        if (!appContext.containsBean(TEST_JBPM_ENGINE)) {
            appContext.getBeanFactory().registerSingleton(TEST_JBPM_ENGINE, (Object)this.engine);
        }
    }

    private DictionaryService makeDictionaryService() {
        DictionaryService service = (DictionaryService)Mockito.mock(DictionaryService.class);
        TypeDefinition typeDef = (TypeDefinition)Mockito.mock(TypeDefinition.class);
        Mockito.when((Object)service.getType((QName)Mockito.any())).thenReturn((Object)typeDef);
        Mockito.when((Object)service.getAnonymousType((QName)Mockito.any(), (Collection)Mockito.any())).thenReturn((Object)typeDef);
        return service;
    }

    private void deployTestDefinition() throws IOException {
        ClassPathResource processDef = new ClassPathResource("jbpmresources/test_processdefinition.xml");
        WorkflowDeployment deployment = this.engine.deployDefinition(processDef.getInputStream(), "text/xml");
        this.workflowDef = deployment.definition;
        JBPMEngineUnitTest.assertNotNull((Object)this.workflowDef);
        JBPMEngineUnitTest.assertEquals((String)"test_jbpm_engine$test", (String)this.workflowDef.name);
    }

    private NamespaceService makeNamespaceService() {
        NamespaceServiceMemoryImpl namespace = new NamespaceServiceMemoryImpl();
        namespace.registerNamespace("", "");
        namespace.registerNamespace("wf", "http://www.alfresco.org/model/bpm/1.0");
        namespace.registerNamespace("cm", "http://www.alfresco.org/model/content/1.0");
        namespace.registerNamespace("wcmwf", "http://www.alfresco.org/model/wcmworkflow/1.0");
        namespace.registerNamespace("imwf", "http://www.alfresco.org/model/workflow/invite/moderated/1.0");
        namespace.registerNamespace("inwf", "http://www.alfresco.org/model/workflow/invite/nominated/1.0");
        return namespace;
    }

    private TenantService makeTenantService() {
        TenantService tenantService = (TenantService)Mockito.mock(TenantService.class);
        Mockito.when((Object)tenantService.isEnabled()).thenReturn((Object)true);
        Mockito.when((Object)tenantService.getRootNode((NodeService)Mockito.any(), (SearchService)Mockito.any(), (NamespaceService)Mockito.any(), Mockito.anyString(), (NodeRef)Mockito.any())).thenReturn((Object)companyHome);
        Mockito.when((Object)tenantService.getName(Mockito.anyString())).thenAnswer((Answer)new Answer<String>(){

            public String answer(InvocationOnMock invocation) throws Throwable {
                return (String)invocation.getArguments()[0];
            }
        });
        Mockito.when((Object)tenantService.getBaseName(Mockito.anyString())).thenAnswer((Answer)new Answer<String>(){

            public String answer(InvocationOnMock invocation) throws Throwable {
                return (String)invocation.getArguments()[0];
            }
        });
        return tenantService;
    }

    protected String[] getConfigLocations() {
        String[] locations = new String[]{"classpath:jbpm-test/test-workflow-context.xml"};
        return locations;
    }
}

