/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import com.sun.star.registry.XRegistryKey;
import com.sun.star.registry.XSimpleRegistry;
import com.sun.star.uno.UnoRuntime;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.util.Map;
import java.util.TreeMap;
import net.sf.jooreports.openoffice.connection.AbstractOpenOfficeConnection;
import net.sf.jooreports.openoffice.connection.OpenOfficeConnection;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.content.metadata.MetadataExtracterRegistry;
import org.alfresco.util.OpenOfficeConnectionEvent;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;
import org.springframework.extensions.surf.util.I18NUtil;

public class OpenOfficeConnectionTester
extends AbstractLifecycleBean {
    private static final String ATTRIBUTE_AVAILABLE = "available";
    private static final String INFO_CONNECTION_VERIFIED = "system.openoffice.info.connection_verified";
    private static final String ERR_CONNECTION_FAILED = "system.openoffice.err.connection_failed";
    private static final String ERR_CONNECTION_LOST = "system.openoffice.err.connection_lost";
    private static final String ERR_CONNECTION_REMADE = "system.openoffice.err.connection_remade";
    private static Log logger = LogFactory.getLog(OpenOfficeConnectionTester.class);
    private OpenOfficeConnection connection;
    private Map<String, Object> openOfficeMetadata = new TreeMap<String, Object>();
    private boolean strict = false;

    public void setConnection(OpenOfficeConnection connection) {
        this.connection = connection;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    protected void onBootstrap(ApplicationEvent event) {
        this.checkConnection();
        ((ApplicationContext)event.getSource()).publishEvent((ApplicationEvent)new OpenOfficeConnectionEvent(this.openOfficeMetadata));
    }

    protected void onShutdown(ApplicationEvent event) {
        if (this.connection != null && this.connection.isConnected()) {
            this.connection.disconnect();
        }
    }

    private void checkConnection() {
        String connectedMessage = I18NUtil.getMessage((String)INFO_CONNECTION_VERIFIED);
        boolean connected = this.testAndConnect();
        OpenOfficeConnectionTesterJob.wasConnected = connected;
        if (connected) {
            logger.debug((Object)connectedMessage);
            return;
        }
        String msg = I18NUtil.getMessage((String)ERR_CONNECTION_FAILED);
        if (this.strict) {
            throw new AlfrescoRuntimeException(msg);
        }
        logger.warn((Object)msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean testAndConnect() {
        Map<String, Object> map = this.openOfficeMetadata;
        synchronized (map) {
            Boolean lastAvailability;
            PropertyCheck.mandatory((Object)((Object)this), (String)"connection", (Object)this.connection);
            if (!this.connection.isConnected()) {
                try {
                    this.connection.connect();
                }
                catch (ConnectException e) {
                    this.openOfficeMetadata.clear();
                    this.openOfficeMetadata.put(ATTRIBUTE_AVAILABLE, Boolean.FALSE);
                    return false;
                }
            }
            if ((lastAvailability = (Boolean)this.openOfficeMetadata.get(ATTRIBUTE_AVAILABLE)) == null || !lastAvailability.booleanValue()) {
                this.openOfficeMetadata.put(ATTRIBUTE_AVAILABLE, Boolean.TRUE);
                try {
                    Method getServiceMethod = AbstractOpenOfficeConnection.class.getDeclaredMethod("getService", String.class);
                    getServiceMethod.setAccessible(true);
                    Object configurationRegistry = getServiceMethod.invoke((Object)this.connection, "com.sun.star.configuration.ConfigurationRegistry");
                    XSimpleRegistry registry = (XSimpleRegistry)UnoRuntime.queryInterface(XSimpleRegistry.class, (Object)configurationRegistry);
                    registry.open("org.openoffice.Setup", true, false);
                    XRegistryKey root = registry.getRootKey();
                    XRegistryKey product = root.openKey("Product");
                    block12: for (XRegistryKey key : product.openKeys()) {
                        switch (key.getValueType().getValue()) {
                            case 1: {
                                this.openOfficeMetadata.put(key.getKeyName(), key.getLongValue());
                                continue block12;
                            }
                            case 2: {
                                this.openOfficeMetadata.put(key.getKeyName(), key.getAsciiValue());
                                continue block12;
                            }
                            case 3: {
                                this.openOfficeMetadata.put(key.getKeyName(), key.getStringValue());
                            }
                        }
                    }
                    registry.close();
                }
                catch (Exception e) {
                    logger.warn((Object)"Error trying to query Open Office version information", (Throwable)e);
                }
            }
        }
        return true;
    }

    public static class OpenOfficeConnectionTesterJob
    implements Job {
        private static volatile Boolean wasConnected;

        public synchronized void execute(JobExecutionContext context) throws JobExecutionException {
            JobDataMap jobData = context.getJobDetail().getJobDataMap();
            Object openOfficeConnectionTesterObj = jobData.get((Object)"openOfficeConnectionTester");
            if (openOfficeConnectionTesterObj == null || !(openOfficeConnectionTesterObj instanceof OpenOfficeConnectionTester)) {
                throw new AlfrescoRuntimeException("OpenOfficeConnectionJob data must contain valid 'openOfficeConnectionTester' reference");
            }
            OpenOfficeConnectionTester openOfficeConnectionTester = (OpenOfficeConnectionTester)((Object)openOfficeConnectionTesterObj);
            Object metadataExractorRegistryObj = jobData.get((Object)"metadataExractorRegistry");
            MetadataExtracterRegistry metadataExtracterRegistry = null;
            if (metadataExractorRegistryObj != null && metadataExractorRegistryObj instanceof MetadataExtracterRegistry) {
                metadataExtracterRegistry = (MetadataExtracterRegistry)metadataExractorRegistryObj;
            }
            boolean connected = openOfficeConnectionTester.testAndConnect();
            if (wasConnected != null && wasConnected != connected) {
                if (connected) {
                    logger.info((Object)I18NUtil.getMessage((String)OpenOfficeConnectionTester.ERR_CONNECTION_REMADE));
                } else {
                    logger.error((Object)I18NUtil.getMessage((String)OpenOfficeConnectionTester.ERR_CONNECTION_LOST));
                }
                if (metadataExtracterRegistry != null) {
                    metadataExtracterRegistry.resetCache();
                }
            }
            wasConnected = connected;
        }
    }
}

