/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.perf;

import com.vladium.utils.timing.ITimer;
import com.vladium.utils.timing.TimerFactory;
import org.alfresco.util.perf.AbstractPerformanceMonitor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PerformanceMonitor
extends AbstractPerformanceMonitor {
    private String methodName;
    private ThreadLocal<ITimer> threadLocalTimer;
    private boolean log;

    public PerformanceMonitor(String entityName, String methodName) {
        super(entityName);
        this.methodName = methodName;
        this.threadLocalTimer = new ThreadLocal();
        Log methodLogger = LogFactory.getLog((String)("performance." + entityName + "." + methodName));
        this.log = AbstractPerformanceMonitor.isDebugEnabled() && methodLogger.isDebugEnabled();
    }

    public void start() {
        if (!this.log) {
            return;
        }
        ITimer timer = TimerFactory.newTimer();
        this.threadLocalTimer.set(timer);
        timer.start();
    }

    public void stop() {
        if (!this.log) {
            return;
        }
        ITimer timer = this.threadLocalTimer.get();
        if (timer == null) {
            return;
        }
        timer.stop();
        this.recordStats(this.methodName, timer.getDuration());
        this.threadLocalTimer.set(null);
    }
}

