/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm.preview;

import java.text.MessageFormat;
import java.util.Map;
import org.alfresco.wcm.AbstractWCMServiceImplTest;
import org.alfresco.wcm.preview.NullPreviewURIService;
import org.alfresco.wcm.preview.PreviewURIService;
import org.alfresco.wcm.preview.PreviewURIServiceProvider;
import org.alfresco.wcm.preview.PreviewURIServiceRegistry;
import org.alfresco.wcm.webproject.WebProjectInfo;

public class PreviewURIServiceImplTest
extends AbstractWCMServiceImplTest {
    private PreviewURIServiceRegistry previewURIServiceRegistry;
    private PreviewURIService prevService;

    protected void setUp() throws Exception {
        super.setUp();
        this.previewURIServiceRegistry = (PreviewURIServiceRegistry)ctx.getBean("previewURIServiceRegistry");
        this.prevService = (PreviewURIService)ctx.getBean("WCMPreviewURIService");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testSetup() {
        Map<String, PreviewURIServiceProvider> prevURIServiceProviders = this.previewURIServiceRegistry.getPreviewURIServiceProviders();
        System.out.println(prevURIServiceProviders.keySet());
    }

    public void testDefaultAndNOOP() {
        WebProjectInfo wpInfo = this.wpService.createWebProject(TEST_WEBPROJ_DNS + "-previewSimple", TEST_WEBPROJ_NAME + "-previewSimple", "This is my title", "This is my description");
        PreviewURIServiceImplTest.assertNotNull((Object)wpInfo);
        String stagingPreviewURL = this.prevService.getPreviewURI(wpInfo.getStagingStoreName(), null);
        PreviewURIServiceImplTest.assertNotNull((Object)stagingPreviewURL);
        String expectedURL = MessageFormat.format("http://{0}.www--sandbox.{1}:{2}", wpInfo.getStoreId(), "127-0-0-1.ip.alfrescodemo.net", "8180");
        PreviewURIServiceImplTest.assertEquals((String)expectedURL, (String)stagingPreviewURL);
        String nullProvName = null;
        Map<String, PreviewURIServiceProvider> prevURIServiceProviders = this.previewURIServiceRegistry.getPreviewURIServiceProviders();
        for (Map.Entry<String, PreviewURIServiceProvider> entry : prevURIServiceProviders.entrySet()) {
            PreviewURIServiceProvider prov = entry.getValue();
            if (!(prov instanceof NullPreviewURIService)) continue;
            nullProvName = entry.getKey();
            break;
        }
        PreviewURIServiceImplTest.assertNotNull(nullProvName);
        wpInfo.setPreviewProviderName(nullProvName);
        this.wpService.updateWebProject(wpInfo);
        stagingPreviewURL = this.prevService.getPreviewURI(wpInfo.getStagingStoreName(), null);
        PreviewURIServiceImplTest.assertNull((Object)stagingPreviewURL);
    }
}

