/*
 * Copyright (C) 2005-2010 Alfresco Software Limited.
 *
 * This file is part of Alfresco
 *
 * Alfresco is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Alfresco is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Alfresco. If not, see <http://www.gnu.org/licenses/>.
 */
package org.alfresco.repo.management.subsystems;

import java.util.List;

import org.springframework.context.ApplicationEvent;

/**
 * A base class for events emitted by {@link PropertyBackedBean}s.
 * 
 * @author dward
 */
public abstract class PropertyBackedBeanEvent extends ApplicationEvent
{
    private static final long serialVersionUID = -5414152423990988923L;

    /** The ID of the bean that emitted the event. */
    private List<String> sourceId;

    /**
     * The Constructor.
     * 
     * @param source
     *            the source of the event
     */
    public PropertyBackedBeanEvent(PropertyBackedBean source)
    {
        super(source);
        this.sourceId = source.getId();
    }

    /**
     * Gets the ID of the bean that emitted the event.
     * 
     * @return the ID
     */
    public List<String> getSourceId()
    {
        return this.sourceId;
    }
}
