/*
 * Copyright (C) 2005-2010 Alfresco Software Limited.
 *
 * This file is part of Alfresco
 *
 * Alfresco is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Alfresco is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Alfresco. If not, see <http://www.gnu.org/licenses/>.
 */
package org.alfresco.web.action.evaluator;

import javax.faces.context.FacesContext;

import org.alfresco.model.ForumModel;
import org.alfresco.web.bean.ml.MultilingualUtils;
import org.alfresco.web.bean.repository.Node;

/**
 * UI Action Evaluator - Create a forum around a multilingual content node.
 *
 * @author Yanick Pignot
 */
public class CreateForumMLNodeEvaluator extends BaseActionEvaluator
{
   private static final long serialVersionUID = -8621940623410511065L;

   /**
    * @see org.alfresco.web.action.ActionEvaluator#evaluate(org.alfresco.web.bean.repository.Node)
    */
   public boolean evaluate(Node node)
   {
       // the current user must have enough right to add a content to the space
       // where the pivot translation is located in
       return MultilingualUtils.canAddChildrenToPivotSpace(node, FacesContext.getCurrentInstance())
                   && node.hasAspect(ForumModel.ASPECT_DISCUSSABLE) == false
                   && node.isLocked() == false;

   }
}
