/*
 * Copyright (C) 2005-2010 Alfresco Software Limited.
 *
 * This file is part of Alfresco
 *
 * Alfresco is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Alfresco is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Alfresco. If not, see <http://www.gnu.org/licenses/>.
 */
package org.alfresco.web.ui.repo;

/**
 * Class containing well known web resource paths for images etc.
 * 
 * @author Kevin Roast
 */
public class WebResources extends org.alfresco.web.ui.common.WebResources
{
   // Image paths
   public static final String IMAGE_SPACE       = "/images/icons/space_small.gif";
   public static final String IMAGE_CATEGORY    = "/images/icons/category_small.gif";
   public static final String IMAGE_REMOVE      = "/images/icons/delete.gif";
   public static final String IMAGE_COPY        = "/images/icons/copy.gif";
   public static final String IMAGE_CUT         = "/images/icons/cut.gif";
   public static final String IMAGE_PASTE       = "/images/icons/paste.gif";
   public static final String IMAGE_PASTE_LINK  = "/images/icons/paste_link.gif";
   public static final String IMAGE_LOCK        = "/images/icons/locked.gif";
   public static final String IMAGE_LOCK_OWNER  = "/images/icons/locked_owner.gif";
   public static final String IMAGE_PERSON      = "/images/icons/person.gif";
   public static final String IMAGE_GROUP       = "/images/icons/group.gif";
   public static final String IMAGE_WORKFLOW_32 = "/images/icons/workflow_large.gif";
}
