/*
 * Copyright (C) 2005-2010 Alfresco Software Limited.
 *
 * This file is part of Alfresco
 *
 * Alfresco is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Alfresco is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Alfresco. If not, see <http://www.gnu.org/licenses/>.
 */
package org.alfresco.web.config.header;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.alfresco.web.config.forms.ControlParam;
import org.alfresco.web.config.forms.DependenciesConfigElement;
import org.alfresco.web.config.forms.DependenciesElementReader;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.ConfigException;
import org.springframework.extensions.config.element.ConfigElementAdapter;

/**
 * Custom config element that represents 'header' values for the client.
 * 
 * @author Mike Hatfield.
 */
public class HeaderConfigElement extends ConfigElementAdapter
{
    private static final long serialVersionUID = 7721694406825674057L;

    public static final String HEADER_ID = "header";

    private HeaderItemsConfigElement appItemsConfigElement;
    private HeaderItemsConfigElement userItemsConfigElement;
    private DependenciesConfigElement dependenciesConfigElement;
    
    public HeaderConfigElement()
    {
        super(HEADER_ID);
    }

    public HeaderConfigElement(String name)
    {
        super(name);
    }

    /**
     * @see org.alfresco.config.ConfigElement#getChildren()
     */
    @Override
    public List<ConfigElement> getChildren()
    {
        throw new ConfigException(
            "Reading the header config via the generic interfaces is not supported");
    }

    public HeaderItemsConfigElement getAppItems()
    {
        return this.appItemsConfigElement;
    }

    void setAppItems(HeaderItemsConfigElement items)
    {
        this.appItemsConfigElement = items;
    }

    public HeaderItemsConfigElement getUserItems()
    {
        return this.userItemsConfigElement;
    }

    void setUserItems(HeaderItemsConfigElement items)
    {
        this.userItemsConfigElement = items;
    }

    public DependenciesConfigElement getDependencies()
    {
        return this.dependenciesConfigElement;
    }

    void setDependencies(DependenciesConfigElement dependencies)
    {
        this.dependenciesConfigElement = dependencies;
    }
        
    /**
     * @see org.alfresco.config.ConfigElement#combine(org.alfresco.config.ConfigElement)
     */
    @Override
    public ConfigElement combine(ConfigElement otherConfigElement)
    {
        HeaderConfigElement otherHeaderElem = (HeaderConfigElement)otherConfigElement;
        HeaderConfigElement result = new HeaderConfigElement();

        /*
        for (String thisFormId : this.formElementsById.keySet())
        {
            if (otherFormsElem.formElementsById.containsKey(thisFormId))
            {
                FormConfigElement otherFormCE = otherFormsElem.getForm(thisFormId);
                FormConfigElement combinedElement = (FormConfigElement)formElementsById.get(thisFormId).combine(otherFormCE);
                result.addFormById(combinedElement, thisFormId);
            }
            else
            {
                result.addFormById(this.formElementsById.get(thisFormId), thisFormId);
            }
        }
        for (String otherFormId : otherFormsElem.formElementsById.keySet())
        {
            if (this.formElementsById.containsKey(otherFormId))
            {
                // Ignore it. The combination was handled in the previous loop.
            }
            else
            {
                result.addFormById(otherFormsElem.formElementsById.get(otherFormId), otherFormId);
            }
        }
        */
        
        // Combine dependencies
        ConfigElement combinedDependencies = this.dependenciesConfigElement == null ?
                otherHeaderElem.getDependencies()
                : this.dependenciesConfigElement.combine(otherHeaderElem.getDependencies());
        result.setDependencies((DependenciesConfigElement)combinedDependencies);
        
        return result;
    }
}