/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.crypto;

import de.schlichtherle.truezip.crypto.SeekableBlockCipher;
import de.schlichtherle.truezip.rof.DecoratingReadOnlyFile;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import javax.annotation.Nullable;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.NotThreadSafe;
import org.bouncycastle.crypto.Mac;

@NotThreadSafe
public abstract class CipherReadOnlyFile
extends DecoratingReadOnlyFile {
    private static final long INVALID = Long.MIN_VALUE;
    private long start;
    private long length;
    private long pos;
    private long bufferStart = Long.MIN_VALUE;
    private byte[] buffer;
    @Nullable
    private SeekableBlockCipher cipher;
    private long blockStart = Long.MIN_VALUE;
    private byte[] block;

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    protected CipherReadOnlyFile(@Nullable @WillCloseWhenClosed ReadOnlyFile rof) {
        super(rof);
    }

    protected final void init(SeekableBlockCipher cipher, long start, long length) throws IOException {
        if (null == this.delegate) {
            throw new IllegalStateException();
        }
        if (null != this.cipher) {
            throw new IllegalStateException();
        }
        this.cipher = cipher;
        if (null == this.cipher) {
            throw new IllegalArgumentException();
        }
        this.start = start;
        if (0L > this.start) {
            throw new IllegalArgumentException();
        }
        this.length = length;
        if (0L > this.length) {
            throw new IllegalArgumentException();
        }
        int blockSize = cipher.getBlockSize();
        this.block = new byte[blockSize];
        this.buffer = new byte[8192 / blockSize * blockSize];
        assert (this.buffer.length % blockSize == 0);
    }

    private void checkOpen() throws IOException {
        if (null == this.cipher) {
            throw new IOException("cipher read only file is not in open state");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] computeMac(Mac mac) throws IOException {
        long safedFp = this.getFilePointer();
        try {
            long length = this.length;
            int bufferSize = this.buffer.length;
            this.pos = 0L;
            while (this.pos < length) {
                this.positionBuffer();
                int bufferLimit = (int)Math.min((long)bufferSize, length - this.bufferStart);
                assert (0 < bufferLimit);
                mac.update(this.buffer, 0, bufferLimit);
                this.pos += (long)bufferLimit;
            }
            byte[] buf = new byte[mac.getMacSize()];
            int bufLength = mac.doFinal(buf, 0);
            assert (bufLength == buf.length);
            byte[] byArray = buf;
            return byArray;
        }
        finally {
            this.seek(safedFp);
        }
    }

    @Override
    public int read() throws IOException {
        this.checkOpen();
        if (this.pos >= this.length) {
            return -1;
        }
        this.positionBlock();
        return this.block[(int)(this.pos++ % (long)this.block.length)] & 0xFF;
    }

    @Override
    public int read(byte[] dst, int offset, int remaining) throws IOException {
        int blockPos;
        if (remaining <= 0) {
            return 0;
        }
        long length = this.length;
        if (this.getFilePointer() >= length) {
            return -1;
        }
        int or = offset + remaining;
        if ((offset | remaining | or | dst.length - or) < 0) {
            throw new IndexOutOfBoundsException();
        }
        int total = 0;
        int blockSize = this.block.length;
        this.positionBlock();
        if (this.pos != this.blockStart) {
            assert (this.pos % (long)blockSize != 0L);
            blockPos = (int)(this.pos - this.blockStart);
            int blockLimit = Math.min(remaining, blockSize - blockPos);
            blockLimit = (int)Math.min((long)blockLimit, length - this.pos);
            assert (blockLimit > 0);
            System.arraycopy(this.block, blockPos, dst, offset, blockLimit);
            total += blockLimit;
            this.pos += (long)blockLimit;
        }
        if (total < remaining && this.pos < length) {
            SeekableBlockCipher cipher = this.cipher;
            byte[] buffer = this.buffer;
            long blockCounter = this.pos / (long)blockSize;
            while (total + blockSize <= remaining && this.pos + (long)blockSize <= length) {
                assert (this.pos % (long)blockSize == 0L);
                this.positionBuffer();
                cipher.setBlockCounter(blockCounter++);
                int bufferPos = (int)(this.pos - this.bufferStart);
                int blockLimit = cipher.processBlock(buffer, bufferPos, dst, offset + total);
                assert (blockLimit == blockSize);
                total += blockLimit;
                this.pos += (long)blockLimit;
            }
        }
        if (total < remaining && this.pos < length) {
            assert (this.pos % (long)blockSize == 0L);
            this.positionBlock();
            blockPos = (int)(this.pos - this.blockStart);
            int blockLimit = Math.min(remaining - total, blockSize - blockPos);
            blockLimit = (int)Math.min((long)blockLimit, length - this.pos);
            assert (blockLimit > 0);
            System.arraycopy(this.block, blockPos, dst, offset + total, blockLimit);
            total += blockLimit;
            this.pos += (long)blockLimit;
        }
        return total;
    }

    @Override
    public long getFilePointer() throws IOException {
        this.checkOpen();
        return this.pos;
    }

    @Override
    public void seek(long pos) throws IOException {
        this.checkOpen();
        if (pos < 0L) {
            throw new IOException("file pointer must not be negative");
        }
        if (pos > this.length) {
            throw new IOException("file pointer (" + pos + ") is larger than file length (" + this.length + ")");
        }
        this.pos = pos;
    }

    @Override
    public long length() throws IOException {
        this.checkOpen();
        return this.length;
    }

    @Override
    public void close() throws IOException {
        this.cipher = null;
        this.delegate.close();
    }

    private void positionBlock() throws IOException {
        long nextBlockPos;
        byte[] block = this.block;
        int blockSize = block.length;
        long blockStart = this.blockStart;
        long pos = this.pos;
        if (blockStart <= pos && pos < (nextBlockPos = blockStart + (long)blockSize)) {
            return;
        }
        SeekableBlockCipher cipher = this.cipher;
        assert (null != cipher);
        this.positionBuffer();
        long blockCounter = pos / (long)blockSize;
        cipher.setBlockCounter(blockCounter);
        this.blockStart = blockStart = blockCounter * (long)blockSize;
        int bufferPos = (int)(blockStart - this.bufferStart);
        int processed = cipher.processBlock(this.buffer, bufferPos, block, 0);
        assert (processed == blockSize);
    }

    private void positionBuffer() throws IOException {
        byte[] buffer = this.buffer;
        int bufferSize = buffer.length;
        long pos = this.pos;
        long bufferStart = this.bufferStart;
        long nextBufferStart = bufferStart + (long)bufferSize;
        if (bufferStart <= pos && pos < nextBufferStart) {
            return;
        }
        try {
            int read;
            ReadOnlyFile delegate = this.delegate;
            this.bufferStart = bufferStart = pos / (long)bufferSize * (long)bufferSize;
            if (bufferStart != nextBufferStart) {
                delegate.seek(this.start + bufferStart);
            }
            int total = 0;
            while ((read = delegate.read(buffer, total, bufferSize - total)) >= 0 && (total += read) < bufferSize) {
            }
        }
        catch (IOException ex) {
            this.bufferStart = Long.MIN_VALUE;
            throw ex;
        }
    }
}

