/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.module;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.module.ModuleVersionNumber;
import org.alfresco.service.cmr.module.ModuleDependency;
import org.alfresco.service.cmr.module.ModuleDetails;
import org.alfresco.service.cmr.module.ModuleInstallState;
import org.alfresco.util.Pair;
import org.alfresco.util.VersionNumber;
import org.springframework.extensions.surf.util.ISO8601DateFormat;

public class ModuleDetailsImpl
implements ModuleDetails {
    private static final long serialVersionUID = 5782747774317351424L;
    private String id;
    private List<String> aliases = new ArrayList<String>(0);
    private ModuleVersionNumber version;
    private String title;
    private String description;
    private List<String> editions;
    private VersionNumber repoVersionMin = VersionNumber.VERSION_ZERO;
    private VersionNumber repoVersionMax = VersionNumber.VERSION_BIG;
    private List<ModuleDependency> dependencies = new ArrayList<ModuleDependency>(0);
    private Date installDate;
    private ModuleInstallState installState = ModuleInstallState.UNKNOWN;

    private ModuleDetailsImpl() {
    }

    public ModuleDetailsImpl(Properties properties) {
        this();
        String aliasesStr;
        Properties trimmedProperties = new Properties();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String trimmedValue;
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (value == null || (trimmedValue = value.trim()).length() == 0) continue;
            trimmedProperties.setProperty(key, trimmedValue);
        }
        ArrayList<String> missingProperties = new ArrayList<String>(1);
        this.id = trimmedProperties.getProperty("module.id");
        if (this.id == null) {
            missingProperties.add("module.id");
        }
        if ((aliasesStr = trimmedProperties.getProperty("module.aliases")) != null) {
            StringTokenizer st = new StringTokenizer(aliasesStr, ",");
            while (st.hasMoreTokens()) {
                String alias = st.nextToken().trim();
                if (alias.length() == 0) continue;
                this.aliases.add(alias);
            }
        }
        if (trimmedProperties.getProperty("module.version") == null) {
            missingProperties.add("module.version");
        } else {
            try {
                this.version = new ModuleVersionNumber(trimmedProperties.getProperty("module.version"));
            }
            catch (Throwable e) {
                throw new AlfrescoRuntimeException("Unable to parse version information: module.version, " + trimmedProperties.getProperty("module.version"), e);
            }
        }
        this.title = trimmedProperties.getProperty("module.title");
        if (this.title == null) {
            missingProperties.add("module.title");
        }
        this.description = trimmedProperties.getProperty("module.description");
        if (this.description == null) {
            missingProperties.add("module.description");
        }
        if (trimmedProperties.getProperty("module.repo.version.min") != null) {
            try {
                this.repoVersionMin = new VersionNumber(trimmedProperties.getProperty("module.repo.version.min"));
            }
            catch (Throwable t) {
                throw new AlfrescoRuntimeException("Unable to parse repo version min: module.repo.version.min, " + this.repoVersionMin, t);
            }
        }
        if (trimmedProperties.getProperty("module.repo.version.max") != null) {
            try {
                this.repoVersionMax = new VersionNumber(trimmedProperties.getProperty("module.repo.version.max"));
            }
            catch (Throwable t) {
                throw new AlfrescoRuntimeException("Unable to parse repo version max: module.repo.version.max, " + this.repoVersionMax, t);
            }
        }
        this.dependencies = ModuleDetailsImpl.extractDependencies(trimmedProperties);
        this.editions = ModuleDetailsImpl.extractEditions(trimmedProperties);
        if (trimmedProperties.getProperty("module.installDate") != null) {
            String installDateStr = trimmedProperties.getProperty("module.installDate");
            try {
                this.installDate = ISO8601DateFormat.parse(installDateStr);
            }
            catch (Throwable e) {
                throw new AlfrescoRuntimeException("Unable to parse install date: module.installDate, " + installDateStr, e);
            }
        }
        if (trimmedProperties.getProperty("module.installState") != null) {
            String installStateStr = trimmedProperties.getProperty("module.installState");
            try {
                this.installState = ModuleInstallState.valueOf(installStateStr);
            }
            catch (Throwable e) {
                throw new AlfrescoRuntimeException("Unable to parse install state: module.installState, " + installStateStr, e);
            }
        }
        if (missingProperties.size() > 0) {
            throw new AlfrescoRuntimeException("The following module properties need to be defined: " + missingProperties);
        }
        if (this.repoVersionMax.compareTo(this.repoVersionMin) < 0) {
            throw new AlfrescoRuntimeException("The max repo version must be greater than the min repo version:\n   ID:               " + this.id + "\n" + "   Min repo version: " + this.repoVersionMin + "\n" + "   Max repo version: " + this.repoVersionMax);
        }
        if (this.id.matches(".*[^\\w.-].*")) {
            throw new AlfrescoRuntimeException("The module ID '" + this.id + "' is invalid.  It may consist of valid characters, numbers, '.', '_' and '-'");
        }
    }

    public ModuleDetailsImpl(String id, ModuleVersionNumber versionNumber, String title, String description) {
        this();
        this.id = id;
        this.version = versionNumber;
        this.title = title;
        this.description = description;
    }

    private static List<String> extractEditions(Properties trimmedProperties) {
        ArrayList<String> specifiedEditions = null;
        String editions = trimmedProperties.getProperty("module.editions");
        if (editions != null) {
            specifiedEditions = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(editions, ",");
            while (st.hasMoreTokens()) {
                specifiedEditions.add(st.nextToken());
            }
        }
        return specifiedEditions;
    }

    private static List<ModuleDependency> extractDependencies(Properties properties) {
        int prefixLength = "module.depends.".length();
        ArrayList<ModuleDependency> dependencies = new ArrayList<ModuleDependency>(2);
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!key.startsWith("module.depends.") || key.length() == prefixLength) continue;
            String dependencyId = key.substring(prefixLength);
            ModuleDependencyImpl dependency = new ModuleDependencyImpl(dependencyId, value);
            dependencies.add(dependency);
        }
        return dependencies;
    }

    @Override
    public Properties getProperties() {
        Properties properties = new Properties();
        properties.setProperty("module.id", this.id);
        properties.setProperty("module.version", this.version.toString());
        properties.setProperty("module.title", this.title);
        properties.setProperty("module.description", this.description);
        if (this.repoVersionMin != null) {
            properties.setProperty("module.repo.version.min", this.repoVersionMin.toString());
        }
        if (this.repoVersionMax != null) {
            properties.setProperty("module.repo.version.max", this.repoVersionMax.toString());
        }
        if (this.editions != null) {
            properties.setProperty("module.editions", ModuleDetailsImpl.join(this.editions.toArray(new String[this.editions.size()]), ','));
        }
        if (this.dependencies.size() > 0) {
            for (ModuleDependency dependency : this.dependencies) {
                String key = "module.depends." + dependency.getDependencyId();
                String value = dependency.getVersionString();
                properties.setProperty(key, value);
            }
        }
        if (this.installDate != null) {
            String installDateStr = ISO8601DateFormat.format(this.installDate);
            properties.setProperty("module.installDate", installDateStr);
        }
        if (this.installState != null) {
            String installStateStr = this.installState.toString();
            properties.setProperty("module.installState", installStateStr);
        }
        if (this.aliases.size() > 0) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (String oldId : this.aliases) {
                if (!first) {
                    sb.append(", ");
                }
                sb.append(oldId);
                first = false;
            }
            properties.setProperty("module.aliases", sb.toString());
        }
        return properties;
    }

    public String toString() {
        return "ModuleDetails[" + this.getProperties() + "]";
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public List<String> getAliases() {
        return this.aliases;
    }

    @Override
    public ModuleVersionNumber getModuleVersionNumber() {
        return this.version;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public VersionNumber getRepoVersionMin() {
        return this.repoVersionMin;
    }

    @Override
    public void setRepoVersionMin(VersionNumber repoVersionMin) {
        this.repoVersionMin = repoVersionMin;
    }

    @Override
    public VersionNumber getRepoVersionMax() {
        return this.repoVersionMax;
    }

    @Override
    public void setRepoVersionMax(VersionNumber repoVersionMax) {
        this.repoVersionMax = repoVersionMax;
    }

    @Override
    public List<ModuleDependency> getDependencies() {
        return this.dependencies;
    }

    @Override
    public Date getInstallDate() {
        return this.installDate;
    }

    @Override
    public void setInstallDate(Date installDate) {
        this.installDate = installDate;
    }

    @Override
    public ModuleInstallState getInstallState() {
        return this.installState;
    }

    @Override
    public void setInstallState(ModuleInstallState installState) {
        this.installState = installState;
    }

    @Override
    public List<String> getEditions() {
        return this.editions;
    }

    @Override
    public void setEditions(List<String> editions) {
        this.editions = editions;
    }

    private static String join(Object[] array, char separator) {
        if (array == null) {
            return null;
        }
        return ModuleDetailsImpl.join(array, separator, 0, array.length);
    }

    private static String join(Object[] array, char separator, int startIndex, int endIndex) {
        if (array == null) {
            return null;
        }
        int bufSize = endIndex - startIndex;
        if (bufSize <= 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer(bufSize *= (array[startIndex] == null ? 16 : array[startIndex].toString().length()) + 1);
        int i = startIndex;
        while (i < endIndex) {
            if (i > startIndex) {
                buf.append(separator);
            }
            if (array[i] != null) {
                buf.append(array[i]);
            }
            ++i;
        }
        return buf.toString();
    }

    @Override
    public VersionNumber getVersion() {
        String mavenVersion = this.version.toString();
        StringBuffer b = new StringBuffer();
        int i = 0;
        while (i < mavenVersion.length()) {
            char c = mavenVersion.charAt(i);
            if (Character.isDigit(c) || c == '.') {
                b.append(c);
            }
            ++i;
        }
        return new VersionNumber(b.toString());
    }

    public static final class ModuleDependencyImpl
    implements ModuleDependency {
        private static final long serialVersionUID = -6850832632316987487L;
        private String dependencyId;
        private String versionStr;
        private List<Pair<ModuleVersionNumber, ModuleVersionNumber>> versionRanges;

        private ModuleDependencyImpl(String dependencyId, String versionStr) {
            this.dependencyId = dependencyId;
            this.versionStr = versionStr;
            try {
                this.versionRanges = ModuleDependencyImpl.buildVersionRanges(versionStr);
            }
            catch (Throwable e) {
                throw new AlfrescoRuntimeException("Unable to interpret the module version ranges: " + versionStr, e);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.dependencyId).append(":").append(this.versionStr);
            return sb.toString();
        }

        private static List<Pair<ModuleVersionNumber, ModuleVersionNumber>> buildVersionRanges(String versionStr) {
            ArrayList<Pair<ModuleVersionNumber, ModuleVersionNumber>> versionRanges = new ArrayList<Pair<ModuleVersionNumber, ModuleVersionNumber>>(1);
            StringTokenizer rangesTokenizer = new StringTokenizer(versionStr, ",");
            while (rangesTokenizer.hasMoreTokens()) {
                String range = rangesTokenizer.nextToken().trim();
                if (range.equals("*")) {
                    range = "*-*";
                }
                if (range.startsWith("-")) {
                    range = "*" + range;
                }
                if (range.endsWith("-")) {
                    range = String.valueOf(range) + "*";
                }
                StringTokenizer rangeTokenizer = new StringTokenizer(range, "-", false);
                ModuleVersionNumber versionLower = null;
                ModuleVersionNumber versionUpper = null;
                while (rangeTokenizer.hasMoreTokens()) {
                    String version = rangeTokenizer.nextToken();
                    version = version.trim();
                    if (versionLower == null) {
                        if (version.equals("*")) {
                            versionLower = ModuleVersionNumber.VERSION_ZERO;
                            continue;
                        }
                        versionLower = new ModuleVersionNumber(version);
                        continue;
                    }
                    if (versionUpper != null) continue;
                    versionUpper = version.equals("*") ? ModuleVersionNumber.VERSION_BIG : new ModuleVersionNumber(version);
                }
                if (versionUpper == null && versionLower == null) {
                    throw new AlfrescoRuntimeException("Valid dependency version ranges are: \n   LOW  - HIGH \n   *    - HIGH \n   LOW  - *    \n   *       ");
                }
                if (versionUpper == null && versionLower != null) {
                    versionUpper = versionLower;
                } else if (versionLower == null && versionUpper != null) {
                    versionLower = versionUpper;
                }
                Pair<Object, Object> rangePair = new Pair<Object, Object>(versionLower, versionUpper);
                versionRanges.add(rangePair);
            }
            return versionRanges;
        }

        @Override
        public String getDependencyId() {
            return this.dependencyId;
        }

        @Override
        public String getVersionString() {
            return this.versionStr;
        }

        @Override
        public boolean isValidDependency(ModuleDetails moduleDetails) {
            if (moduleDetails == null) {
                return false;
            }
            if (!moduleDetails.getId().equals(this.dependencyId)) {
                return false;
            }
            ModuleVersionNumber checkVersion = moduleDetails.getModuleVersionNumber();
            boolean matched = false;
            for (Pair<ModuleVersionNumber, ModuleVersionNumber> versionRange : this.versionRanges) {
                ModuleVersionNumber versionLower = versionRange.getFirst();
                ModuleVersionNumber versionUpper = versionRange.getSecond();
                if (checkVersion.compareTo(versionLower) < 0 || checkVersion.compareTo(versionUpper) > 0) continue;
                matched = true;
                break;
            }
            return matched;
        }
    }
}

