/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.file;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsAbstractController;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsInputOption;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.FsSyncOption;
import de.schlichtherle.truezip.fs.file.FileEntry;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;

@Immutable
final class FileController
extends FsAbstractController<FsModel> {
    private static final String TWO_SEPARATORS = "//";
    private final File target;

    FileController(FsModel model) {
        super(model);
        if (null != model.getParent()) {
            throw new IllegalArgumentException();
        }
        URI uri = model.getMountPoint().toUri();
        if ('\\' == File.separatorChar && null != uri.getRawAuthority()) {
            try {
                uri = new URI(uri.getScheme(), "", TWO_SEPARATORS + uri.getAuthority() + uri.getPath(), uri.getQuery(), uri.getFragment());
            }
            catch (URISyntaxException ex) {
                throw new AssertionError((Object)ex);
            }
        }
        this.target = new File(uri);
    }

    @Override
    public FsController<?> getParent() {
        return null;
    }

    @Override
    public boolean isReadOnly() throws IOException {
        return false;
    }

    @Override
    public FileEntry getEntry(FsEntryName name) throws IOException {
        FileEntry entry = new FileEntry(this.target, name);
        return entry.getFile().exists() ? entry : null;
    }

    @Override
    public boolean isReadable(FsEntryName name) throws IOException {
        File file = new File(this.target, name.getPath());
        return file.canRead();
    }

    @Override
    public boolean isWritable(FsEntryName name) throws IOException {
        File file = new File(this.target, name.getPath());
        return file.canWrite();
    }

    @Override
    public boolean isExecutable(FsEntryName name) throws IOException {
        File file = new File(this.target, name.getPath());
        return file.canExecute();
    }

    @Override
    public void setReadOnly(FsEntryName name) throws IOException {
        File file = new File(this.target, name.getPath());
        if (!file.setReadOnly()) {
            if (file.exists()) {
                throw new IOException(file + " (access denied)");
            }
            throw new FileNotFoundException(file.toString());
        }
    }

    @Override
    public boolean setTime(FsEntryName name, Map<Entry.Access, Long> times, BitField<FsOutputOption> options) throws IOException {
        File file = new File(this.target, name.getPath());
        boolean ok = true;
        for (Map.Entry<Entry.Access, Long> time : times.entrySet()) {
            ok &= Entry.Access.WRITE == time.getKey() && file.setLastModified(time.getValue());
        }
        return ok;
    }

    @Override
    public boolean setTime(FsEntryName name, BitField<Entry.Access> types, long value, BitField<FsOutputOption> options) throws IOException {
        File file = new File(this.target, name.getPath());
        boolean ok = true;
        for (Entry.Access type : types) {
            ok &= Entry.Access.WRITE == type && file.setLastModified(value);
        }
        return ok;
    }

    @Override
    public InputSocket<?> getInputSocket(FsEntryName name, BitField<FsInputOption> options) {
        return new FileEntry(this.target, name).getInputSocket();
    }

    @Override
    public OutputSocket<?> getOutputSocket(FsEntryName name, BitField<FsOutputOption> options, @CheckForNull Entry template) {
        return new FileEntry(this.target, name).getOutputSocket(options, template);
    }

    @Override
    public void mknod(FsEntryName name, Entry.Type type, BitField<FsOutputOption> options, @CheckForNull Entry template) throws IOException {
        long time;
        File file = new File(this.target, name.getPath());
        switch (type) {
            case FILE: {
                if (options.get(FsOutputOption.EXCLUSIVE)) {
                    if (file.createNewFile()) break;
                    throw new IOException(file + " (file exists already)");
                }
                new FileOutputStream(file).close();
                break;
            }
            case DIRECTORY: {
                if (file.mkdir()) break;
                if (file.exists()) {
                    throw new IOException(file + " (directory exists already)");
                }
                throw new IOException(file.toString());
            }
            default: {
                throw new IOException(file + " (entry type not supported: " + (Object)((Object)type) + ")");
            }
        }
        if (null != template && -1L != (time = template.getTime(Entry.Access.WRITE)) && !file.setLastModified(time)) {
            throw new IOException(file + " (cannot set last modification time)");
        }
    }

    @Override
    public void unlink(FsEntryName name, BitField<FsOutputOption> options) throws IOException {
        File file = new File(this.target, name.getPath());
        if (!file.delete()) {
            throw new IOException(file + " (cannot delete)");
        }
    }

    @Override
    public void sync(BitField<FsSyncOption> options) {
    }
}

