/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.zip;

import de.schlichtherle.truezip.io.SynchronizedInputStream;
import de.schlichtherle.truezip.rof.DefaultReadOnlyFile;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.util.Pool;
import de.schlichtherle.truezip.zip.DefaultZipFileParameters;
import de.schlichtherle.truezip.zip.RawZipFile;
import de.schlichtherle.truezip.zip.ZipCryptoParameters;
import de.schlichtherle.truezip.zip.ZipEntry;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.Iterator;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class ZipFile
extends RawZipFile<ZipEntry> {
    @CheckForNull
    private volatile ZipCryptoParameters cryptoParameters;
    private final String name;

    public ZipFile(String path) throws IOException {
        this(path, DEFAULT_CHARSET, true, false);
    }

    public ZipFile(String path, Charset charset) throws IOException {
        this(path, charset, true, false);
    }

    public ZipFile(String path, Charset charset, boolean preambled, boolean postambled) throws IOException {
        super(new DefaultReadOnlyFilePool(path), new DefaultZipFileParameters(charset, preambled, postambled));
        this.name = path;
    }

    public ZipFile(File file) throws IOException {
        this(file, DEFAULT_CHARSET, true, false);
    }

    public ZipFile(File file, Charset charset) throws IOException {
        this(file, charset, true, false);
    }

    public ZipFile(File file, Charset charset, boolean preambled, boolean postambled) throws IOException {
        super(new DefaultReadOnlyFilePool(file), new DefaultZipFileParameters(charset, preambled, postambled));
        this.name = file.toString();
    }

    public ZipFile(ReadOnlyFile rof) throws IOException {
        this(rof, DEFAULT_CHARSET, true, false);
    }

    public ZipFile(ReadOnlyFile rof, Charset charset) throws IOException {
        this(rof, charset, true, false);
    }

    public ZipFile(ReadOnlyFile rof, Charset charset, boolean preambled, boolean postambled) throws IOException {
        super(rof, new DefaultZipFileParameters(charset, preambled, postambled));
        this.name = rof.toString();
    }

    @Override
    public void recoverLostEntries() throws IOException {
        super.recoverLostEntries();
    }

    public String getName() {
        return this.name;
    }

    public Enumeration<? extends ZipEntry> entries() {
        class CloneEnumeration
        implements Enumeration<ZipEntry> {
            final Iterator<ZipEntry> i;

            CloneEnumeration() {
                this.i = ZipFile.super.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.i.hasNext();
            }

            @Override
            public ZipEntry nextElement() {
                return this.i.next().clone();
            }
        }
        return new CloneEnumeration();
    }

    @Override
    public Iterator<ZipEntry> iterator() {
        class EntryIterator
        implements Iterator<ZipEntry> {
            final Iterator<ZipEntry> i;

            EntryIterator() {
                this.i = ZipFile.super.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.i.hasNext();
            }

            @Override
            public ZipEntry next() {
                return this.i.next().clone();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
        return new EntryIterator();
    }

    @Override
    public ZipEntry getEntry(String name) {
        Object ze = super.getEntry(name);
        return ze != null ? ((ZipEntry)ze).clone() : null;
    }

    @Override
    public synchronized InputStream getPreambleInputStream() throws IOException {
        return new SynchronizedInputStream(super.getPreambleInputStream(), this);
    }

    @Override
    public synchronized InputStream getPostambleInputStream() throws IOException {
        return new SynchronizedInputStream(super.getPostambleInputStream(), this);
    }

    @Override
    public synchronized boolean busy() {
        return super.busy();
    }

    @Override
    @Nullable
    public ZipCryptoParameters getCryptoParameters() {
        return this.cryptoParameters;
    }

    public void setCryptoParameters(@CheckForNull ZipCryptoParameters cryptoParameters) {
        this.cryptoParameters = cryptoParameters;
    }

    @Override
    protected synchronized InputStream getInputStream(String name, Boolean check, boolean process) throws IOException {
        InputStream in = super.getInputStream(name, check, process);
        return in == null ? null : new SynchronizedInputStream(in, this);
    }

    @Override
    public synchronized void close() throws IOException {
        super.close();
    }

    private static final class DefaultReadOnlyFilePool
    implements Pool<ReadOnlyFile, IOException> {
        final File file;

        DefaultReadOnlyFilePool(String name) {
            this(new File(name));
        }

        DefaultReadOnlyFilePool(File file) {
            this.file = file;
        }

        @Override
        public ReadOnlyFile allocate() throws IOException {
            return new DefaultReadOnlyFile(this.file);
        }

        @Override
        public void release(ReadOnlyFile rof) throws IOException {
            rof.close();
        }
    }
}

