/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.module.tool;

import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileOutputStream;
import de.schlichtherle.truezip.file.TFileReader;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.module.tool.ModuleManagementToolException;

public class InstalledFiles {
    private static final String MOD_ADD_FILE = "add";
    private static final String MOD_UPDATE_FILE = "update";
    private static final String MOD_MK_DIR = "mkdir";
    private static final String DELIMITER = "|";
    private String warLocation;
    private String moduleId;
    private List<String> adds = new ArrayList<String>();
    private Map<String, String> updates = new HashMap<String, String>();
    private List<String> mkdirs = new ArrayList<String>();

    public InstalledFiles(String warLocation, String moduleId) {
        this.warLocation = warLocation;
        this.moduleId = moduleId;
    }

    public void load() {
        block13: {
            TFile file = new TFile(this.getFileLocation());
            if (file.exists()) {
                try (BufferedReader reader = new BufferedReader(new TFileReader(file));){
                    String line = reader.readLine();
                    while (line != null) {
                        String[] modification = line.split("\\|");
                        String mod = modification[0];
                        String location = modification[1];
                        if (mod.equals(MOD_ADD_FILE)) {
                            this.adds.add(location);
                        } else if (mod.equals(MOD_MK_DIR)) {
                            this.mkdirs.add(location);
                        } else if (mod.equals(MOD_UPDATE_FILE)) {
                            this.updates.put(location, modification[2]);
                        }
                        line = reader.readLine();
                    }
                    break block13;
                }
                catch (FileNotFoundException exception) {
                    throw new ModuleManagementToolException("The module file install file '" + this.getFileLocation() + "' does not exist", exception);
                }
                catch (IOException exception) {
                    throw new ModuleManagementToolException("Error whilst reading file '" + this.getFileLocation(), exception);
                }
            }
            throw new ModuleManagementToolException("Invalid module.  The installation file does not exist for module: " + this.moduleId);
        }
    }

    public void save() {
        try {
            TFile file = new TFile(this.getFileLocation());
            if (!file.exists()) {
                file.createNewFile();
            }
            try (TFileOutputStream os = new TFileOutputStream(file);){
                String output;
                for (String string : this.adds) {
                    output = "add|" + string + "\n";
                    os.write(output.getBytes());
                }
                for (Map.Entry entry : this.updates.entrySet()) {
                    output = "update|" + (String)entry.getKey() + DELIMITER + (String)entry.getValue() + "\n";
                    os.write(output.getBytes());
                }
                for (String string : this.mkdirs) {
                    output = "mkdir|" + string + "\n";
                    os.write(output.getBytes());
                }
            }
        }
        catch (IOException exception) {
            throw new ModuleManagementToolException("Error whilst saving modifications file.", exception);
        }
    }

    public String getFileLocation() {
        return String.valueOf(this.warLocation) + this.getFilePathInWar();
    }

    public String getFilePathInWar() {
        return "/WEB-INF/classes/alfresco/module/" + this.moduleId + "/modifications.install";
    }

    public List<String> getAdds() {
        return this.adds;
    }

    public Map<String, String> getUpdates() {
        return this.updates;
    }

    public List<String> getMkdirs() {
        return this.mkdirs;
    }

    public void addAdd(String location) {
        this.adds.add(location);
    }

    public void addUpdate(String location, String backup) {
        this.updates.put(location, backup);
    }

    public void addMkdir(String location) {
        this.mkdirs.add(location);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("InstalledFiles [warLocation=").append(this.warLocation).append(", moduleId=").append(this.moduleId).append(", adds=").append(this.adds).append(", updates=").append(this.updates).append(", mkdirs=").append(this.mkdirs).append("]");
        return builder.toString();
    }
}

