/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webeditor.taglib;

import java.io.IOException;
import java.io.Writer;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webeditor.taglib.AbstractTemplateTag;

public class EndTemplateTag
extends AbstractTemplateTag {
    private static final long serialVersionUID = -2917015141188997203L;
    protected static final Log logger = LogFactory.getLog(EndTemplateTag.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int doStartTag() throws JspException {
        if (this.isEditingEnabled()) {
            try {
                JspWriter out = this.pageContext.getOut();
                String toolbarLocation = this.getToolbarLocation();
                out.write("<script type=\"text/javascript\">\n");
                out.write("WEF.ConfigRegistry.registerConfig('org.springframework.extensions.webeditor.ui.ribbon',\n");
                out.write("{ position: \"");
                out.write(toolbarLocation);
                out.write("\" });\n");
                this.includeCustomConfiguration((Writer)out);
                out.write("\n</script>");
                out.write("<script type=\"text/javascript\" src=\"");
                out.write(this.getWebEditorUrlPrefix());
                out.write("/service/wef/resources\"></script>\n");
                if (!logger.isDebugEnabled()) return 0;
                logger.debug((Object)"Completed endTemplate rendering");
                return 0;
            }
            catch (IOException ioe) {
                throw new JspException(ioe.toString());
            }
        } else {
            if (!logger.isDebugEnabled()) return 0;
            logger.debug((Object)"Skipping endTemplate rendering as editing is disabled");
        }
        return 0;
    }

    public void includeCustomConfiguration(Writer out) throws IOException {
    }

    @Override
    public void release() {
        super.release();
    }
}

