/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.scripts;

import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import java.util.Map;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.extensions.surf.util.StringBuilderWriter;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;
import org.springframework.extensions.webscripts.json.JSONWriter;

public class MessagesWebScript
extends org.springframework.extensions.webscripts.MessagesWebScript {
    protected String generateMessages(WebScriptRequest req, WebScriptResponse res, String locale) throws IOException {
        StringBuilderWriter writer = new StringBuilderWriter(8192);
        writer.write("if (typeof Alfresco == \"undefined\" || !Alfresco) {var Alfresco = {};}\r\n");
        writer.write("Alfresco.messages = Alfresco.messages || {global: null, scope: {}}\r\n");
        writer.write("Alfresco.messages.global = ");
        JSONWriter out = new JSONWriter((Writer)writer);
        try {
            out.startObject();
            Map messages = I18NUtil.getAllMessages((Locale)I18NUtil.parseLocale((String)locale));
            for (Map.Entry entry : messages.entrySet()) {
                out.writeValue((String)entry.getKey(), (String)entry.getValue());
            }
            out.endObject();
        }
        catch (IOException jsonErr) {
            throw new WebScriptException("Error building messages response.", (Throwable)jsonErr);
        }
        writer.write(";\r\n//Make global for sandbox mode\r\nwindow.Alfresco=Alfresco;\r\n");
        return writer.toString();
    }
}

