/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.module.tool;

import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import de.schlichtherle.truezip.file.TFileOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.alfresco.repo.module.ModuleDetailsImpl;
import org.alfresco.repo.module.tool.LogOutput;
import org.alfresco.repo.module.tool.ModuleManagementToolException;
import org.alfresco.service.cmr.module.ModuleDetails;

public class ModuleDetailsHelper {
    public static ModuleDetails createModuleDetailsFromPropertiesStream(InputStream is) throws IOException {
        return ModuleDetailsHelper.createModuleDetailsFromPropertiesStream(is, null);
    }

    public static ModuleDetails createModuleDetailsFromPropertiesStream(InputStream is, LogOutput log) throws IOException {
        ModuleDetailsImpl moduleDetailsImpl;
        try {
            Properties properties = new Properties();
            properties.load(is);
            moduleDetailsImpl = new ModuleDetailsImpl(properties, log);
        }
        catch (Throwable throwable) {
            try {
                is.close();
            }
            catch (Throwable throwable2) {}
            throw throwable;
        }
        try {
            is.close();
        }
        catch (Throwable throwable) {}
        return moduleDetailsImpl;
    }

    public static ModuleDetails createModuleDetailsFromPropertyLocation(String location) throws IOException {
        return ModuleDetailsHelper.createModuleDetailsFromPropertyLocation(location, null);
    }

    public static ModuleDetails createModuleDetailsFromPropertyLocation(String location, LogOutput log) throws IOException {
        TFileInputStream is;
        ModuleDetails result = null;
        try {
            is = new TFileInputStream(location);
        }
        catch (FileNotFoundException error) {
            error.printStackTrace(System.out);
            throw new ModuleManagementToolException("Unable to load module details from property file. File Not Found, " + error.getMessage(), error);
        }
        try {
            try {
                result = ModuleDetailsHelper.createModuleDetailsFromPropertiesStream(is, log);
            }
            catch (IOException exception) {
                throw new ModuleManagementToolException("Unable to load module details from property file." + exception.getMessage(), exception);
            }
        }
        finally {
            is.close();
        }
        return result;
    }

    public static ModuleDetails createModuleDetailsFromWarAndId(String warLocation, String moduleId) throws IOException {
        String modulePropertiesFileLocation = ModuleDetailsHelper.getModulePropertiesFileLocation(warLocation, moduleId);
        return ModuleDetailsHelper.createModuleDetailsFromPropertyLocation(modulePropertiesFileLocation);
    }

    public static TFile getModuleDetailsFileFromWarAndId(String warLocation, String moduleId) {
        String location = ModuleDetailsHelper.getModulePropertiesFileLocation(warLocation, moduleId);
        TFile file = new TFile(location);
        return file;
    }

    public static String getModulePropertiesFileLocation(String warLocation, String moduleId) {
        return String.valueOf(warLocation) + ModuleDetailsHelper.getModulePropertiesFilePathInWar(moduleId);
    }

    public static String getModulePropertiesFilePathInWar(String moduleId) {
        return "/WEB-INF/classes/alfresco/module/" + moduleId + "/module.properties";
    }

    public static void saveModuleDetails(String warLocation, ModuleDetails moduleDetails) {
        String moduleId = moduleDetails.getId();
        try {
            String modulePropertiesFileLocation = ModuleDetailsHelper.getModulePropertiesFileLocation(warLocation, moduleId);
            TFile file = new TFile(modulePropertiesFileLocation);
            if (!file.exists()) {
                file.createNewFile();
            }
            Properties moduleProperties = moduleDetails.getProperties();
            try (TFileOutputStream os = new TFileOutputStream(file);){
                moduleProperties.store(os, null);
            }
        }
        catch (IOException exception) {
            throw new ModuleManagementToolException("Unable to save module details into WAR file: \n   Module: " + moduleDetails.getId() + "\n" + "   Properties: " + moduleDetails.getProperties(), exception);
        }
    }
}

