/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.util;

import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class I18NUtil {
    private static ThreadLocal<Locale> threadLocale = new ThreadLocal();
    private static ThreadLocal<Locale> threadContentLocale = new ThreadLocal();
    private static ThreadLocal<Locale> threadContentLocaleLang = new ThreadLocal();
    private static Set<String> resouceBundleBaseNames = new LinkedHashSet<String>();
    private static Map<Locale, Set<String>> loadedResourceBundles = new HashMap<Locale, Set<String>>();
    private static Map<Locale, Map<String, String>> cachedMessages = new HashMap<Locale, Map<String, String>>();
    private static ReadWriteLock lock = new ReentrantReadWriteLock();
    private static Lock readLock = lock.readLock();
    private static Lock writeLock = lock.writeLock();

    public static void setLocale(Locale locale) {
        threadLocale.set(locale);
        threadContentLocaleLang.set(null);
    }

    public static Locale getLocale() {
        Locale locale = threadLocale.get();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    public static Locale getLocaleOrNull() {
        return threadLocale.get();
    }

    public static void setContentLocale(Locale locale) {
        threadContentLocale.set(locale);
        threadContentLocaleLang.set(null);
    }

    public static Locale getContentLocale() {
        Locale locale = threadContentLocale.get();
        if (locale == null) {
            locale = I18NUtil.getLocale();
        }
        return locale;
    }

    public static Locale getContentLocaleLang() {
        Locale locale = threadContentLocaleLang.get();
        if (locale == null) {
            locale = threadContentLocale.get() != null ? new Locale(threadContentLocale.get().getLanguage()) : new Locale(I18NUtil.getLocale().getLanguage());
            threadContentLocaleLang.set(locale);
        }
        return locale;
    }

    public static Locale getContentLocaleOrNull() {
        return threadContentLocale.get();
    }

    public static Locale getNearestLocale(Locale templateLocale, Set<Locale> options) {
        if (options.isEmpty()) {
            return null;
        }
        if (templateLocale == null) {
            Iterator<Locale> i$ = options.iterator();
            if (i$.hasNext()) {
                Locale locale = i$.next();
                return locale;
            }
        } else if (options.contains(templateLocale)) {
            return templateLocale;
        }
        HashSet<Locale> remaining = new HashSet<Locale>(options);
        Locale lastMatchingOption = null;
        String templateLanguage = templateLocale.getLanguage();
        if (templateLanguage != null && !templateLanguage.equals("")) {
            Iterator iterator = remaining.iterator();
            while (iterator.hasNext()) {
                Locale option = (Locale)iterator.next();
                if (option != null && !templateLanguage.equals(option.getLanguage())) {
                    iterator.remove();
                    continue;
                }
                lastMatchingOption = option;
            }
        }
        if (remaining.isEmpty()) {
            return null;
        }
        if (remaining.size() == 1 && lastMatchingOption != null) {
            return lastMatchingOption;
        }
        lastMatchingOption = null;
        String templateCountry = templateLocale.getCountry();
        if (templateCountry != null && !templateCountry.equals("")) {
            for (Locale option : remaining) {
                if (option != null && !templateCountry.equals(option.getCountry())) continue;
                lastMatchingOption = option;
            }
        }
        if (remaining.size() == 1 && lastMatchingOption != null) {
            return lastMatchingOption;
        }
        if (lastMatchingOption != null) {
            return lastMatchingOption;
        }
        Iterator i$ = remaining.iterator();
        if (i$.hasNext()) {
            Locale locale = (Locale)i$.next();
            return locale;
        }
        throw new RuntimeException("Logic should not allow code to get here.");
    }

    public static Locale parseLocale(String localeStr) {
        if (localeStr == null) {
            return null;
        }
        Locale locale = Locale.getDefault();
        StringTokenizer t = new StringTokenizer(localeStr.toLowerCase(), "_-");
        int tokens = t.countTokens();
        if (tokens == 1) {
            locale = new Locale(t.nextToken());
        } else if (tokens == 2) {
            locale = new Locale(t.nextToken(), t.nextToken());
        } else if (tokens == 3) {
            locale = new Locale(t.nextToken(), t.nextToken(), t.nextToken());
        }
        return locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerResourceBundle(String bundleBaseName) {
        try {
            writeLock.lock();
            resouceBundleBaseNames.add(bundleBaseName);
        }
        finally {
            writeLock.unlock();
        }
    }

    public static String getMessage(String messageKey) {
        return I18NUtil.getMessage(messageKey, I18NUtil.getLocale());
    }

    public static String getMessage(String messageKey, Locale locale) {
        String message = null;
        Map<String, String> props = I18NUtil.getLocaleProperties(locale);
        if (props != null) {
            message = props.get(messageKey);
        }
        return message;
    }

    public static String getMessage(String messageKey, Object ... params) {
        return I18NUtil.getMessage(messageKey, I18NUtil.getLocale(), params);
    }

    public static String getMessage(String messageKey, Locale locale, Object ... params) {
        String message = I18NUtil.getMessage(messageKey, locale);
        if (message != null && params != null) {
            message = MessageFormat.format(message, params);
        }
        return message;
    }

    public static Map<String, String> getAllMessages() {
        return I18NUtil.getLocaleProperties(I18NUtil.getLocale());
    }

    public static Map<String, String> getAllMessages(Locale locale) {
        return I18NUtil.getLocaleProperties(locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> getLocaleProperties(Locale locale) {
        Set<String> loadedBundles = null;
        Map<String, String> props = null;
        int loadedBundleCount = 0;
        try {
            readLock.lock();
            loadedBundles = loadedResourceBundles.get(locale);
            props = cachedMessages.get(locale);
            loadedBundleCount = resouceBundleBaseNames.size();
        }
        finally {
            readLock.unlock();
        }
        if (loadedBundles == null) {
            try {
                writeLock.lock();
                loadedBundles = new HashSet<String>();
                loadedResourceBundles.put(locale, loadedBundles);
            }
            finally {
                writeLock.unlock();
            }
        }
        if (props == null) {
            try {
                writeLock.lock();
                props = new HashMap<String, String>();
                cachedMessages.put(locale, props);
            }
            finally {
                writeLock.unlock();
            }
        }
        if (loadedBundles.size() != loadedBundleCount) {
            try {
                writeLock.lock();
                for (String resourceBundleBaseName : resouceBundleBaseNames) {
                    if (loadedBundles.contains(resourceBundleBaseName)) continue;
                    ResourceBundle resourcebundle = ResourceBundle.getBundle(resourceBundleBaseName, locale);
                    Enumeration<String> enumKeys = resourcebundle.getKeys();
                    while (enumKeys.hasMoreElements()) {
                        String key = enumKeys.nextElement();
                        props.put(key, resourcebundle.getString(key));
                    }
                    loadedBundles.add(resourceBundleBaseName);
                }
            }
            finally {
                writeLock.unlock();
            }
        }
        return props;
    }
}

