/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.module.tool;

import de.schlichtherle.truezip.file.TArchiveDetector;
import de.schlichtherle.truezip.file.TConfig;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import de.schlichtherle.truezip.file.TVFS;
import de.schlichtherle.truezip.fs.archive.zip.ZipDriver;
import de.schlichtherle.truezip.socket.sl.IOPoolLocator;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.module.tool.InstalledFiles;
import org.alfresco.repo.module.tool.LogOutput;
import org.alfresco.repo.module.tool.ModuleDetailsHelper;
import org.alfresco.repo.module.tool.ModuleManagementToolException;
import org.alfresco.repo.module.tool.WarHelper;
import org.alfresco.repo.module.tool.WarHelperImpl;
import org.alfresco.service.cmr.module.ModuleDetails;
import org.alfresco.service.cmr.module.ModuleInstallState;
import org.alfresco.util.VersionNumber;
import org.safehaus.uuid.UUIDGenerator;

public class ModuleManagementTool
implements LogOutput {
    private static final String DEFAULT_FILE_MAPPING_PROPERTIES = "org/alfresco/repo/module/tool/default-file-mapping.properties";
    private static final String FILE_MAPPING_PROPERTIES = "file-mapping.properties";
    private static final String PROP_INHERIT_DEFAULT = "include.default";
    public static final String BACKUP_DIR = "/WEB-INF/classes/alfresco/module/backup";
    private static final String OP_INSTALL = "install";
    private static final String OP_UNINSTALL = "uninstall";
    private static final String OP_LIST = "list";
    private static final String OPTION_VERBOSE = "-verbose";
    private static final String OPTION_FORCE = "-force";
    private static final String OPTION_PREVIEW = "-preview";
    private static final String OPTION_NOBACKUP = "-nobackup";
    private static final String OPTION_DIRECTORY = "-directory";
    private static final String OPTION_PURGE = "-purge";
    private static final String OPTION_HELP = "-help";
    private static final int ERROR_EXIT_CODE = 1;
    private static final int SUCCESS_EXIT_CODE = 0;
    private Properties defaultFileMappingProperties;
    private boolean verbose = false;
    WarHelper warHelper = new WarHelperImpl(this);

    public ModuleManagementTool() {
        TConfig config = TConfig.get();
        config.setArchiveDetector(new TArchiveDetector("war|amp", new ZipDriver(IOPoolLocator.SINGLETON)));
        this.defaultFileMappingProperties = new Properties();
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(DEFAULT_FILE_MAPPING_PROPERTIES);
        try {
            this.defaultFileMappingProperties.load(is);
        }
        catch (IOException exception) {
            throw new ModuleManagementToolException("Unable to load default extension file mapping properties.", exception);
        }
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void installModules(String directory, String warFileLocation) throws IOException {
        this.installModules(directory, warFileLocation, false, false, true);
    }

    public void installModules(String directoryLocation, String warFileLocation, boolean preview, boolean forceInstall, boolean backupWAR) throws IOException {
        File dir = new File(directoryLocation);
        if (dir.exists()) {
            if (backupWAR) {
                this.backupWar(new TFile(warFileLocation), true);
                backupWAR = false;
            }
        } else {
            throw new ModuleManagementToolException("Invalid directory '" + directoryLocation + "'");
        }
        this.installModules(dir, warFileLocation, preview, forceInstall, backupWAR);
    }

    private void installModules(File dir, String warFileLocation, boolean preview, boolean forceInstall, boolean backupWAR) {
        File[] children = dir.listFiles();
        if (children != null) {
            for (File child : children) {
                if (child.isFile() && child.getName().toLowerCase().endsWith(".amp")) {
                    this.installModule(child.getPath(), warFileLocation, preview, forceInstall, backupWAR);
                    continue;
                }
                this.installModules(child, warFileLocation, preview, forceInstall, backupWAR);
            }
        }
    }

    public void installModule(String ampFileLocation, String warFileLocation) {
        this.installModule(ampFileLocation, warFileLocation, false, false, true);
    }

    public void installModule(String ampFileLocation, String warFileLocation, boolean preview, boolean forceInstall, boolean backupWAR) {
        try {
            String propertiesLocation;
            ModuleDetails installingModuleDetails;
            this.outputVerboseMessage("Installing AMP '" + ampFileLocation + "' into WAR '" + warFileLocation + "'");
            TFile warFile = new TFile(warFileLocation);
            if (!warFile.exists()) {
                throw new ModuleManagementToolException("The war file '" + warFile + "' does not exist.");
            }
            if (!preview) {
                TFile moduleDir = new TFile(warFileLocation + "/WEB-INF/classes/alfresco/module");
                if (!moduleDir.exists()) {
                    moduleDir.mkdir();
                }
                this.backupWar(warFile, backupWAR);
            }
            if ((installingModuleDetails = ModuleDetailsHelper.createModuleDetailsFromPropertyLocation(propertiesLocation = ampFileLocation + "/module.properties")) == null) {
                throw new ModuleManagementToolException("No module.properties file has been found in the installing .amp file '" + ampFileLocation + "'");
            }
            String installingId = installingModuleDetails.getId();
            VersionNumber installingVersion = installingModuleDetails.getVersion();
            this.warHelper.checkCompatibleVersion(warFile, installingModuleDetails);
            this.warHelper.checkCompatibleEdition(warFile, installingModuleDetails);
            this.warHelper.checkModuleDependencies(warFile, installingModuleDetails);
            ModuleDetails installedModuleDetails = this.warHelper.getModuleDetailsOrAlias(warFile, installingModuleDetails);
            TFile moduleInstallDirectory = new TFile(warFileLocation + "/WEB-INF/classes/alfresco/module" + "/" + installingId);
            if (!preview && !moduleInstallDirectory.exists()) {
                moduleInstallDirectory.mkdir();
            }
            this.uninstallIfNecessary(warFileLocation, installedModuleDetails, preview, forceInstall, installingVersion);
            this.outputVerboseMessage("Adding files relating to version '" + installingVersion + "' of module '" + installingId + "'");
            InstalledFiles installedFiles = new InstalledFiles(warFileLocation, installingId);
            Properties directoryChanges = this.calculateChanges(ampFileLocation, warFileLocation, preview, forceInstall, installedFiles);
            if (!preview) {
                if (directoryChanges != null && directoryChanges.size() > 0) {
                    for (Map.Entry<Object, Object> entry : directoryChanges.entrySet()) {
                        TFile source = new TFile((String)entry.getKey());
                        TFile destination = new TFile((String)entry.getValue());
                        source.cp_rp(destination);
                    }
                }
                installedFiles.save();
                installingModuleDetails.setInstallState(ModuleInstallState.INSTALLED);
                installingModuleDetails.setInstallDate(new Date());
                ModuleDetailsHelper.saveModuleDetails(warFileLocation, installingModuleDetails);
                if (warFile.exists()) {
                    warFile.setLastModified(System.currentTimeMillis());
                }
                TVFS.umount();
            }
        }
        catch (IOException exception) {
            throw new ModuleManagementToolException("An IO error was encountered during deployment of the AMP into the WAR", exception);
        }
    }

    private void uninstallIfNecessary(String warFileLocation, ModuleDetails installedModuleDetails, boolean preview, boolean forceInstall, VersionNumber installingVersion) throws IOException {
        if (installedModuleDetails != null) {
            String installedId = installedModuleDetails.getId();
            VersionNumber installedVersion = installedModuleDetails.getVersion();
            int compareValue = installedVersion.compareTo(installingVersion);
            if (compareValue > 0) {
                this.outputVerboseMessage("WARNING: A later version of this module is already installed in the WAR. Installation skipped.  You could force the installation by passing the -force option.", false);
                return;
            }
            if (forceInstall) {
                this.outputVerboseMessage("WARNING: The installation of this module is being forced.  All files will be removed and replaced regardless of exiting versions present.", false);
            }
            if (compareValue == 0) {
                this.outputVerboseMessage("WARNING: This version of this module is already installed in the WAR..upgrading.", false);
            }
            if (forceInstall || compareValue <= 0) {
                this.outputVerboseMessage("Clearing out files relating to version '" + installedVersion + "' of module '" + installedId + "'", false);
                this.uninstallModule(installedId, warFileLocation, preview, true);
            }
        }
    }

    private Properties calculateChanges(String ampFileLocation, String warFileLocation, boolean preview, boolean forceInstall, InstalledFiles installedFiles) throws IOException {
        Properties dirChanges = new Properties();
        Properties fileMappingProperties = null;
        Properties customFileMappingProperties = this.getCustomFileMappings(ampFileLocation);
        if (customFileMappingProperties == null) {
            fileMappingProperties = this.defaultFileMappingProperties;
        } else {
            fileMappingProperties = new Properties();
            String inheritDefaultStr = customFileMappingProperties.getProperty(PROP_INHERIT_DEFAULT, "true");
            if (inheritDefaultStr.equalsIgnoreCase("true")) {
                fileMappingProperties.putAll((Map<?, ?>)this.defaultFileMappingProperties);
            }
            fileMappingProperties.putAll((Map<?, ?>)customFileMappingProperties);
            fileMappingProperties.remove(PROP_INHERIT_DEFAULT);
        }
        for (Map.Entry<Object, Object> entry : fileMappingProperties.entrySet()) {
            String mappingSource = (String)entry.getKey();
            if (mappingSource.length() == 0 || !mappingSource.startsWith("/")) {
                throw new AlfrescoRuntimeException("File mapping sources must start with '/', but was: " + mappingSource);
            }
            String mappingTarget = (String)entry.getValue();
            if (mappingTarget.length() == 0 || !mappingTarget.startsWith("/")) {
                throw new AlfrescoRuntimeException("File mapping targets must start with '/' but was '" + mappingTarget + "'");
            }
            mappingSource = mappingSource.trim();
            mappingTarget = mappingTarget.trim();
            this.calculateCopyToWar(ampFileLocation, warFileLocation, mappingSource, mappingTarget, installedFiles, preview, forceInstall);
            TFile source = new TFile(ampFileLocation + "/" + mappingSource);
            if (source == null || source.list() == null) continue;
            String sourceDir = ampFileLocation + mappingSource;
            String destinationDir = warFileLocation + mappingTarget;
            dirChanges.put(sourceDir, destinationDir);
        }
        return dirChanges;
    }

    private void backupWar(TFile warFile, boolean backupWAR) throws IOException {
        if (backupWAR) {
            String backupLocation = warFile.getAbsolutePath() + "-" + System.currentTimeMillis() + ".bak";
            if (warFile.isArchive()) {
                this.outputVerboseMessage("Backing up WAR file...");
                TFile source = new TFile(warFile.getAbsolutePath(), TArchiveDetector.NULL);
                TFile backup = new TFile(backupLocation, TArchiveDetector.NULL);
                source.cp_rp(backup);
            } else {
                this.outputVerboseMessage("Backing up war DIRECTORY...");
                TFile backup = new TFile(backupLocation);
                warFile.cp_rp(backup);
            }
            this.outputVerboseMessage("WAR has been backed up to '" + backupLocation + "'");
        }
    }

    private Properties getCustomFileMappings(String ampFileLocation) {
        TFile file = new TFile(ampFileLocation + "/" + FILE_MAPPING_PROPERTIES);
        if (!file.exists()) {
            return null;
        }
        Properties mappingProperties = new Properties();
        InputStream is = null;
        try {
            is = new BufferedInputStream(new TFileInputStream(file));
            mappingProperties.load(is);
        }
        catch (IOException exception) {
            throw new ModuleManagementToolException("Unable to load default extension file mapping properties.", exception);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Throwable e) {}
            }
        }
        return mappingProperties;
    }

    public void uninstallModule(String moduleId, String warFileLocation, boolean preview, boolean purge) throws IOException {
        InstalledFiles installedFiles = new InstalledFiles(warFileLocation, moduleId);
        installedFiles.load();
        for (String string : installedFiles.getAdds()) {
            this.removeFile(warFileLocation, string, preview);
        }
        for (String string : installedFiles.getMkdirs()) {
            this.removeFile(warFileLocation, string, preview);
        }
        for (Map.Entry entry : installedFiles.getUpdates().entrySet()) {
            if (!preview) {
                TFile modified = new TFile(warFileLocation + (String)entry.getKey());
                TFile backup = new TFile(warFileLocation + (String)entry.getValue());
                backup.cp_rp(modified);
                backup.rm();
            }
            this.outputVerboseMessage("Recovering file '" + (String)entry.getKey() + "' from backup '" + (String)entry.getValue() + "'", true);
        }
        String installedFilesPathInWar = installedFiles.getFilePathInWar();
        this.removeFile(warFileLocation, installedFilesPathInWar, preview);
        String string = ModuleDetailsHelper.getModulePropertiesFilePathInWar(moduleId);
        this.removeFile(warFileLocation, string, preview);
    }

    private void removeFile(String warLocation, String filePath, boolean preview) {
        TFile removeFile = new TFile(warLocation + filePath);
        if (removeFile.exists()) {
            this.outputVerboseMessage("Removing file '" + filePath + "' from war", true);
            if (!preview) {
                removeFile.delete();
            }
        } else {
            this.outputVerboseMessage("The file '" + filePath + "' was expected for removal but was not present in the war", true);
        }
    }

    private void calculateCopyToWar(String ampFileLocation, String warFileLocation, String sourceDir, String destinationDir, InstalledFiles installedFiles, boolean preview, boolean forceInstall) throws IOException {
        String sourceLocation;
        TFile ampConfig;
        TFile[] files;
        if (sourceDir.length() == 0 || !sourceDir.startsWith("/")) {
            throw new IllegalArgumentException("sourceDir must start with '/'");
        }
        if (destinationDir.length() == 0 || !destinationDir.startsWith("/")) {
            throw new IllegalArgumentException("destinationDir must start with '/'");
        }
        if (sourceDir.equals("/")) {
            sourceDir = "";
        }
        if (destinationDir.equals("/")) {
            destinationDir = "";
        }
        if ((files = (ampConfig = new TFile(sourceLocation = ampFileLocation + sourceDir)).listFiles()) != null) {
            for (TFile sourceChild : files) {
                String destinationFileLocation = warFileLocation + destinationDir + "/" + ((File)sourceChild).getName();
                TFile destinationChild = new TFile(destinationFileLocation);
                if (((File)sourceChild).isFile()) {
                    String backupLocation = null;
                    boolean createFile = false;
                    if (!destinationChild.exists()) {
                        createFile = true;
                    } else if (forceInstall) {
                        backupLocation = "/WEB-INF/classes/alfresco/module/backup/" + ModuleManagementTool.generateGuid() + ".bin";
                        if (!preview) {
                            TFile backupLocationDirectory = new TFile(warFileLocation + BACKUP_DIR);
                            if (!backupLocationDirectory.exists()) {
                                backupLocationDirectory.mkdir();
                            }
                            TFile backupFile = new TFile(warFileLocation + backupLocation);
                            destinationChild.cp_rp(backupFile);
                        }
                    } else {
                        throw new ModuleManagementToolException("ERROR: The amp will overwrite an existing file in the war '" + destinationDir + "/" + ((File)sourceChild).getName() + "'. Execution halted.  By specifying -force , you can force installation of AMP regardless of the current war state.");
                    }
                    if (createFile) {
                        installedFiles.addAdd(destinationDir + "/" + ((File)sourceChild).getName());
                        this.outputVerboseMessage("File '" + destinationDir + "/" + ((File)sourceChild).getName() + "' added to war from amp", true);
                        continue;
                    }
                    installedFiles.addUpdate(destinationDir + "/" + ((File)sourceChild).getName(), backupLocation);
                    this.outputMessage("WARNING: The file '" + destinationDir + "/" + ((File)sourceChild).getName() + "' is being overwritten by this module. The original has been backed-up to '" + backupLocation + "'", true);
                    continue;
                }
                boolean mkdir = false;
                if (!destinationChild.exists()) {
                    mkdir = true;
                }
                this.calculateCopyToWar(ampFileLocation, warFileLocation, sourceDir + "/" + ((File)sourceChild).getName(), destinationDir + "/" + ((File)sourceChild).getName(), installedFiles, preview, forceInstall);
                if (!mkdir) continue;
                installedFiles.addMkdir(destinationDir + "/" + ((File)sourceChild).getName());
                this.outputVerboseMessage("Directory '" + destinationDir + "/" + ((File)sourceChild).getName() + "' added to war", true);
            }
        }
    }

    public void disableModule(String moduleId, String warLocation) {
        throw new UnsupportedOperationException("Disable module is not currently supported");
    }

    public void enableModule(String moduleId, String warLocation) {
        throw new UnsupportedOperationException("Enable module is not currently supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listModules(String warLocation) {
        ModuleDetails moduleDetails = null;
        boolean previous = this.verbose;
        this.verbose = true;
        boolean moduleFound = false;
        try {
            TFile[] dirs;
            TFile moduleDir = new TFile(warLocation + "/WEB-INF/classes/alfresco/module");
            if (!moduleDir.exists()) {
                this.outputVerboseMessage("No modules are installed in this WAR file");
            }
            if ((dirs = moduleDir.listFiles()) != null && dirs.length != 0) {
                for (TFile dir : dirs) {
                    TFile moduleProperties;
                    if (!((File)dir).isDirectory() || !(moduleProperties = new TFile(((File)dir).getPath() + "/module.properties")).exists()) continue;
                    TFileInputStream is = null;
                    try {
                        moduleFound = true;
                        is = new TFileInputStream(moduleProperties);
                        moduleDetails = ModuleDetailsHelper.createModuleDetailsFromPropertiesStream(is);
                    }
                    catch (IOException exception) {
                        throw new ModuleManagementToolException("Unable to open module properties file '" + moduleProperties.getPath() + "'", exception);
                    }
                    finally {
                        if (is != null) {
                            try {
                                ((InputStream)is).close();
                            }
                            catch (Throwable e) {}
                        }
                    }
                    this.outputVerboseMessage("Module '" + moduleDetails.getId() + "' installed in '" + warLocation + "'");
                    this.outputVerboseMessage("   Title:        " + moduleDetails.getTitle(), true);
                    this.outputVerboseMessage("   Version:      " + moduleDetails.getVersion(), true);
                    this.outputVerboseMessage("   Install Date: " + moduleDetails.getInstallDate(), true);
                    this.outputVerboseMessage("   Description:   " + moduleDetails.getDescription(), true);
                }
            } else {
                this.outputVerboseMessage("No modules are installed in this WAR file");
            }
            if (!moduleFound) {
                this.outputVerboseMessage("No modules were found in this WAR file");
            }
        }
        finally {
            this.verbose = previous;
        }
    }

    private void outputVerboseMessage(String message) {
        this.outputMessage(message, false, false, false);
    }

    private void outputErrorMessage(String message) {
        this.outputMessage(message, false, true, false);
    }

    private void outputVerboseMessage(String message, boolean indent) {
        this.outputMessage(message, indent, false, false);
    }

    private void outputMessage(String message, boolean indent) {
        this.outputMessage(message, indent, false, true);
    }

    private void outputMessage(String message, boolean indent, boolean error, boolean stdout) {
        if (indent) {
            message = "   - " + message;
        }
        if (error) {
            System.err.println(message);
        } else if (this.verbose || stdout) {
            System.out.println(message);
        }
    }

    public static void main(String[] args) {
        block25: {
            if (args.length <= 1) {
                ModuleManagementTool.outputUsage();
                System.exit(1);
            }
            ModuleManagementTool manager = new ModuleManagementTool();
            String operation = args[0];
            try {
                if (operation.equals(OPTION_HELP)) {
                    ModuleManagementTool.outputUsage();
                    System.exit(0);
                    break block25;
                }
                if (operation.equals(OP_INSTALL)) {
                    if (args.length < 3) {
                        throw new UsageException("install requires at least 3 arguments.");
                    }
                    String aepFileLocation = args[1];
                    String warFileLocation = args[2];
                    boolean forceInstall = false;
                    boolean previewInstall = false;
                    boolean backup = true;
                    boolean directory = false;
                    if (args.length > 3) {
                        for (int i = 3; i < args.length; ++i) {
                            String option = args[i];
                            if (OPTION_VERBOSE.equals(option)) {
                                manager.setVerbose(true);
                                continue;
                            }
                            if (OPTION_FORCE.equals(option)) {
                                forceInstall = true;
                                continue;
                            }
                            if (OPTION_PREVIEW.equals(option)) {
                                previewInstall = true;
                                manager.setVerbose(true);
                                continue;
                            }
                            if (OPTION_NOBACKUP.equals(option)) {
                                backup = false;
                                continue;
                            }
                            if (!OPTION_DIRECTORY.equals(option)) continue;
                            directory = true;
                        }
                    }
                    try {
                        if (!directory) {
                            manager.installModule(aepFileLocation, warFileLocation, previewInstall, forceInstall, backup);
                        } else {
                            manager.installModules(aepFileLocation, warFileLocation, previewInstall, forceInstall, backup);
                        }
                    }
                    catch (IOException error) {
                        throw new ModuleManagementToolException(error.getMessage());
                    }
                    System.exit(0);
                    break block25;
                }
                if (OP_LIST.equals(operation)) {
                    if (args.length != 2) {
                        throw new UsageException("list requires 2 arguments.");
                    }
                    String warFileLocation = args[1];
                    manager.listModules(warFileLocation);
                    System.exit(0);
                    break block25;
                }
                if (OP_UNINSTALL.equals(operation)) {
                    if (args.length < 3) {
                        throw new UsageException("uninstall requires at least 3 arguments.");
                    }
                    String moduleId = args[1];
                    String warLocation = args[2];
                    boolean purge = false;
                    boolean preview = false;
                    if (args.length >= 4) {
                        for (int i = 3; i < args.length; ++i) {
                            String option = args[i];
                            if (OPTION_PURGE.equals(option)) {
                                purge = true;
                            }
                            if (!OPTION_PREVIEW.equals(option)) continue;
                            preview = true;
                            manager.setVerbose(true);
                        }
                    }
                    manager.setVerbose(true);
                    manager.uninstallModule(moduleId, warLocation, preview, purge);
                    System.exit(0);
                    break block25;
                }
                throw new UsageException("Unknown operation " + operation + ".");
            }
            catch (UsageException e) {
                manager.outputErrorMessage("Usage error: " + e.getMessage());
                ModuleManagementTool.outputUsage();
                System.exit(1);
            }
            catch (ModuleManagementToolException e) {
                manager.outputErrorMessage(e.getMessage());
                System.exit(1);
            }
            catch (IOException error) {
                manager.outputErrorMessage(error.getMessage());
                System.exit(1);
            }
        }
    }

    private static String generateGuid() {
        return UUIDGenerator.getInstance().generateTimeBasedUUID().toString();
    }

    private static void outputUsage() {
        System.out.println("Module managment tool available commands:");
        System.out.println("-----------------------------------------------------------\n");
        System.out.println("install: Installs a AMP file(s) into an Alfresco WAR file, updates if an older version is already installed.");
        System.out.println("usage:   install <AMPFileLocation> <WARFileLocation> [options]");
        System.out.println("valid options: ");
        System.out.println("   -verbose   : enable verbose output");
        System.out.println("   -directory : indicates that the amp file location specified is a directory.");
        System.out.println("                All amp files found in the directory and its sub directories are installed.");
        System.out.println("   -force     : forces installation of AMP regardless of currently installed module version");
        System.out.println("   -preview   : previews installation of AMP without modifying WAR file");
        System.out.println("   -nobackup  : indicates that no backup should be made of the WAR\n");
        System.out.println("-----------------------------------------------------------\n");
        System.out.println("list:  Lists all the modules currently installed in an Alfresco WAR file.");
        System.out.println("usage: list <WARFileLocation>\n");
        System.out.println("-----------------------------------------------------------\n");
        System.out.println("uninstall:  Uninstalls a module from the Alfresco WAR file.");
        System.out.println("usage: uninstall <ModuleId> <WARFileLocation>\n");
        System.out.println("-----------------------------------------------------------\n");
    }

    @Override
    public void info(Object message) {
        this.outputVerboseMessage(String.valueOf(message));
    }

    private static class UsageException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public UsageException(String message) {
            super(message);
        }
    }
}

