/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.error;

import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import org.alfresco.api.AlfrescoPublicApi;
import org.springframework.extensions.surf.util.I18NUtil;

@AlfrescoPublicApi
public class AlfrescoRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = 3787143176461219632L;
    private String msgId;
    private transient Object[] msgParams = null;
    private static AtomicInteger errorCounter = new AtomicInteger();

    public static AlfrescoRuntimeException create(String msgId, Object ... objects) {
        return new AlfrescoRuntimeException(msgId, objects);
    }

    public static AlfrescoRuntimeException create(Throwable cause, String msgId, Object ... objects) {
        return new AlfrescoRuntimeException(msgId, objects, cause);
    }

    public static RuntimeException makeRuntimeException(Throwable e, String msgId, Object ... objects) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return AlfrescoRuntimeException.create(e, msgId, objects);
    }

    public AlfrescoRuntimeException(String msgId) {
        super(AlfrescoRuntimeException.resolveMessage(msgId, null));
        this.msgId = msgId;
    }

    public AlfrescoRuntimeException(String msgId, Object[] msgParams) {
        super(AlfrescoRuntimeException.resolveMessage(msgId, msgParams));
        this.msgId = msgId;
        this.msgParams = msgParams;
    }

    public AlfrescoRuntimeException(String msgId, Throwable cause) {
        super(AlfrescoRuntimeException.resolveMessage(msgId, null), cause);
        this.msgId = msgId;
    }

    public AlfrescoRuntimeException(String msgId, Object[] msgParams, Throwable cause) {
        super(AlfrescoRuntimeException.resolveMessage(msgId, msgParams), cause);
        this.msgId = msgId;
        this.msgParams = msgParams;
    }

    public String getMsgId() {
        return this.msgId;
    }

    public Object[] getMsgParams() {
        return this.msgParams;
    }

    private static String resolveMessage(String messageId, Object[] params) {
        String message = I18NUtil.getMessage(messageId, params);
        if (message == null) {
            message = messageId;
        }
        return AlfrescoRuntimeException.buildErrorLogNumber(message);
    }

    private static String buildErrorLogNumber(String message) {
        if (message == null) {
            message = "";
        }
        Date today = new Date();
        StringBuilder buf = new StringBuilder(message.length() + 10);
        AlfrescoRuntimeException.padInt(buf, today.getMonth(), 2);
        AlfrescoRuntimeException.padInt(buf, today.getDate(), 2);
        AlfrescoRuntimeException.padInt(buf, errorCounter.getAndIncrement(), 4);
        buf.append(' ');
        buf.append(message);
        return buf.toString();
    }

    private static void padInt(StringBuilder buffer, int value, int length) {
        String strValue = Integer.toString(value);
        for (int i = length - strValue.length(); i > 0; --i) {
            buffer.append('0');
        }
        buffer.append(strValue);
    }

    public Throwable getRootCause() {
        AlfrescoRuntimeException cause = this;
        Throwable tmp = this;
        while (tmp != null) {
            cause = tmp;
            tmp = cause.getCause();
        }
        return cause;
    }
}

