/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive.zip;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsDecoratingController;
import de.schlichtherle.truezip.fs.FsEntry;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.FsSyncException;
import de.schlichtherle.truezip.fs.FsSyncOption;
import de.schlichtherle.truezip.fs.archive.FsArchiveDriver;
import de.schlichtherle.truezip.fs.archive.FsCovariantEntry;
import de.schlichtherle.truezip.fs.archive.zip.ZipDriver;
import de.schlichtherle.truezip.key.KeyManager;
import de.schlichtherle.truezip.key.KeyProvider;
import de.schlichtherle.truezip.key.SafeKeyManager;
import de.schlichtherle.truezip.util.BitField;
import de.schlichtherle.truezip.util.ExceptionHandler;
import java.io.IOException;
import java.net.URI;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class KeyManagerController<D extends ZipDriver>
extends FsDecoratingController<FsModel, FsController<?>> {
    private static final String ROOT_PATH = FsEntryName.ROOT.getPath();
    protected final D driver;
    private volatile KeyManager<?> manager;

    protected KeyManagerController(FsController<?> controller, D driver) {
        super(controller);
        if (null == driver) {
            throw new NullPointerException();
        }
        this.driver = driver;
    }

    protected abstract Class<?> getKeyType();

    protected abstract Class<? extends IOException> getKeyExceptionType();

    private KeyManager<?> getKeyManager() {
        KeyManager<?> manager = this.manager;
        return null != manager ? manager : (this.manager = ((ZipDriver)this.driver).getKeyManagerProvider().get(this.getKeyType()));
    }

    @Override
    public FsEntry getEntry(FsEntryName name) throws IOException {
        try {
            return this.delegate.getEntry(name);
        }
        catch (IOException ex) {
            if (!name.isRoot() || null == this.findKeyException(ex)) {
                throw ex;
            }
            FsEntry entry = this.getParent().getEntry(((FsModel)this.getModel()).getMountPoint().getPath().resolve(name).getEntryName());
            if (null == entry) {
                return null;
            }
            while (entry instanceof FsCovariantEntry) {
                entry = ((FsCovariantEntry)entry).getEntry();
            }
            FsCovariantEntry special = new FsCovariantEntry(ROOT_PATH);
            special.putEntry(Entry.Type.SPECIAL, ((FsArchiveDriver)this.driver).newEntry(ROOT_PATH, Entry.Type.SPECIAL, entry));
            return special;
        }
    }

    @Override
    public void unlink(FsEntryName name, BitField<FsOutputOption> options) throws IOException {
        try {
            this.delegate.unlink(name, options);
        }
        catch (IOException ex) {
            IOException keyEx = this.findKeyException(ex);
            throw null != keyEx ? keyEx : ex;
        }
        if (name.isRoot()) {
            this.getKeyManager().removeKeyProvider(((ZipDriver)this.driver).resourceUri((FsModel)this.getModel(), name.toString()));
        }
    }

    @CheckForNull
    private IOException findKeyException(Throwable ex) {
        Class<IOException> clazz = this.getKeyExceptionType();
        do {
            if (!clazz.isInstance(ex)) continue;
            return clazz.cast(ex);
        } while (null != (ex = ex.getCause()));
        return null;
    }

    @Override
    public <X extends IOException> void sync(BitField<FsSyncOption> options, ExceptionHandler<? super FsSyncException, X> handler) throws IOException {
        this.delegate.sync(options, handler);
        KeyManager<?> manager = this.getKeyManager();
        URI resource = ((ZipDriver)this.driver).mountPointUri((FsModel)this.getModel());
        KeyProvider<Object> provider = manager instanceof SafeKeyManager ? ((SafeKeyManager)manager).getMappedKeyProvider(resource) : manager.getKeyProvider(resource);
        if (null != provider) {
            ((ZipDriver)this.driver).getKeyProviderSyncStrategy().sync(provider);
        }
    }
}

