/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive;

import de.schlichtherle.truezip.entry.DecoratingEntry;
import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsEntry;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsEntryNotFoundException;
import de.schlichtherle.truezip.fs.FsFalsePositiveException;
import de.schlichtherle.truezip.fs.FsInputOption;
import de.schlichtherle.truezip.fs.FsLockModel;
import de.schlichtherle.truezip.fs.FsLockModelController;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsNeedsSyncException;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.archive.FsArchiveEntry;
import de.schlichtherle.truezip.fs.archive.FsArchiveFileSystem;
import de.schlichtherle.truezip.fs.archive.FsArchiveFileSystemOperation;
import de.schlichtherle.truezip.fs.archive.FsCovariantEntry;
import de.schlichtherle.truezip.fs.archive.FsOperationContext;
import de.schlichtherle.truezip.io.InputException;
import de.schlichtherle.truezip.io.Streams;
import de.schlichtherle.truezip.socket.DelegatingInputSocket;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
abstract class FsArchiveController<E extends FsArchiveEntry>
extends FsLockModelController {
    private static final Logger logger = Logger.getLogger(FsArchiveController.class.getName(), FsArchiveController.class.getName());
    private final ThreadLocal<FsOperationContext> context = new ThreadLocal();

    FsArchiveController(FsLockModel model) {
        super(model);
        if (null == model.getParent()) {
            throw new IllegalArgumentException();
        }
    }

    @Nullable
    final FsOperationContext getContext() {
        return this.context.get();
    }

    final void setContext(@CheckForNull FsOperationContext context) {
        if (null != context) {
            this.context.set(context);
        } else {
            this.context.remove();
        }
    }

    final FsArchiveFileSystem<E> autoMount() throws IOException {
        return this.autoMount(false);
    }

    abstract FsArchiveFileSystem<E> autoMount(boolean var1) throws IOException;

    @Override
    public final boolean isReadOnly() throws IOException {
        return this.autoMount().isReadOnly();
    }

    @Override
    public final FsEntry getEntry(FsEntryName name) throws IOException {
        return this.autoMount().getEntry(name);
    }

    @Override
    public final boolean isReadable(FsEntryName name) throws IOException {
        return this.autoMount().getEntry(name) != null;
    }

    @Override
    public final boolean isWritable(FsEntryName name) throws IOException {
        return this.autoMount().isWritable(name);
    }

    @Override
    public final void setReadOnly(FsEntryName name) throws IOException {
        this.autoMount().setReadOnly(name);
    }

    @Override
    public final boolean setTime(FsEntryName name, Map<Entry.Access, Long> times, BitField<FsOutputOption> options) throws IOException {
        this.checkSync(name, null);
        return this.autoMount().setTime(name, times);
    }

    @Override
    public final boolean setTime(FsEntryName name, BitField<Entry.Access> types, long value, BitField<FsOutputOption> options) throws IOException {
        this.checkSync(name, null);
        return this.autoMount().setTime(name, types, value);
    }

    @Override
    public final InputSocket<?> getInputSocket(FsEntryName name, BitField<FsInputOption> options) {
        return new Input(name);
    }

    abstract InputSocket<? extends E> getInputSocket(String var1);

    @Override
    public final OutputSocket<?> getOutputSocket(FsEntryName name, BitField<FsOutputOption> options, Entry template) {
        return new Output(name, options, template);
    }

    abstract OutputSocket<? extends E> getOutputSocket(E var1);

    @Override
    public final void mknod(FsEntryName name, Entry.Type type, BitField<FsOutputOption> options, Entry template) throws IOException {
        if (name.isRoot()) {
            try {
                this.autoMount();
            }
            catch (FsFalsePositiveException ex) {
                if (Entry.Type.DIRECTORY != type) {
                    throw ex;
                }
                this.autoMount(true);
                return;
            }
            throw new FsEntryNotFoundException((FsModel)this.getModel(), name, "directory entry exists already");
        }
        this.checkSync(name, null);
        this.autoMount(options.get(FsOutputOption.CREATE_PARENTS)).mknod(name, type, options, template).commit();
    }

    @Override
    public void unlink(FsEntryName name, BitField<FsOutputOption> options) throws IOException {
        int size;
        this.checkSync(name, null);
        FsArchiveFileSystem<E> fs = this.autoMount();
        fs.unlink(name);
        if (name.isRoot() && 0 != (size = fs.getSize() - 1)) {
            logger.log(Level.WARNING, "unlink.absolute", new Object[]{this.getMountPoint(), size});
        }
    }

    abstract void checkSync(FsEntryName var1, @CheckForNull Entry.Access var2) throws FsNeedsSyncException;

    private static final class ProxyEntry
    extends DecoratingEntry<FsArchiveEntry>
    implements FsArchiveEntry {
        ProxyEntry(FsArchiveEntry entry) {
            super(entry);
        }

        @Override
        public Entry.Type getType() {
            return ((FsArchiveEntry)this.delegate).getType();
        }

        @Override
        public boolean setSize(Entry.Size type, long value) {
            return ((FsArchiveEntry)this.delegate).setSize(type, value);
        }

        @Override
        public boolean setTime(Entry.Access type, long value) {
            return ((FsArchiveEntry)this.delegate).setTime(type, value);
        }
    }

    private final class Output
    extends OutputSocket<FsArchiveEntry> {
        final FsEntryName name;
        final BitField<FsOutputOption> options;
        @CheckForNull
        final Entry template;
        @CheckForNull
        FsArchiveFileSystemOperation<E> mknod;

        Output(FsEntryName name, @CheckForNull BitField<FsOutputOption> options, Entry template) {
            this.name = name;
            if (null == this.name) {
                throw new NullPointerException();
            }
            this.options = options;
            if (null == this.options) {
                throw new NullPointerException();
            }
            this.template = template;
        }

        FsArchiveFileSystemOperation<E> mknod() throws IOException {
            if (null != this.mknod) {
                return this.mknod;
            }
            FsArchiveController.this.checkSync(this.name, Entry.Access.WRITE);
            this.mknod = FsArchiveController.this.autoMount(!this.name.isRoot() && this.options.get(FsOutputOption.CREATE_PARENTS)).mknod(this.name, Entry.Type.FILE, this.options, this.template);
            return this.mknod;
        }

        @Override
        public FsArchiveEntry getLocalTarget() throws IOException {
            Object ae = ((FsCovariantEntry)this.mknod().getTarget()).getEntry();
            if (this.options.get(FsOutputOption.APPEND)) {
                return new ProxyEntry((FsArchiveEntry)ae);
            }
            return ae;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public OutputStream newOutputStream() throws IOException {
            this.mknod = null;
            FsArchiveFileSystemOperation mknod = this.mknod();
            Object ae = ((FsCovariantEntry)mknod.getTarget()).getEntry();
            InputStream in = null;
            if (this.options.get(FsOutputOption.APPEND)) {
                try {
                    in = new Input(this.name).newInputStream();
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            try {
                OutputSocket os = FsArchiveController.this.getOutputSocket(ae);
                if (null == in) {
                    os.bind(this);
                }
                OutputStream out = os.newOutputStream();
                try {
                    mknod.commit();
                    if (in != null) {
                        Streams.cat(in, out);
                    }
                }
                catch (IOException ex) {
                    out.close();
                    throw ex;
                }
                OutputStream outputStream = out;
                return outputStream;
            }
            finally {
                if (null != in) {
                    try {
                        in.close();
                    }
                    catch (IOException ex) {
                        throw new InputException(ex);
                    }
                }
            }
        }
    }

    private final class Input
    extends DelegatingInputSocket<FsArchiveEntry> {
        final FsEntryName name;
        @CheckForNull
        FsArchiveEntry localTarget;

        Input(FsEntryName name) {
            this.name = name;
            if (null == this.name) {
                throw new NullPointerException();
            }
        }

        @Override
        public FsArchiveEntry getLocalTarget() throws IOException {
            if (null != this.localTarget) {
                return this.localTarget;
            }
            this.getPeerTarget();
            FsArchiveController.this.checkSync(this.name, Entry.Access.READ);
            FsCovariantEntry fse = FsArchiveController.this.autoMount().getEntry(this.name);
            if (null == fse) {
                throw new FsEntryNotFoundException((FsModel)FsArchiveController.this.getModel(), this.name, "no such entry");
            }
            this.localTarget = fse.getEntry();
            return this.localTarget;
        }

        @Override
        protected InputSocket<? extends FsArchiveEntry> getDelegate() throws IOException {
            this.localTarget = null;
            FsArchiveEntry ae = this.getLocalTarget();
            if (Entry.Type.FILE != ae.getType()) {
                throw new FsEntryNotFoundException((FsModel)FsArchiveController.this.getModel(), this.name, "entry type is not a file");
            }
            return FsArchiveController.this.getInputSocket(ae.getName());
        }
    }
}

