/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import java.io.IOException;
import java.io.StringReader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Realm;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.connector.Request;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.util.ConcurrentMessageDigest;
import org.apache.catalina.util.MD5Encoder;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.B2CConverter;
import org.apache.tomcat.util.http.parser.HttpParser;

public class DigestAuthenticator
extends AuthenticatorBase {
    private static final Log log = LogFactory.getLog(DigestAuthenticator.class);
    @Deprecated
    protected static final MD5Encoder md5Encoder = new MD5Encoder();
    protected static final String info = "org.apache.catalina.authenticator.DigestAuthenticator/1.0";
    protected static final String QOP = "auth";
    @Deprecated
    protected static volatile MessageDigest md5Helper;
    protected Map<String, NonceInfo> nonces;
    protected long lastTimestamp = 0L;
    protected final Object lastTimestampLock = new Object();
    protected int nonceCacheSize = 1000;
    protected int nonceCountWindowSize = 100;
    protected String key = null;
    protected long nonceValidity = 300000L;
    protected String opaque;
    protected boolean validateUri = true;

    public DigestAuthenticator() {
        this.setCache(false);
        try {
            if (md5Helper == null) {
                md5Helper = MessageDigest.getInstance("MD5");
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String getInfo() {
        return info;
    }

    public int getNonceCountWindowSize() {
        return this.nonceCountWindowSize;
    }

    public void setNonceCountWindowSize(int nonceCountWindowSize) {
        this.nonceCountWindowSize = nonceCountWindowSize;
    }

    public int getNonceCacheSize() {
        return this.nonceCacheSize;
    }

    public void setNonceCacheSize(int nonceCacheSize) {
        this.nonceCacheSize = nonceCacheSize;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public long getNonceValidity() {
        return this.nonceValidity;
    }

    public void setNonceValidity(long nonceValidity) {
        this.nonceValidity = nonceValidity;
    }

    public String getOpaque() {
        return this.opaque;
    }

    public void setOpaque(String opaque) {
        this.opaque = opaque;
    }

    public boolean isValidateUri() {
        return this.validateUri;
    }

    public void setValidateUri(boolean validateUri) {
        this.validateUri = validateUri;
    }

    @Override
    public boolean authenticate(Request request, HttpServletResponse response, LoginConfig config) throws IOException {
        Principal principal = request.getUserPrincipal();
        if (principal != null) {
            String ssoId;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Already authenticated '" + principal.getName() + "'"));
            }
            if ((ssoId = (String)request.getNote("org.apache.catalina.request.SSOID")) != null) {
                this.associate(ssoId, request.getSessionInternal(true));
            }
            return true;
        }
        String authorization = request.getHeader("authorization");
        DigestInfo digestInfo = new DigestInfo(this.getOpaque(), this.getNonceValidity(), this.getKey(), this.nonces, this.isValidateUri());
        if (authorization != null && digestInfo.parse(request, authorization)) {
            if (digestInfo.validate(request, config)) {
                principal = digestInfo.authenticate(this.context.getRealm());
            }
            if (principal != null && !digestInfo.isNonceStale()) {
                this.register(request, response, principal, "DIGEST", digestInfo.getUsername(), null);
                return true;
            }
        }
        String nonce = this.generateNonce(request);
        this.setAuthenticateHeader(request, response, config, nonce, principal != null && digestInfo.isNonceStale());
        response.sendError(401);
        return false;
    }

    @Override
    protected String getAuthMethod() {
        return "DIGEST";
    }

    @Deprecated
    protected String parseUsername(String authorization) {
        if (authorization == null) {
            return null;
        }
        if (!authorization.startsWith("Digest ")) {
            return null;
        }
        authorization = authorization.substring(7).trim();
        StringTokenizer commaTokenizer = new StringTokenizer(authorization, ",");
        while (commaTokenizer.hasMoreTokens()) {
            String currentToken = commaTokenizer.nextToken();
            int equalSign = currentToken.indexOf(61);
            if (equalSign < 0) {
                return null;
            }
            String currentTokenName = currentToken.substring(0, equalSign).trim();
            String currentTokenValue = currentToken.substring(equalSign + 1).trim();
            if (!"username".equals(currentTokenName)) continue;
            return DigestAuthenticator.removeQuotes(currentTokenValue);
        }
        return null;
    }

    protected static String removeQuotes(String quotedString, boolean quotesRequired) {
        if (quotedString.length() > 0 && quotedString.charAt(0) != '\"' && !quotesRequired) {
            return quotedString;
        }
        if (quotedString.length() > 2) {
            return quotedString.substring(1, quotedString.length() - 1);
        }
        return "";
    }

    protected static String removeQuotes(String quotedString) {
        return DigestAuthenticator.removeQuotes(quotedString, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String generateNonce(Request request) {
        long currentTime = System.currentTimeMillis();
        Object object = this.lastTimestampLock;
        synchronized (object) {
            if (currentTime > this.lastTimestamp) {
                this.lastTimestamp = currentTime;
            } else {
                currentTime = ++this.lastTimestamp;
            }
        }
        String ipTimeKey = request.getRemoteAddr() + ":" + currentTime + ":" + this.getKey();
        byte[] buffer = ConcurrentMessageDigest.digestMD5(ipTimeKey.getBytes(B2CConverter.ISO_8859_1));
        String nonce = currentTime + ":" + MD5Encoder.encode(buffer);
        NonceInfo info = new NonceInfo(currentTime, this.getNonceCountWindowSize());
        Map<String, NonceInfo> map = this.nonces;
        synchronized (map) {
            this.nonces.put(nonce, info);
        }
        return nonce;
    }

    protected void setAuthenticateHeader(HttpServletRequest request, HttpServletResponse response, LoginConfig config, String nonce, boolean isNonceStale) {
        String realmName = config.getRealmName();
        if (realmName == null) {
            realmName = "Authentication required";
        }
        String authenticateHeader = isNonceStale ? "Digest realm=\"" + realmName + "\", " + "qop=\"" + QOP + "\", nonce=\"" + nonce + "\", " + "opaque=\"" + this.getOpaque() + "\", stale=true" : "Digest realm=\"" + realmName + "\", " + "qop=\"" + QOP + "\", nonce=\"" + nonce + "\", " + "opaque=\"" + this.getOpaque() + "\"";
        response.setHeader("WWW-Authenticate", authenticateHeader);
    }

    @Override
    protected synchronized void startInternal() throws LifecycleException {
        super.startInternal();
        if (this.getKey() == null) {
            this.setKey(this.sessionIdGenerator.generateSessionId());
        }
        if (this.getOpaque() == null) {
            this.setOpaque(this.sessionIdGenerator.generateSessionId());
        }
        this.nonces = new LinkedHashMap<String, NonceInfo>(){
            private static final long serialVersionUID = 1L;
            private static final long LOG_SUPPRESS_TIME = 300000L;
            private long lastLog = 0L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, NonceInfo> eldest) {
                long currentTime = System.currentTimeMillis();
                if (this.size() > DigestAuthenticator.this.getNonceCacheSize()) {
                    if (this.lastLog < currentTime && currentTime - eldest.getValue().getTimestamp() < DigestAuthenticator.this.getNonceValidity()) {
                        log.warn((Object)AuthenticatorBase.sm.getString("digestAuthenticator.cacheRemove"));
                        this.lastLog = currentTime + 300000L;
                    }
                    return true;
                }
                return false;
            }
        };
    }

    private static class NonceInfo {
        private volatile long timestamp;
        private volatile boolean[] seen;
        private volatile int offset;
        private volatile int count = 0;

        public NonceInfo(long currentTime, int seenWindowSize) {
            this.timestamp = currentTime;
            this.seen = new boolean[seenWindowSize];
            this.offset = seenWindowSize / 2;
        }

        public synchronized boolean nonceCountValid(long nonceCount) {
            if ((long)(this.count - this.offset) >= nonceCount || nonceCount > (long)(this.count - this.offset + this.seen.length)) {
                return false;
            }
            int checkIndex = (int)((nonceCount + (long)this.offset) % (long)this.seen.length);
            if (this.seen[checkIndex]) {
                return false;
            }
            this.seen[checkIndex] = true;
            this.seen[this.count % this.seen.length] = false;
            ++this.count;
            return true;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }

    private static class DigestInfo {
        private final String opaque;
        private final long nonceValidity;
        private final String key;
        private final Map<String, NonceInfo> nonces;
        private boolean validateUri = true;
        private String userName = null;
        private String method = null;
        private String uri = null;
        private String response = null;
        private String nonce = null;
        private String nc = null;
        private String cnonce = null;
        private String realmName = null;
        private String qop = null;
        private String opaqueReceived = null;
        private boolean nonceStale = false;

        public DigestInfo(String opaque, long nonceValidity, String key, Map<String, NonceInfo> nonces, boolean validateUri) {
            this.opaque = opaque;
            this.nonceValidity = nonceValidity;
            this.key = key;
            this.nonces = nonces;
            this.validateUri = validateUri;
        }

        public String getUsername() {
            return this.userName;
        }

        public boolean parse(Request request, String authorization) {
            Map<String, String> directives;
            if (authorization == null) {
                return false;
            }
            try {
                directives = HttpParser.parseAuthorizationDigest(new StringReader(authorization));
            }
            catch (IOException e) {
                return false;
            }
            if (directives == null) {
                return false;
            }
            this.method = request.getMethod();
            this.userName = directives.get("username");
            this.realmName = directives.get("realm");
            this.nonce = directives.get("nonce");
            this.nc = directives.get("nc");
            this.cnonce = directives.get("cnonce");
            this.qop = directives.get("qop");
            this.uri = directives.get("uri");
            this.response = directives.get("response");
            this.opaqueReceived = directives.get("opaque");
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean validate(Request request, LoginConfig config) {
            String serverIpTimeKey;
            byte[] buffer;
            String md5ServerIpTimeKey;
            long nonceTime;
            String lcRealm;
            String query;
            String uriQuery;
            if (this.userName == null || this.realmName == null || this.nonce == null || this.uri == null || this.response == null) {
                return false;
            }
            if (this.validateUri && !this.uri.equals(uriQuery = (query = request.getQueryString()) == null ? request.getRequestURI() : request.getRequestURI() + "?" + query)) {
                String host = request.getHeader("host");
                String scheme = request.getScheme();
                if (host != null && !uriQuery.startsWith(scheme)) {
                    StringBuilder absolute = new StringBuilder();
                    absolute.append(scheme);
                    absolute.append("://");
                    absolute.append(host);
                    absolute.append(uriQuery);
                    if (!this.uri.equals(absolute.toString())) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
            if ((lcRealm = config.getRealmName()) == null) {
                lcRealm = "Authentication required";
            }
            if (!lcRealm.equals(this.realmName)) {
                return false;
            }
            if (!this.opaque.equals(this.opaqueReceived)) {
                return false;
            }
            int i = this.nonce.indexOf(":");
            if (i < 0 || i + 1 == this.nonce.length()) {
                return false;
            }
            try {
                nonceTime = Long.parseLong(this.nonce.substring(0, i));
            }
            catch (NumberFormatException nfe) {
                return false;
            }
            String md5clientIpTimeKey = this.nonce.substring(i + 1);
            long currentTime = System.currentTimeMillis();
            if (currentTime - nonceTime > this.nonceValidity) {
                this.nonceStale = true;
                Map<String, NonceInfo> map = this.nonces;
                synchronized (map) {
                    this.nonces.remove(this.nonce);
                }
            }
            if (!(md5ServerIpTimeKey = MD5Encoder.encode(buffer = ConcurrentMessageDigest.digestMD5((serverIpTimeKey = request.getRemoteAddr() + ":" + nonceTime + ":" + this.key).getBytes(B2CConverter.ISO_8859_1)))).equals(md5clientIpTimeKey)) {
                return false;
            }
            if (this.qop != null && !DigestAuthenticator.QOP.equals(this.qop)) {
                return false;
            }
            if (this.qop == null) {
                if (this.cnonce != null || this.nc != null) {
                    return false;
                }
            } else {
                NonceInfo info;
                long count;
                if (this.cnonce == null || this.nc == null) {
                    return false;
                }
                if (this.nc.length() < 6 || this.nc.length() > 8) {
                    return false;
                }
                try {
                    count = Long.parseLong(this.nc, 16);
                }
                catch (NumberFormatException nfe) {
                    return false;
                }
                Map<String, NonceInfo> map = this.nonces;
                synchronized (map) {
                    info = this.nonces.get(this.nonce);
                }
                if (info == null) {
                    this.nonceStale = true;
                } else if (!info.nonceCountValid(count)) {
                    return false;
                }
            }
            return true;
        }

        public boolean isNonceStale() {
            return this.nonceStale;
        }

        public Principal authenticate(Realm realm) {
            String a2 = this.method + ":" + this.uri;
            byte[] buffer = ConcurrentMessageDigest.digestMD5(a2.getBytes(B2CConverter.ISO_8859_1));
            String md5a2 = MD5Encoder.encode(buffer);
            return realm.authenticate(this.userName, this.response, this.nonce, this.nc, this.cnonce, this.qop, this.realmName, md5a2);
        }
    }
}

