/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.io;

import edu.umd.cs.findbugs.annotations.CleanupObligation;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.DischargesObligation;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.nio.channels.SeekableByteChannel;
import javax.annotation.concurrent.NotThreadSafe;

@CleanupObligation
@NotThreadSafe
public class SeekableByteBufferChannel
implements SeekableByteChannel {
    private ByteBuffer buffer;

    @CreatesObligation
    public SeekableByteBufferChannel(ByteBuffer buffer) {
        if (!buffer.isReadOnly() && !buffer.hasArray()) {
            throw new IllegalArgumentException();
        }
        this.buffer = buffer.duplicate();
    }

    public ByteBuffer getByteBuffer() {
        return this.buffer.duplicate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int read(ByteBuffer dst) throws IOException {
        int limit;
        int available = this.buffer.remaining();
        if (0 >= available) {
            return -1;
        }
        int remaining = dst.remaining();
        if (remaining > available) {
            remaining = available;
        }
        if (available > remaining) {
            limit = this.buffer.limit();
            this.buffer.limit(this.buffer.position() + remaining);
        } else {
            limit = -1;
        }
        try {
            dst.put(this.buffer);
        }
        finally {
            if (0 <= limit) {
                this.buffer.limit(limit);
            }
        }
        return remaining;
    }

    @Override
    public final int write(ByteBuffer src) throws IOException {
        int remaining = src.remaining();
        int position = this.buffer.position();
        this.ensureLimit(position + remaining);
        this.buffer.put(src);
        return remaining;
    }

    @Override
    public final long position() throws IOException {
        return this.buffer.position();
    }

    private void ensureLimit(long minLimit) throws IOException {
        int limit = this.buffer.limit();
        if (minLimit <= (long)limit) {
            return;
        }
        if (this.buffer.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        long oldCapacity = this.buffer.capacity();
        if (minLimit <= oldCapacity) {
            this.buffer.limit((int)minLimit);
        } else {
            long newCapacity;
            if (minLimit > Integer.MAX_VALUE) {
                throw new OutOfMemoryError();
            }
            long l = newCapacity = 0L < oldCapacity ? oldCapacity : 1L;
            while ((newCapacity <<= 1) < minLimit) {
            }
            if (newCapacity > Integer.MAX_VALUE) {
                newCapacity = minLimit;
            }
            byte[] array = new byte[(int)newCapacity];
            System.arraycopy(this.buffer.array(), this.buffer.arrayOffset(), array, 0, limit);
            this.buffer = ByteBuffer.wrap(array);
        }
    }

    @Override
    public final SeekableByteBufferChannel position(long newPosition) throws IOException {
        this.ensureLimit(newPosition);
        this.buffer.position((int)newPosition);
        return this;
    }

    @Override
    public final long size() throws IOException {
        return this.buffer.limit();
    }

    @Override
    public final SeekableByteBufferChannel truncate(long newSize) throws IOException {
        if ((long)this.buffer.limit() > newSize) {
            this.buffer.limit((int)newSize);
        }
        return this;
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    @DischargesObligation
    public void close() throws IOException {
    }
}

