/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import de.schlichtherle.truezip.util.UriBuilder;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.util.Locale;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class FsScheme
implements Serializable,
Comparable<FsScheme> {
    private static final long serialVersionUID = 2765230379628276648L;
    private final String scheme;

    public static FsScheme create(String scheme) {
        try {
            return new FsScheme(scheme);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public FsScheme(String scheme) throws URISyntaxException {
        UriBuilder.validateScheme(scheme);
        this.scheme = scheme;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof FsScheme && this.scheme.equalsIgnoreCase(((FsScheme)that).scheme);
    }

    @Override
    public int compareTo(FsScheme that) {
        return this.scheme.compareToIgnoreCase(that.scheme);
    }

    public int hashCode() {
        return this.scheme.toLowerCase(Locale.ENGLISH).hashCode();
    }

    public String toString() {
        return this.scheme;
    }
}

