/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive;

import de.schlichtherle.truezip.fs.FsEntryName;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class FsArchiveFileSystemException
extends IOException {
    private static final long serialVersionUID = 4652084652223428651L;
    @CheckForNull
    private final String path;

    FsArchiveFileSystemException(FsEntryName name, String message) {
        this(name.toString(), message);
    }

    FsArchiveFileSystemException(@CheckForNull String path, String message) {
        super(message);
        this.path = path;
    }

    FsArchiveFileSystemException(@CheckForNull String path, Throwable cause) {
        super(cause);
        this.path = path;
    }

    FsArchiveFileSystemException(@CheckForNull String path, String message, Throwable cause) {
        super(message, cause);
        this.path = path;
    }

    @Override
    public String getMessage() {
        String m = super.getMessage();
        return null == this.path ? m : (this.path.isEmpty() ? "<file system root>" : this.path) + " (" + m + ")";
    }
}

