/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.nio.charset;

import de.schlichtherle.truezip.nio.charset.Ibm437Charset;
import java.nio.charset.Charset;
import java.nio.charset.spi.CharsetProvider;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ZipCharsetProvider
extends CharsetProvider {
    private static final Map<String, Charset> CHARSETS;

    private static String lowerCase(String s) {
        return s.toLowerCase(Locale.ENGLISH);
    }

    @Override
    public Iterator<Charset> charsets() {
        return CHARSETS.values().iterator();
    }

    @Override
    public Charset charsetForName(String charset) {
        return CHARSETS.get(ZipCharsetProvider.lowerCase(charset));
    }

    static {
        Logger logger = Logger.getLogger(ZipCharsetProvider.class.getName(), ZipCharsetProvider.class.getName());
        HashMap<String, Charset> charsets = new HashMap<String, Charset>();
        for (Charset charset : new Charset[]{new Ibm437Charset()}) {
            charsets.put(ZipCharsetProvider.lowerCase(charset.name()), charset);
            for (String alias : charset.aliases()) {
                charsets.put(ZipCharsetProvider.lowerCase(alias), charset);
            }
            logger.log(Level.CONFIG, "providing", new Object[]{charset.displayName(), charset.aliases()});
        }
        CHARSETS = Collections.unmodifiableMap(charsets);
    }
}

