/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.zip;

import de.schlichtherle.truezip.crypto.CipherReadOnlyFile;
import de.schlichtherle.truezip.crypto.SuspensionPenalty;
import de.schlichtherle.truezip.crypto.param.AesKeyStrength;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.util.ArrayHelper;
import de.schlichtherle.truezip.zip.WinZipAesCipher;
import de.schlichtherle.truezip.zip.WinZipAesEntryExtraField;
import de.schlichtherle.truezip.zip.WinZipAesEntryParameters;
import de.schlichtherle.truezip.zip.ZipAuthenticationException;
import de.schlichtherle.truezip.zip.ZipCryptoException;
import de.schlichtherle.truezip.zip.ZipEntry;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.EOFException;
import java.io.IOException;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.NotThreadSafe;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

@NotThreadSafe
final class WinZipAesEntryReadOnlyFile
extends CipherReadOnlyFile {
    private final byte[] authenticationCode;
    private final KeyParameter sha1MacParam;
    private final ZipEntry entry;

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    WinZipAesEntryReadOnlyFile(@WillCloseWhenClosed ReadOnlyFile rof, WinZipAesEntryParameters param) throws IOException {
        super(rof);
        KeyParameter sha1MacParam;
        ParametersWithIV aesCtrParam;
        KeyParameter keyParam;
        ZipEntry entry = param.getEntry();
        assert (entry.isEncrypted());
        WinZipAesEntryExtraField field = (WinZipAesEntryExtraField)entry.getExtraField(39169);
        if (null == field) {
            throw new ZipCryptoException(entry.getName() + " (missing extra field for WinZip AES entry)");
        }
        AesKeyStrength keyStrength = field.getKeyStrength();
        int keyStrengthBits = keyStrength.getBits();
        int keyStrengthBytes = keyStrength.getBytes();
        byte[] salt = new byte[keyStrengthBytes / 2];
        rof.seek(0L);
        rof.readFully(salt);
        byte[] passwdVerifier = new byte[2];
        rof.readFully(passwdVerifier);
        HMac mac = new HMac((Digest)new SHA1Digest());
        this.authenticationCode = new byte[mac.getMacSize() / 2];
        long start = rof.getFilePointer();
        long end = rof.length() - (long)this.authenticationCode.length;
        long length = end - start;
        if (0L > length) {
            throw new ZipCryptoException(entry.getName() + " (false positive WinZip AES entry is too short)", new EOFException());
        }
        rof.seek(end);
        rof.readFully(this.authenticationCode);
        if (-1 != rof.read()) {
            throw new ZipCryptoException("Expected end of file after WinZip AES authentication code!");
        }
        PKCS5S2ParametersGenerator gen = new PKCS5S2ParametersGenerator();
        long lastTry = 0L;
        do {
            byte[] passwd = param.getReadPassword(0L != lastTry);
            assert (null != passwd);
            gen.init(passwd, salt, 1000);
            assert (128 <= keyStrengthBits);
            keyParam = (KeyParameter)gen.generateDerivedParameters(2 * keyStrengthBits + 16);
            this.paranoidWipe(passwd);
            byte[] ctrIv = new byte[16];
            aesCtrParam = new ParametersWithIV((CipherParameters)new KeyParameter(keyParam.getKey(), 0, keyStrengthBytes), ctrIv);
            sha1MacParam = new KeyParameter(keyParam.getKey(), keyStrengthBytes, keyStrengthBytes);
            lastTry = SuspensionPenalty.enforce(lastTry);
        } while (!ArrayHelper.equals(keyParam.getKey(), 2 * keyStrengthBytes, passwdVerifier, 0, 2));
        this.sha1MacParam = sha1MacParam;
        this.entry = entry;
        WinZipAesCipher cipher = new WinZipAesCipher();
        cipher.init(false, (CipherParameters)aesCtrParam);
        this.init(cipher, start, length);
        param.setKeyStrength(keyStrength);
    }

    private void paranoidWipe(byte[] pwd) {
        int i = pwd.length;
        while (--i >= 0) {
            pwd[i] = 0;
        }
    }

    void authenticate() throws IOException {
        HMac mac = new HMac((Digest)new SHA1Digest());
        mac.init((CipherParameters)this.sha1MacParam);
        byte[] buf = this.computeMac((Mac)mac);
        if (!ArrayHelper.equals(buf, 0, this.authenticationCode, 0, this.authenticationCode.length)) {
            throw new ZipAuthenticationException(this.entry.getName() + " (authenticated WinZip AES entry content has been tampered with)");
        }
    }
}

