/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.module.tool;

import de.schlichtherle.truezip.file.TArchiveDetector;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.module.ModuleDetailsImpl;
import org.alfresco.repo.module.tool.LogOutput;
import org.alfresco.repo.module.tool.ModuleDetailsHelper;
import org.alfresco.repo.module.tool.ModuleManagementToolException;
import org.alfresco.repo.module.tool.WarHelper;
import org.alfresco.service.cmr.module.ModuleDependency;
import org.alfresco.service.cmr.module.ModuleDetails;
import org.alfresco.util.VersionNumber;

public class WarHelperImpl
implements WarHelper {
    public static final String VERSION_PROPERTIES = "/WEB-INF/classes/alfresco/version.properties";
    public static final String MANIFEST_FILE = "/META-INF/MANIFEST.MF";
    public static final String MANIFEST_SPECIFICATION_TITLE = "Specification-Title";
    public static final String MANIFEST_SPECIFICATION_VERSION = "Specification-Version";
    public static final String MANIFEST_IMPLEMENTATION_TITLE = "Implementation-Title";
    public static final String MANIFEST_SHARE = "Alfresco Share";
    public static final String MANIFEST_COMMUNITY = "Community";
    protected static final String REGEX_NUMBER_OR_DOT = "[0-9\\.]*";
    private LogOutput log = null;

    public WarHelperImpl(LogOutput log) {
        this.log = log;
    }

    @Override
    public void checkCompatibleVersion(TFile war, ModuleDetails installingModuleDetails) {
        TFile propsFile = new TFile(war + VERSION_PROPERTIES);
        if (propsFile != null && propsFile.exists()) {
            this.log.info("INFO: Checking the war version using /WEB-INF/classes/alfresco/version.properties");
            Properties warVers = this.loadProperties(propsFile);
            VersionNumber warVersion = new VersionNumber(warVers.getProperty("version.major") + "." + warVers.getProperty("version.minor") + "." + warVers.getProperty("version.revision"));
            this.checkVersions(warVersion, installingModuleDetails);
        } else {
            this.log.info("INFO: Checking the war version using the manifest.");
            this.checkCompatibleVersionUsingManifest(war, installingModuleDetails);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void checkCompatibleVersionUsingManifest(TFile war, ModuleDetails installingModuleDetails) {
        String version = this.findManifestArtibute(war, MANIFEST_SPECIFICATION_VERSION);
        if (version != null && version.length() > 0) {
            if (version.matches(REGEX_NUMBER_OR_DOT)) {
                VersionNumber warVersion = new VersionNumber(version);
                this.checkVersions(warVersion, installingModuleDetails);
                return;
            } else {
                String edition = this.findManifestArtibute(war, MANIFEST_IMPLEMENTATION_TITLE);
                if (!edition.endsWith(MANIFEST_COMMUNITY)) throw new ModuleManagementToolException("Invalid version number specified: " + version);
                this.log.info("WARNING: Community edition war detected, the version number is non-numeric so we will not validate it.");
            }
            return;
        } else {
            this.log.info("WARNING: No version information detected in war, therefore version validation is disabled, continuing anyway.  Is this war prior to 3.4.11, 4.1.1 and Community 4.2 ?");
        }
    }

    protected String findManifestArtibute(TFile war, String attributeName) throws ModuleManagementToolException {
        Manifest manifest = this.findManifest(war);
        Attributes attribs = manifest.getMainAttributes();
        return attribs.getValue(attributeName);
    }

    @Override
    public Manifest findManifest(TFile war) throws ModuleManagementToolException {
        InputStream is = null;
        try {
            Manifest manifest;
            is = new TFileInputStream(war + MANIFEST_FILE);
            Manifest manifest2 = manifest = new Manifest(is);
            return manifest2;
        }
        catch (IOException e) {
            throw new ModuleManagementToolException("Unabled to read a manifest for the war file: " + war);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Throwable e) {}
            }
        }
    }

    private void checkVersions(VersionNumber warVersion, ModuleDetails installingModuleDetails) throws ModuleManagementToolException {
        if (warVersion.compareTo(installingModuleDetails.getRepoVersionMin()) == -1) {
            throw new ModuleManagementToolException("The module (" + installingModuleDetails.getTitle() + ") must be installed on a war version equal to or greater than " + installingModuleDetails.getRepoVersionMin() + ". This war is version:" + warVersion + ".");
        }
        if (warVersion.compareTo(installingModuleDetails.getRepoVersionMax()) == 1) {
            throw new ModuleManagementToolException("The module (" + installingModuleDetails.getTitle() + ") cannot be installed on a war version greater than " + installingModuleDetails.getRepoVersionMax() + ". This war is version:" + warVersion + ".");
        }
    }

    @Override
    public void checkCompatibleEdition(TFile war, ModuleDetails installingModuleDetails) {
        List<String> installableEditions = installingModuleDetails.getEditions();
        if (installableEditions != null && installableEditions.size() > 0) {
            TFile propsFile = new TFile(war + VERSION_PROPERTIES);
            if (propsFile != null && propsFile.exists()) {
                Properties warVers = this.loadProperties(propsFile);
                String warEdition = warVers.getProperty("version.edition");
                for (String edition : installableEditions) {
                    if (!warEdition.equalsIgnoreCase(edition)) continue;
                    return;
                }
                throw new ModuleManagementToolException("The module (" + installingModuleDetails.getTitle() + ") can only be installed in one of the following editions" + installableEditions);
            }
            this.checkCompatibleEditionUsingManifest(war, installingModuleDetails);
        }
    }

    public void checkCompatibleEditionUsingManifest(TFile war, ModuleDetails installingModuleDetails) {
        List<String> installableEditions = installingModuleDetails.getEditions();
        if (installableEditions != null && installableEditions.size() > 0) {
            String warEdition = this.findManifestArtibute(war, MANIFEST_IMPLEMENTATION_TITLE);
            if (warEdition != null && warEdition.length() > 0) {
                warEdition = warEdition.toLowerCase();
                for (String edition : installableEditions) {
                    if (!warEdition.endsWith(edition.toLowerCase())) continue;
                    return;
                }
                throw new ModuleManagementToolException("The module (" + installingModuleDetails.getTitle() + ") can only be installed in one of the following editions" + installableEditions);
            }
            this.log.info("WARNING: No edition information detected in war, edition validation is disabled, continuing anyway. Is this war prior to 3.4.11, 4.1.1 and Community 4.2 ?");
        }
    }

    @Override
    public void checkModuleDependencies(TFile war, ModuleDetails installingModuleDetails) {
        List<ModuleDependency> installingModuleDependencies = installingModuleDetails.getDependencies();
        ArrayList<ModuleDependency> missingDependencies = new ArrayList<ModuleDependency>(0);
        for (ModuleDependency dependency : installingModuleDependencies) {
            String dependencyId;
            ModuleDetails dependencyModuleDetails;
            if (dependency.isValidDependency(dependencyModuleDetails = this.getModuleDetails(war, dependencyId = dependency.getDependencyId()))) continue;
            missingDependencies.add(dependency);
        }
        if (missingDependencies.size() > 0) {
            throw new ModuleManagementToolException("The following modules must first be installed: " + missingDependencies);
        }
    }

    @Override
    public ModuleDetails getModuleDetailsOrAlias(TFile war, ModuleDetails installingModuleDetails) {
        ModuleDetails installedModuleDetails = this.getModuleDetails(war, installingModuleDetails.getId());
        if (installedModuleDetails == null) {
            List<String> installingAliases = installingModuleDetails.getAliases();
            for (String installingAlias : installingAliases) {
                ModuleDetails installedAliasModuleDetails = this.getModuleDetails(war, installingAlias);
                if (installedAliasModuleDetails == null) continue;
                installedModuleDetails = installedAliasModuleDetails;
                break;
            }
        }
        return installedModuleDetails;
    }

    @Override
    public boolean isShareWar(TFile warFile) {
        if (!warFile.exists()) {
            throw new ModuleManagementToolException("The war file '" + warFile + "' does not exist.");
        }
        String title = this.findManifestArtibute(warFile, MANIFEST_SPECIFICATION_TITLE);
        return MANIFEST_SHARE.equals(title);
    }

    @Override
    public List<ModuleDetails> listModules(TFile war) {
        ArrayList<ModuleDetails> moduleDetails = new ArrayList<ModuleDetails>();
        boolean moduleFound = false;
        TFile moduleDir = new TFile((File)war, "/WEB-INF/classes/alfresco/module");
        if (!moduleDir.exists()) {
            return moduleDetails;
        }
        TFile[] dirs = moduleDir.listFiles();
        if (dirs != null && dirs.length != 0) {
            for (TFile dir : dirs) {
                TFile moduleProperties;
                if (!((File)dir).isDirectory() || !(moduleProperties = new TFile(((File)dir).getPath() + "/module.properties")).exists()) continue;
                TFileInputStream is = null;
                try {
                    moduleFound = true;
                    is = new TFileInputStream(moduleProperties);
                    moduleDetails.add(ModuleDetailsHelper.createModuleDetailsFromPropertiesStream(is));
                }
                catch (AlfrescoRuntimeException exception) {
                    throw new ModuleManagementToolException("Unable to open module properties file '" + moduleProperties.getPath() + "' " + exception.getMessage(), exception);
                }
                catch (IOException exception) {
                    throw new ModuleManagementToolException("Unable to open module properties file '" + moduleProperties.getPath() + "'", exception);
                }
                finally {
                    if (is != null) {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (Throwable e) {}
                    }
                }
            }
        }
        return moduleDetails;
    }

    @Override
    public String backup(TFile file) throws IOException {
        String backupLocation = file.getAbsolutePath() + "-" + System.currentTimeMillis() + ".bak";
        if (file.isArchive()) {
            this.log.info("Backing up file...");
            TFile source = new TFile(file.getAbsolutePath(), TArchiveDetector.NULL);
            TFile backup = new TFile(backupLocation, TArchiveDetector.NULL);
            source.cp_rp(backup);
        } else {
            this.log.info("Backing up DIRECTORY...");
            TFile backup = new TFile(backupLocation);
            file.cp_rp(backup);
        }
        this.log.info("The back up is at '" + backupLocation + "'");
        return backupLocation;
    }

    protected ModuleDetails getModuleDetails(TFile war, String moduleId) {
        ModuleDetailsImpl moduleDets = null;
        TFile theFile = this.getModuleDetailsFile(war, moduleId);
        if (theFile != null && theFile.exists()) {
            moduleDets = new ModuleDetailsImpl(this.loadProperties(theFile));
        }
        return moduleDets;
    }

    private Properties loadProperties(TFile propertiesFile) {
        Properties result = null;
        InputStream is = null;
        try {
            if (propertiesFile.exists()) {
                is = new TFileInputStream(propertiesFile);
                result = new Properties();
                result.load(is);
            }
        }
        catch (IOException exception) {
            throw new ModuleManagementToolException("Unable to load properties from the war file; " + propertiesFile.getPath(), exception);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Throwable e) {}
            }
        }
        return result;
    }

    private TFile getModuleDetailsFile(TFile war, String moduleId) {
        return new TFile(war.getAbsolutePath() + "/WEB-INF/classes/alfresco/module" + "/" + moduleId + "/module.properties");
    }
}

