/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis.mapping;

import java.io.Serializable;
import java.util.Collection;
import org.alfresco.opencmis.mapping.AbstractLuceneBuilder;
import org.alfresco.repo.search.impl.lucene.AbstractLuceneQueryParser;
import org.alfresco.repo.search.impl.lucene.AnalysisMode;
import org.alfresco.repo.search.impl.lucene.LuceneFunction;
import org.alfresco.repo.search.impl.querymodel.PredicateMode;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.namespace.QName;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSimpleLuceneBuilder
extends AbstractLuceneBuilder {
    protected AbstractSimpleLuceneBuilder() {
    }

    protected abstract String getValueAsString(Serializable var1);

    protected String getRangeMax() {
        return "\uffff";
    }

    protected String getRangeMin() {
        return "\u0000";
    }

    protected abstract DataTypeDefinition getInDataType();

    protected abstract QName getQNameForExists();

    @Override
    public Query buildLuceneEquality(AbstractLuceneQueryParser lqp, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws ParseException {
        return lqp.getFieldQuery(this.getLuceneFieldName(), this.getValueAsString(value), AnalysisMode.IDENTIFIER, luceneFunction);
    }

    @Override
    public Query buildLuceneExists(AbstractLuceneQueryParser lqp, Boolean not) throws ParseException {
        if (not.booleanValue()) {
            return lqp.getFieldQuery("ISNULL", this.getQNameForExists().toString(), AnalysisMode.DEFAULT, LuceneFunction.FIELD);
        }
        return lqp.getFieldQuery("ISNOTNULL", this.getQNameForExists().toString(), AnalysisMode.DEFAULT, LuceneFunction.FIELD);
    }

    @Override
    public Query buildLuceneGreaterThan(AbstractLuceneQueryParser lqp, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws ParseException {
        String field = this.getLuceneFieldName();
        String stringValue = this.getValueAsString(value);
        return lqp.getRangeQuery(field, stringValue, this.getRangeMax(), false, true, AnalysisMode.IDENTIFIER, luceneFunction);
    }

    @Override
    public Query buildLuceneGreaterThanOrEquals(AbstractLuceneQueryParser lqp, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws ParseException {
        String field = this.getLuceneFieldName();
        String stringValue = this.getValueAsString(value);
        return lqp.getRangeQuery(field, stringValue, this.getRangeMax(), true, true, AnalysisMode.IDENTIFIER, luceneFunction);
    }

    @Override
    public Query buildLuceneIn(AbstractLuceneQueryParser lqp, Collection<Serializable> values, Boolean not, PredicateMode mode) throws ParseException {
        String field = this.getLuceneFieldName();
        Collection<?> converted = DefaultTypeConverter.INSTANCE.convert(this.getInDataType(), values);
        Collection<String> asStrings = DefaultTypeConverter.INSTANCE.convert(String.class, values);
        if (asStrings.size() == 0) {
            if (not.booleanValue()) {
                return new MatchAllDocsQuery();
            }
            return new TermQuery(new Term("NO_TOKENS", "__"));
        }
        if (asStrings.size() == 1) {
            String value = asStrings.iterator().next();
            if (not.booleanValue()) {
                return lqp.getDoesNotMatchFieldQuery(field, value, AnalysisMode.IDENTIFIER, LuceneFunction.FIELD);
            }
            return lqp.getFieldQuery(field, value, AnalysisMode.IDENTIFIER, LuceneFunction.FIELD);
        }
        BooleanQuery booleanQuery = new BooleanQuery();
        if (not.booleanValue()) {
            booleanQuery.add((Query)new MatchAllDocsQuery(), BooleanClause.Occur.MUST);
        }
        for (String value : asStrings) {
            Query any = lqp.getFieldQuery(field, value, AnalysisMode.IDENTIFIER, LuceneFunction.FIELD);
            if (not.booleanValue()) {
                booleanQuery.add(any, BooleanClause.Occur.MUST_NOT);
                continue;
            }
            booleanQuery.add(any, BooleanClause.Occur.SHOULD);
        }
        return booleanQuery;
    }

    @Override
    public Query buildLuceneInequality(AbstractLuceneQueryParser lqp, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws ParseException {
        String field = this.getLuceneFieldName();
        String stringValue = this.getValueAsString(value);
        return lqp.getDoesNotMatchFieldQuery(field, stringValue, AnalysisMode.IDENTIFIER, luceneFunction);
    }

    @Override
    public Query buildLuceneLessThan(AbstractLuceneQueryParser lqp, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws ParseException {
        String field = this.getLuceneFieldName();
        String stringValue = this.getValueAsString(value);
        return lqp.getRangeQuery(field, this.getRangeMin(), stringValue, true, false, AnalysisMode.IDENTIFIER, luceneFunction);
    }

    @Override
    public Query buildLuceneLessThanOrEquals(AbstractLuceneQueryParser lqp, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws ParseException {
        String field = this.getLuceneFieldName();
        String stringValue = this.getValueAsString(value);
        return lqp.getRangeQuery(field, this.getRangeMin(), stringValue, true, true, AnalysisMode.IDENTIFIER, luceneFunction);
    }

    @Override
    public Query buildLuceneLike(AbstractLuceneQueryParser lqp, Serializable value, Boolean not) throws ParseException {
        String field = this.getLuceneFieldName();
        String stringValue = this.getValueAsString(value);
        if (not.booleanValue()) {
            BooleanQuery booleanQuery = new BooleanQuery();
            booleanQuery.add((Query)new MatchAllDocsQuery(), BooleanClause.Occur.MUST);
            booleanQuery.add(lqp.getLikeQuery(field, stringValue, AnalysisMode.IDENTIFIER), BooleanClause.Occur.MUST_NOT);
            return booleanQuery;
        }
        return lqp.getLikeQuery(field, stringValue, AnalysisMode.IDENTIFIER);
    }

    @Override
    public String getLuceneSortField(AbstractLuceneQueryParser lqp) {
        return this.getLuceneFieldName();
    }
}

