/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene;

import java.io.IOException;
import java.io.Reader;

public class MultiReader
extends Reader {
    Reader first;
    Reader second;
    boolean firstActive = true;

    public MultiReader(Reader first, Reader second) {
        this.first = first;
        this.second = second;
    }

    public void close() throws IOException {
        IOException ioe = null;
        try {
            this.first.close();
        }
        catch (IOException e) {
            ioe = e;
        }
        this.second.close();
        if (ioe != null) {
            throw ioe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(char[] cbuf, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            for (int i = 0; i < len; ++i) {
                int c;
                if (this.firstActive) {
                    c = this.first.read();
                    if (c == -1) {
                        this.firstActive = false;
                        c = this.second.read();
                    }
                } else {
                    c = this.second.read();
                }
                if (c == -1) {
                    if (i == 0) {
                        return -1;
                    }
                    return i;
                }
                cbuf[off + i] = (char)c;
            }
            return len;
        }
    }
}

