/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.querymodel.impl.lucene;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.alfresco.repo.search.impl.lucene.LuceneUtils;
import org.alfresco.repo.search.impl.querymodel.Column;
import org.alfresco.repo.search.impl.querymodel.Constraint;
import org.alfresco.repo.search.impl.querymodel.FunctionEvaluationContext;
import org.alfresco.repo.search.impl.querymodel.Order;
import org.alfresco.repo.search.impl.querymodel.Ordering;
import org.alfresco.repo.search.impl.querymodel.PropertyArgument;
import org.alfresco.repo.search.impl.querymodel.Selector;
import org.alfresco.repo.search.impl.querymodel.Source;
import org.alfresco.repo.search.impl.querymodel.impl.BaseQuery;
import org.alfresco.repo.search.impl.querymodel.impl.lucene.LuceneQueryBuilder;
import org.alfresco.repo.search.impl.querymodel.impl.lucene.LuceneQueryBuilderComponent;
import org.alfresco.repo.search.impl.querymodel.impl.lucene.LuceneQueryBuilderContext;
import org.alfresco.service.cmr.search.SearchParameters;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneQuery
extends BaseQuery
implements LuceneQueryBuilder {
    public LuceneQuery(List<Column> columns, Source source, Constraint constraint, List<Ordering> orderings) {
        super(columns, source, constraint, orderings);
    }

    @Override
    public Query buildQuery(Set<String> selectors, LuceneQueryBuilderContext luceneContext, FunctionEvaluationContext functionContext) throws ParseException {
        Constraint constraint;
        BooleanQuery luceneQuery = new BooleanQuery();
        boolean must = false;
        boolean should = false;
        boolean must_not = false;
        if (selectors != null) {
            for (String selector : selectors) {
                Selector current = this.getSource().getSelector(selector);
                if (current instanceof LuceneQueryBuilderComponent) {
                    LuceneQueryBuilderComponent luceneQueryBuilderComponent = (LuceneQueryBuilderComponent)((Object)current);
                    Query selectorQuery = luceneQueryBuilderComponent.addComponent(selectors, null, luceneContext, functionContext);
                    if (selectorQuery == null) continue;
                    luceneQuery.add(selectorQuery, BooleanClause.Occur.MUST);
                    must = true;
                    continue;
                }
                throw new UnsupportedOperationException();
            }
        }
        if ((constraint = this.getConstraint()) != null) {
            if (constraint instanceof LuceneQueryBuilderComponent) {
                LuceneQueryBuilderComponent luceneQueryBuilderComponent = (LuceneQueryBuilderComponent)((Object)constraint);
                Query constraintQuery = luceneQueryBuilderComponent.addComponent(selectors, null, luceneContext, functionContext);
                if (constraintQuery != null) {
                    constraintQuery.setBoost(constraint.getBoost());
                    switch (constraint.getOccur()) {
                        case DEFAULT: 
                        case MANDATORY: {
                            luceneQuery.add(constraintQuery, BooleanClause.Occur.MUST);
                            must = true;
                            break;
                        }
                        case OPTIONAL: {
                            luceneQuery.add(constraintQuery, BooleanClause.Occur.SHOULD);
                            should = true;
                            break;
                        }
                        case EXCLUDE: {
                            luceneQuery.add(constraintQuery, BooleanClause.Occur.MUST_NOT);
                            must_not = true;
                        }
                    }
                }
            } else {
                throw new UnsupportedOperationException();
            }
        }
        if (!must && must_not) {
            luceneQuery.add((Query)new TermQuery(new Term("ISNODE", "T")), BooleanClause.Occur.MUST);
        }
        return luceneQuery;
    }

    @Override
    public Sort buildSort(Set<String> selectors, LuceneQueryBuilderContext luceneContext, FunctionEvaluationContext functionContext) {
        if (this.getOrderings() == null || this.getOrderings().size() == 0) {
            return null;
        }
        int index = 0;
        SortField[] fields = new SortField[this.getOrderings().size()];
        for (Ordering ordering : this.getOrderings()) {
            if (ordering.getColumn().getFunction().getName().equals("PropertyAccessor")) {
                PropertyArgument property = (PropertyArgument)ordering.getColumn().getFunctionArguments().get("Property");
                if (property == null) {
                    throw new IllegalStateException();
                }
                String propertyName = property.getPropertyName();
                String luceneField = functionContext.getLuceneSortField(luceneContext.getLuceneQueryParser(), propertyName);
                if (luceneField != null) {
                    if (LuceneUtils.fieldHasTerm(luceneContext.getLuceneQueryParser().getIndexReader(), luceneField)) {
                        Locale locale = luceneContext.getLuceneQueryParser().getSearchParameters().getSortLocale();
                        fields[index++] = new SortField(luceneField, locale, ordering.getOrder() == Order.DESCENDING);
                        continue;
                    }
                    fields[index++] = new SortField(null, 1, ordering.getOrder() == Order.DESCENDING);
                    continue;
                }
                throw new IllegalStateException();
            }
            if (ordering.getColumn().getFunction().getName().equals("Score")) {
                fields[index++] = new SortField(null, 0, ordering.getOrder() != Order.DESCENDING);
                continue;
            }
            throw new IllegalStateException();
        }
        return new Sort(fields);
    }

    @Override
    public List<SearchParameters.SortDefinition> buildSortDefinitions(Set<String> selectors, LuceneQueryBuilderContext luceneContext, FunctionEvaluationContext functionContext) {
        if (this.getOrderings() == null || this.getOrderings().size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<SearchParameters.SortDefinition> definitions = new ArrayList<SearchParameters.SortDefinition>(this.getOrderings().size());
        for (Ordering ordering : this.getOrderings()) {
            if (ordering.getColumn().getFunction().getName().equals("PropertyAccessor")) {
                PropertyArgument property = (PropertyArgument)ordering.getColumn().getFunctionArguments().get("Property");
                if (property == null) {
                    throw new IllegalStateException();
                }
                String propertyName = property.getPropertyName();
                String fieldName = functionContext.getLuceneFieldName(propertyName);
                definitions.add(new SearchParameters.SortDefinition(SearchParameters.SortDefinition.SortType.FIELD, fieldName, ordering.getOrder() == Order.ASCENDING));
                continue;
            }
            if (!ordering.getColumn().getFunction().getName().equals("Score")) continue;
            definitions.add(new SearchParameters.SortDefinition(SearchParameters.SortDefinition.SortType.SCORE, null, ordering.getOrder() == Order.ASCENDING));
        }
        return definitions;
    }
}

