/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import org.alfresco.repo.search.impl.lucene.AbstractLuceneQueryParser;

public class SearchLanguageConversion {
    public static LanguageDefinition DEF_SQL_LIKE = new SimpleLanguageDef('\\', "%", "_", "\\%_[]");
    public static LanguageDefinition DEF_XPATH_LIKE = new SimpleLanguageDef('\\', "%", "_", "\\%_[]");
    public static LanguageDefinition DEF_REGEX = new SimpleLanguageDef('\\', ".*", ".", "\\*.+?^$(){}[]|");
    public static LanguageDefinition DEF_LUCENE = new LuceneLanguageDef(true);
    public static LanguageDefinition DEF_LUCENE_INTERNAL = new LuceneLanguageDef(false);
    public static LanguageDefinition DEF_CIFS = new SimpleLanguageDef('\\', "*", "?", "\"*\\<>?/:|\u00ac\u00a3%&+;");

    public static String escapeForXPathLike(String str) {
        return SearchLanguageConversion.escape(DEF_XPATH_LIKE, str);
    }

    public static String escapeForRegex(String str) {
        return SearchLanguageConversion.escape(DEF_REGEX, str);
    }

    public static String escapeForLucene(String str) {
        return SearchLanguageConversion.escape(DEF_LUCENE, str);
    }

    private static String escape(LanguageDefinition def, String str) {
        StringBuilder sb = new StringBuilder(str.length() * 2);
        char[] chars = str.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (def.isReserved(chars[i])) {
                sb.append(def.escapeChar);
            }
            sb.append(chars[i]);
        }
        return sb.toString();
    }

    public static String convertXPathLikeToRegex(String xpathLikeClause) {
        return "(?s)" + SearchLanguageConversion.convert(DEF_XPATH_LIKE, DEF_REGEX, xpathLikeClause);
    }

    public static String convertXPathLikeToLucene(String xpathLikeClause) {
        return SearchLanguageConversion.convert(DEF_XPATH_LIKE, DEF_LUCENE, xpathLikeClause);
    }

    public static String convertSQLLikeToLucene(String sqlLikeClause) {
        return SearchLanguageConversion.convert(DEF_SQL_LIKE, DEF_LUCENE_INTERNAL, sqlLikeClause);
    }

    public static String convertSQLLikeToRegex(String sqlLikeClause) {
        return "(?s)" + SearchLanguageConversion.convert(DEF_SQL_LIKE, DEF_REGEX, sqlLikeClause);
    }

    public static String convertCifsToLucene(String cifsNamePath) {
        return SearchLanguageConversion.convert(DEF_CIFS, DEF_LUCENE, cifsNamePath);
    }

    public static String convert(LanguageDefinition from, LanguageDefinition to, String query) {
        char[] chars = query.toCharArray();
        StringBuilder sb = new StringBuilder(chars.length * 2);
        boolean escaping = false;
        for (int i = 0; i < chars.length; ++i) {
            if (escaping) {
                if (to.isReserved(chars[i])) {
                    sb.append(to.escapeChar);
                }
                sb.append(chars[i]);
                escaping = false;
                continue;
            }
            if (chars[i] == from.escapeChar) {
                escaping = true;
                continue;
            }
            if (query.startsWith(from.multiCharWildcard, i)) {
                sb.append(to.multiCharWildcard);
                continue;
            }
            if (query.startsWith(from.singleCharWildcard, i)) {
                sb.append(to.singleCharWildcard);
                continue;
            }
            if (to.isReserved(chars[i])) {
                sb.append(to.escapeChar).append(chars[i]);
                continue;
            }
            sb.append(chars[i]);
        }
        return sb.toString();
    }

    private static class LuceneLanguageDef
    extends LanguageDefinition {
        private String reserved;

        public LuceneLanguageDef(boolean reserve) {
            super('\\', "*", "?");
            if (reserve) {
                this.init();
            } else {
                this.reserved = "";
            }
        }

        private void init() {
            StringBuilder sb = new StringBuilder(20);
            for (char ch = '\u0000'; ch < '\u0100'; ch = (char)(ch + '\u0001')) {
                char[] chars = new char[]{ch};
                String unescaped = new String(chars);
                String escaped = AbstractLuceneQueryParser.escape((String)unescaped);
                if (escaped.equals(unescaped)) continue;
                sb.append(ch);
            }
            this.reserved = sb.toString();
        }

        public boolean isReserved(char ch) {
            return this.reserved.indexOf(ch) > -1;
        }
    }

    private static class SimpleLanguageDef
    extends LanguageDefinition {
        private String reserved;

        public SimpleLanguageDef(char escapeChar, String multiCharWildcard, String singleCharWildcard, String reserved) {
            super(escapeChar, multiCharWildcard, singleCharWildcard);
            this.reserved = reserved;
        }

        public boolean isReserved(char ch) {
            return this.reserved.indexOf(ch) > -1;
        }
    }

    public static abstract class LanguageDefinition {
        public final char escapeChar;
        public final String multiCharWildcard;
        public final String singleCharWildcard;

        public LanguageDefinition(char escapeChar, String multiCharWildcard, String singleCharWildcard) {
            this.escapeChar = escapeChar;
            this.multiCharWildcard = multiCharWildcard;
            this.singleCharWildcard = singleCharWildcard;
        }

        public abstract boolean isReserved(char var1);
    }
}

